/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.Context;
import android.preference.ListPreference;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.R;

public class LocaleListPreference
extends ListPreference {
    private static final String LOG_TAG = "GeckoLocaleList";
    private volatile Locale entriesLocale;

    public LocaleListPreference(Context context) {
        this(context, null);
    }

    public LocaleListPreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.buildList();
    }

    private LocaleDescriptor[] getShippingLocales() {
        Collection<String> collection = BrowserLocaleManager.getPackagedLocaleTags(this.getContext());
        if (collection == null) {
            String string2 = BrowserLocaleManager.getFallbackLocaleTag();
            return new LocaleDescriptor[]{new LocaleDescriptor(string2)};
        }
        int n = collection.size();
        Object[] objectArray = new LocaleDescriptor[n];
        int n2 = 0;
        for (String string3 : collection) {
            objectArray[n2++] = new LocaleDescriptor(string3);
        }
        Arrays.sort(objectArray, 0, n);
        return objectArray;
    }

    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        Locale locale = this.getSelectedLocale();
        Context context = this.getContext();
        BrowserLocaleManager.getInstance().updateConfiguration(context, locale);
    }

    private Locale getSelectedLocale() {
        String string2 = this.getValue();
        if (string2 == null || string2.equals("")) {
            return Locale.getDefault();
        }
        return BrowserLocaleManager.parseLocaleCode(string2);
    }

    public CharSequence getSummary() {
        String string2 = this.getValue();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return this.getContext().getString(R.string.locale_system_default);
        }
        Locale locale = new Locale(string2);
        return locale.getDisplayName(locale);
    }

    private void buildList() {
        Locale locale = Locale.getDefault();
        Log.d((String)LOG_TAG, (String)("Building locales list. Current locale: " + locale));
        if (locale.equals(this.entriesLocale) && this.getEntries() != null) {
            Log.v((String)LOG_TAG, (String)"No need to build list.");
            return;
        }
        LocaleDescriptor[] localeDescriptorArray = this.getShippingLocales();
        int n = localeDescriptorArray.length;
        this.entriesLocale = locale;
        CharSequence[] charSequenceArray = new String[n + 1];
        CharSequence[] charSequenceArray2 = new String[n + 1];
        charSequenceArray[0] = this.getContext().getString(R.string.locale_system_default);
        charSequenceArray2[0] = "";
        for (int i = 0; i < n; ++i) {
            charSequenceArray[i + 1] = localeDescriptorArray[i].getDisplayName();
            charSequenceArray2[i + 1] = localeDescriptorArray[i].getTag();
        }
        this.setEntries(charSequenceArray);
        this.setEntryValues(charSequenceArray2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LocaleDescriptor
    implements Comparable<LocaleDescriptor> {
        private static final Collator COLLATOR = Collator.getInstance(Locale.US);
        public final String tag;
        private final String nativeName;

        public LocaleDescriptor(String string2) {
            this(BrowserLocaleManager.parseLocaleCode(string2), string2);
        }

        public LocaleDescriptor(Locale locale, String string2) {
            this.nativeName = locale.getDisplayName(locale);
            this.tag = string2;
        }

        public String getTag() {
            return this.tag;
        }

        public String getDisplayName() {
            return this.nativeName;
        }

        public String toString() {
            return this.nativeName;
        }

        @Override
        public int compareTo(LocaleDescriptor localeDescriptor) {
            return COLLATOR.compare(this.nativeName, localeDescriptor.nativeName);
        }
    }
}

