/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.setup.activities;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.StrictMode;
import android.support.v4.app.FragmentActivity;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.LocaleManager;

public class LocaleAware {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=9)
    public static void initializeLocale(Context context) {
        LocaleManager localeManager = BrowserLocaleManager.getInstance();
        if (Build.VERSION.SDK_INT < 9) {
            localeManager.getAndApplyPersistedLocale(context);
        } else {
            StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
            StrictMode.allowThreadDiskWrites();
            try {
                localeManager.getAndApplyPersistedLocale(context);
            }
            finally {
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
            }
        }
    }

    public static class LocaleAwareActivity
    extends Activity {
        protected void onCreate(Bundle bundle) {
            LocaleAware.initializeLocale(this.getApplicationContext());
            super.onCreate(bundle);
        }
    }

    public static class LocaleAwareFragmentActivity
    extends FragmentActivity {
        protected void onCreate(Bundle bundle) {
            LocaleAware.initializeLocale(this.getApplicationContext());
            super.onCreate(bundle);
        }
    }
}

