/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.View;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.LightweightTheme;
import org.mozilla.gecko.LightweightThemeDrawable;
import org.mozilla.gecko.R;
import org.mozilla.gecko.toolbar.CanvasDelegate;
import org.mozilla.gecko.widget.ThemedImageButton;

public class ShapedButton
extends ThemedImageButton
implements CanvasDelegate.DrawManager {
    protected final LightweightTheme mTheme;
    private final Path mPath;
    private final CurveTowards mSide;
    protected final CanvasDelegate mCanvasDelegate;

    public ShapedButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mTheme = ((GeckoApplication)context.getApplicationContext()).getLightweightTheme();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.BrowserToolbarCurve);
        int n = typedArray.getInt(0, 0);
        typedArray.recycle();
        this.mSide = n == 0 ? CurveTowards.NONE : (n == 1 ? CurveTowards.LEFT : CurveTowards.RIGHT);
        this.mPath = new Path();
        this.mCanvasDelegate = new CanvasDelegate(this, PorterDuff.Mode.DST_IN);
        this.setWillNotDraw(false);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (this.mSide == CurveTowards.NONE) {
            return;
        }
        int n5 = (int)((float)n2 * 1.125f);
        this.mPath.reset();
        if (this.mSide == CurveTowards.RIGHT) {
            this.mPath.moveTo(0.0f, 0.0f);
            this.mPath.cubicTo((float)n5 * 0.75f, 0.0f, (float)n5 * 0.25f, (float)n2, (float)n5, (float)n2);
            this.mPath.lineTo((float)n, (float)n2);
            this.mPath.lineTo((float)n, 0.0f);
            this.mPath.lineTo(0.0f, 0.0f);
        } else if (this.mSide == CurveTowards.LEFT) {
            this.mPath.moveTo((float)n, 0.0f);
            this.mPath.cubicTo((float)n - (float)n5 * 0.75f, 0.0f, (float)n - (float)n5 * 0.25f, (float)n2, (float)(n - n5), (float)n2);
            this.mPath.lineTo(0.0f, (float)n2);
            this.mPath.lineTo(0.0f, 0.0f);
        }
    }

    public void draw(Canvas canvas) {
        if (this.mCanvasDelegate != null && this.mSide != CurveTowards.NONE) {
            this.mCanvasDelegate.draw(canvas, this.mPath, this.getWidth(), this.getHeight());
        } else {
            this.defaultDraw(canvas);
        }
    }

    public void defaultDraw(Canvas canvas) {
        super.draw(canvas);
    }

    public void onLightweightThemeChanged() {
        int n = this.getResources().getColor(R.color.background_tabs);
        LightweightThemeDrawable lightweightThemeDrawable = this.mTheme.getColorDrawable((View)this, n);
        if (lightweightThemeDrawable == null) {
            return;
        }
        lightweightThemeDrawable.setAlpha(34, 34);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(PRESSED_ENABLED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_shaped));
        stateListDrawable.addState(FOCUSED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_shaped_focused));
        stateListDrawable.addState(PRIVATE_STATE_SET, (Drawable)this.getColorDrawable(R.color.background_tabs));
        stateListDrawable.addState(EMPTY_STATE_SET, (Drawable)lightweightThemeDrawable);
        this.setBackgroundDrawable((Drawable)stateListDrawable);
    }

    public void onLightweightThemeReset() {
        this.setBackgroundResource(R.drawable.shaped_button);
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        if (this.getBackground() == null || drawable2 == null) {
            super.setBackgroundDrawable(drawable2);
            return;
        }
        int[] nArray = new int[]{this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom()};
        drawable2.setLevel(this.getBackground().getLevel());
        super.setBackgroundDrawable(drawable2);
        this.setPadding(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public void setBackgroundResource(int n) {
        this.setBackgroundDrawable(this.getResources().getDrawable(n));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CurveTowards {
        NONE,
        LEFT,
        RIGHT;

    }
}

