/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.webapp;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Process;
import android.util.Log;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.ActivityHandlerHelper;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.WebappAllocator;
import org.mozilla.gecko.favicons.decoders.FaviconDecoder;
import org.mozilla.gecko.util.ActivityResultHandler;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.webapp.Allocator;
import org.mozilla.gecko.webapp.InstallListener;

public class EventListener
implements NativeEventListener {
    private static final String LOGTAG = "GeckoWebappEventListener";
    private static final int DEFAULT_VERSION_CODE = -1;

    public void registerEvents() {
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Webapps:Preinstall", "Webapps:InstallApk", "Webapps:Postinstall", "Webapps:Open", "Webapps:Uninstall", "Webapps:GetApkVersions");
    }

    public void unregisterEvents() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Webapps:Preinstall", "Webapps:InstallApk", "Webapps:Postinstall", "Webapps:Open", "Webapps:Uninstall", "Webapps:GetApkVersions");
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        try {
            if (string2.equals("Webapps:InstallApk")) {
                EventListener.installApk(GeckoAppShell.getGeckoInterface().getActivity(), nativeJSObject, eventCallback);
            } else if (string2.equals("Webapps:Postinstall")) {
                EventListener.postInstallWebapp(nativeJSObject.getString("apkPackageName"), nativeJSObject.getString("origin"));
            } else if (string2.equals("Webapps:Open")) {
                Intent intent = GeckoAppShell.getWebappIntent(nativeJSObject.getString("manifestURL"), nativeJSObject.getString("origin"), "", null);
                if (intent == null) {
                    return;
                }
                GeckoAppShell.getGeckoInterface().getActivity().startActivity(intent);
            } else if (string2.equals("Webapps:GetApkVersions")) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("versions", (Object)EventListener.getApkVersions(GeckoAppShell.getGeckoInterface().getActivity(), nativeJSObject.getStringArray("packageNames")));
                eventCallback.sendSuccess((Object)jSONObject);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    public static File preInstallWebapp(String string2, String string3, String string4) {
        int n = WebappAllocator.getInstance(GeckoAppShell.getContext()).findAndAllocateIndex(string4, string2, (String)null);
        GeckoProfile geckoProfile = GeckoProfile.get(GeckoAppShell.getContext(), "webapp" + n);
        return geckoProfile.getDir();
    }

    public static void postInstallWebapp(String string2, String string3, String string4, String string5, String string6) {
        WebappAllocator webappAllocator = WebappAllocator.getInstance(GeckoAppShell.getContext());
        int n = webappAllocator.getIndexForApp(string6);
        assert (string5 != null);
        int n2 = GeckoAppShell.getPreferredIconSize();
        Bitmap bitmap = FaviconDecoder.getMostSuitableBitmapFromDataURI(string5, n2);
        assert (string4 != null && n != -1);
        webappAllocator.updateAppAllocation(string4, n, bitmap);
        GeckoAppShell.createShortcut(string2, string3, string4, bitmap, "webapp");
    }

    public static void postInstallWebapp(String string2, String string3) {
        Allocator allocator = Allocator.getInstance(GeckoAppShell.getContext());
        int n = allocator.findOrAllocatePackage(string2);
        allocator.putOrigin(n, string3);
    }

    public static void uninstallWebapp(final String string2) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                int n = Allocator.getInstance(GeckoAppShell.getContext()).releaseIndexForApp(string2);
                if (n == -1) {
                    return;
                }
                EventListener.killWebappSlot(GeckoAppShell.getContext(), n);
                GeckoProfile.removeProfile(GeckoAppShell.getContext(), "webapp" + n);
            }
        });
    }

    public static void killWebappSlot(Context context, int n) {
        String string2 = context.getPackageName();
        string2 = string2 + ":" + string2 + ".Webapp" + n;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningAppProcesses();
        if (list != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (!runningAppProcessInfo.processName.equals(string2)) continue;
                Process.killProcess((int)runningAppProcessInfo.pid);
                break;
            }
        }
    }

    public static void installApk(final Activity activity, NativeJSObject nativeJSObject, final EventCallback eventCallback) {
        JSONObject jSONObject;
        String string2 = null;
        String string3 = null;
        try {
            string3 = nativeJSObject.getString("filePath");
            jSONObject = new JSONObject(nativeJSObject.getObject("data").toString());
            string2 = jSONObject.getJSONObject("app").getString("manifestURL");
        }
        catch (JSONException jSONException) {
            Log.wtf((String)LOGTAG, (String)"Error getting file path and data", (Throwable)jSONException);
            eventCallback.sendError((Object)("Error getting file path and data: " + jSONException.toString()));
            return;
        }
        final InstallListener installListener = new InstallListener(string2, jSONObject);
        IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        intentFilter.addDataScheme("package");
        activity.registerReceiver((BroadcastReceiver)installListener, intentFilter);
        File file = new File(string3);
        if (!file.exists()) {
            Log.wtf((String)LOGTAG, (String)("APK file doesn't exist at path " + string3));
            eventCallback.sendError((Object)("APK file doesn't exist at path " + string3));
            return;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
        ActivityHandlerHelper.startIntentForActivity(activity, intent, new ActivityResultHandler(){

            public void onActivityResult(int n, Intent intent) {
                if (n == 0) {
                    try {
                        activity.unregisterReceiver((BroadcastReceiver)installListener);
                        installListener.cleanup();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Log.e((String)EventListener.LOGTAG, (String)"error unregistering install receiver: ", (Throwable)illegalArgumentException);
                    }
                    eventCallback.sendError((Object)"APK installation cancelled by user");
                }
            }
        });
    }

    public static JSONObject getApkVersions(Activity activity, String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        PackageManager packageManager = activity.getPackageManager();
        List list = packageManager.getInstalledApplications(0);
        JSONObject jSONObject = new JSONObject();
        for (ApplicationInfo applicationInfo : list) {
            if (!hashSet.contains(applicationInfo.packageName)) continue;
            int n = -1;
            try {
                n = packageManager.getPackageInfo((String)applicationInfo.packageName, (int)0).versionCode;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.e((String)LOGTAG, (String)("couldn't get version for app " + applicationInfo.packageName), (Throwable)nameNotFoundException);
            }
            try {
                jSONObject.put(applicationInfo.packageName, n);
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)("unable to store version code field for app " + applicationInfo.packageName), (Throwable)jSONException);
            }
        }
        return jSONObject;
    }
}

