/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.animation.PropertyAnimator;

public class ButtonToast {
    private static final String LOGTAG = "GeckoButtonToast";
    private static final int TOAST_DURATION = 5000;
    private final View mView;
    private final TextView mMessageView;
    private final Button mButton;
    private final Handler mHideHandler = new Handler();
    private Toast mCurrentToast;
    private Runnable mHideRunnable = new Runnable(){

        public void run() {
            ButtonToast.this.hide(false, ReasonHidden.TIMEOUT);
        }
    };

    public ButtonToast(View view) {
        this.mView = view;
        this.mMessageView = (TextView)this.mView.findViewById(R.id.toast_message);
        this.mButton = (Button)this.mView.findViewById(R.id.toast_button);
        this.mButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Toast toast = ButtonToast.this.mCurrentToast;
                if (toast == null) {
                    return;
                }
                ButtonToast.this.hide(false, ReasonHidden.CLICKED);
                if (toast.listener != null) {
                    toast.listener.onButtonClicked();
                }
            }
        });
        this.hide(true, ReasonHidden.STARTUP);
    }

    public void show(boolean bl, CharSequence charSequence, CharSequence charSequence2, int n, ToastListener toastListener) {
        Drawable drawable2 = this.mView.getContext().getResources().getDrawable(n);
        this.show(false, charSequence, charSequence2, drawable2, toastListener);
    }

    public void show(boolean bl, CharSequence charSequence, CharSequence charSequence2, Drawable drawable2, ToastListener toastListener) {
        this.show(new Toast(charSequence, charSequence2, drawable2, toastListener), bl);
    }

    private void show(Toast toast, boolean bl) {
        if (this.mCurrentToast != null) {
            this.hide(true, ReasonHidden.REPLACED);
            bl = true;
        }
        this.mCurrentToast = toast;
        this.mButton.setEnabled(true);
        this.mMessageView.setText(null != toast.message ? toast.message : "");
        this.mButton.setText(null != toast.buttonMessage ? toast.buttonMessage : "");
        this.mButton.setCompoundDrawablesWithIntrinsicBounds(toast.buttonDrawable, null, null, null);
        this.mHideHandler.removeCallbacks(this.mHideRunnable);
        this.mHideHandler.postDelayed(this.mHideRunnable, 5000L);
        this.mView.setVisibility(0);
        int n = bl ? 0 : this.mView.getResources().getInteger(17694722);
        PropertyAnimator propertyAnimator = new PropertyAnimator(n);
        propertyAnimator.attach(this.mView, PropertyAnimator.Property.ALPHA, 1.0f);
        propertyAnimator.start();
    }

    public void hide(boolean bl, ReasonHidden reasonHidden) {
        if (this.mCurrentToast != null && this.mCurrentToast.listener != null) {
            this.mCurrentToast.listener.onToastHidden(reasonHidden);
        }
        this.mCurrentToast = null;
        this.mButton.setEnabled(false);
        this.mHideHandler.removeCallbacks(this.mHideRunnable);
        int n = bl ? 0 : this.mView.getResources().getInteger(17694722);
        this.mView.clearAnimation();
        if (bl) {
            this.mView.setVisibility(8);
        } else {
            PropertyAnimator propertyAnimator = new PropertyAnimator(n);
            propertyAnimator.attach(this.mView, PropertyAnimator.Property.ALPHA, 0.0f);
            propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

                public void onPropertyAnimationEnd() {
                    ButtonToast.this.mView.clearAnimation();
                    ButtonToast.this.mView.setVisibility(8);
                }

                public void onPropertyAnimationStart() {
                }
            });
            propertyAnimator.start();
        }
    }

    public static interface ToastListener {
        public void onButtonClicked();

        public void onToastHidden(ReasonHidden var1);
    }

    private static class Toast {
        public final CharSequence buttonMessage;
        public Drawable buttonDrawable;
        public final CharSequence message;
        public ToastListener listener;

        public Toast(CharSequence charSequence, CharSequence charSequence2, Drawable drawable2, ToastListener toastListener) {
            this.message = charSequence;
            this.buttonMessage = charSequence2;
            this.buttonDrawable = drawable2;
            this.listener = toastListener;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReasonHidden {
        CLICKED,
        TIMEOUT,
        REPLACED,
        STARTUP;

    }
}

