/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.mozglue;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.util.Log;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.mozilla.gecko.mozglue.RobocopTarget;

public final class GeckoLoader {
    private static final String LOGTAG = "GeckoLoader";
    private static final String ANDROID_PACKAGE_NAME = "org.mozilla.fennec";
    private static volatile Intent sIntent;
    private static File sCacheFile;
    private static File sGREDir;
    private static final Object sLibLoadingLock;
    private static boolean sSQLiteLibsLoaded;
    private static boolean sNSSLibsLoaded;
    private static boolean sMozGlueLoaded;
    private static boolean sLibsSetup;

    private GeckoLoader() {
    }

    public static File getCacheDir(Context context) {
        if (sCacheFile == null) {
            sCacheFile = context.getCacheDir();
        }
        return sCacheFile;
    }

    public static File getGREDir(Context context) {
        if (sGREDir == null) {
            sGREDir = new File(context.getApplicationInfo().dataDir);
        }
        return sGREDir;
    }

    private static void setupPluginEnvironment(Context context, String[] stringArray) {
        try {
            if (stringArray == null) {
                GeckoLoader.putenv("MOZ_PLUGINS_BLOCKED=1");
                GeckoLoader.putenv("MOZ_PLUGIN_PATH=");
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]);
                stringBuilder.append(":");
            }
            GeckoLoader.putenv("MOZ_PLUGIN_PATH=" + stringBuilder);
            File file = context.getDir("plugins", 0);
            GeckoLoader.putenv("ANDROID_PLUGIN_DATADIR=" + file.getPath());
            File file2 = context.getDir("plugins_private", 0);
            GeckoLoader.putenv("ANDROID_PLUGIN_DATADIR_PRIVATE=" + file2.getPath());
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Caught exception getting plugin dirs.", (Throwable)exception);
        }
    }

    private static void setupDownloadEnvironment(Context context) {
        try {
            File file = null;
            File file2 = null;
            if (Build.VERSION.SDK_INT >= 8) {
                file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
                file2 = context.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS);
            }
            if (file == null) {
                file = new File(Environment.getExternalStorageDirectory().getPath(), "download");
            }
            if (file2 == null) {
                file2 = file;
            }
            GeckoLoader.putenv("DOWNLOADS_DIRECTORY=" + file.getPath());
            GeckoLoader.putenv("UPDATES_DIRECTORY=" + file2.getPath());
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"No download directory found.", (Throwable)exception);
        }
    }

    private static void delTree(File file) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                GeckoLoader.delTree(file2);
            }
        }
        file.delete();
    }

    private static File getTmpDir(Context context) {
        File file = context.getDir("tmpdir", 0);
        File file2 = new File(file.getParentFile(), "app_tmp");
        if (file2.exists()) {
            GeckoLoader.delTree(file2);
        }
        return file;
    }

    public static void setLastIntent(Intent intent) {
        sIntent = intent;
    }

    public static void setupGeckoEnvironment(Context context, String[] stringArray, String string) {
        Object object;
        Intent intent = sIntent;
        if (intent != null) {
            object = intent.getStringExtra("env0");
            Log.d((String)LOGTAG, (String)("Gecko environment env0: " + (String)object));
            int n = 1;
            while (object != null) {
                GeckoLoader.putenv((String)object);
                object = intent.getStringExtra("env" + n);
                Log.d((String)LOGTAG, (String)("env" + n + ": " + (String)object));
                ++n;
            }
        }
        GeckoLoader.setupPluginEnvironment(context, stringArray);
        GeckoLoader.setupDownloadEnvironment(context);
        GeckoLoader.putenv("HOME=" + string);
        object = GeckoLoader.getTmpDir(context);
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        GeckoLoader.putenv("TMPDIR=" + ((File)object).getPath());
        object = Environment.getDownloadCacheDirectory();
        GeckoLoader.putenv("EXTERNAL_STORAGE=" + ((File)object).getPath());
        object = context.getCacheDir();
        GeckoLoader.putenv("CACHE_DIRECTORY=" + ((File)object).getPath());
        try {
            Object object2 = context.getSystemService("user");
            if (object2 != null) {
                Object object3 = Process.class.getMethod("myUserHandle", null).invoke(null, new Object[0]);
                Object object4 = object2.getClass().getMethod("getSerialNumberForUser", object3.getClass()).invoke(object2, object3);
                GeckoLoader.putenv("MOZ_ANDROID_USER_SERIAL_NUMBER=" + object4.toString());
            }
        }
        catch (Exception exception) {
            Log.d((String)LOGTAG, (String)"Unable to set the user serial number", (Throwable)exception);
        }
        GeckoLoader.setupLocaleEnvironment();
        sIntent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibsSetup(Context context) {
        Object object = sLibLoadingLock;
        synchronized (object) {
            if (sLibsSetup) {
                return;
            }
            sLibsSetup = true;
        }
        object = GeckoLoader.getCacheDir(context);
        GeckoLoader.putenv("GRE_HOME=" + GeckoLoader.getGREDir(context).getPath());
        String string = System.getenv("MOZ_LINKER_CACHE");
        if (string == null) {
            string = ((File)object).getPath();
            GeckoLoader.putenv("MOZ_LINKER_CACHE=" + string);
        }
        if ("HTC".equals(Build.MANUFACTURER) && "HTC Vision".equals(Build.MODEL)) {
            GeckoLoader.putenv("MOZ_LINKER_ONDEMAND=0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RobocopTarget
    public static void loadSQLiteLibs(Context context, String string) {
        Object object = sLibLoadingLock;
        synchronized (object) {
            if (sSQLiteLibsLoaded) {
                return;
            }
            sSQLiteLibsLoaded = true;
        }
        GeckoLoader.loadMozGlue();
        GeckoLoader.loadLibsSetup(context);
        GeckoLoader.loadSQLiteLibsNative(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadNSSLibs(Context context, String string) {
        Object object = sLibLoadingLock;
        synchronized (object) {
            if (sNSSLibsLoaded) {
                return;
            }
            sNSSLibsLoaded = true;
        }
        GeckoLoader.loadMozGlue();
        GeckoLoader.loadLibsSetup(context);
        GeckoLoader.loadNSSLibsNative(string, false);
    }

    public static void doLoadLibrary(String string) {
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Log.wtf((String)LOGTAG, (String)("Couldn't load " + string + ". Trying /data/app-lib path."));
            try {
                System.load("/data/app-lib/org.mozilla.fennec/lib" + string + ".so");
            }
            catch (Throwable throwable) {
                try {
                    Log.wtf((String)LOGTAG, (String)("Couldn't load " + string + ": " + throwable + ". Trying /data/data path."));
                    System.load("/data/data/org.mozilla.fennec/lib/lib" + string + ".so");
                }
                catch (Throwable throwable2) {
                    Log.wtf((String)LOGTAG, (String)("Failed every attempt to load " + string + ". Giving up."));
                    throw new RuntimeException("Unable to load " + string, throwable2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadMozGlue() {
        Object object = sLibLoadingLock;
        synchronized (object) {
            if (sMozGlueLoaded) {
                return;
            }
            sMozGlueLoaded = true;
        }
        GeckoLoader.doLoadLibrary("mozglue");
    }

    public static void loadGeckoLibs(Context context, String string) {
        GeckoLoader.loadLibsSetup(context);
        GeckoLoader.loadGeckoLibsNative(string);
    }

    private static void setupLocaleEnvironment() {
        GeckoLoader.putenv("LANG=" + Locale.getDefault().toString());
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            GeckoLoader.putenv("LOCALE_DECIMAL_POINT=" + decimalFormatSymbols.getDecimalSeparator());
            GeckoLoader.putenv("LOCALE_THOUSANDS_SEP=" + decimalFormatSymbols.getGroupingSeparator());
            GeckoLoader.putenv("LOCALE_GROUPING=" + (char)decimalFormat.getGroupingSize());
        }
    }

    private static native void putenv(String var0);

    public static native void nativeRun(String var0);

    private static native void loadGeckoLibsNative(String var0);

    private static native void loadSQLiteLibsNative(String var0, boolean var1);

    private static native void loadNSSLibsNative(String var0, boolean var1);

    static {
        sLibLoadingLock = new Object();
    }
}

