/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.WebappAllocator;

public class WebappImpl
extends GeckoApp {
    private static final String LOGTAG = "GeckoWebappImpl";
    private URI mOrigin;
    private TextView mTitlebarText = null;
    private View mTitlebar = null;
    private View mSplashscreen;

    protected int getIndex() {
        return 0;
    }

    public int getLayout() {
        return R.layout.web_app;
    }

    public boolean hasTabsSideBar() {
        return false;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mSplashscreen = (RelativeLayout)this.findViewById(R.id.splashscreen);
        if (!GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            this.overridePendingTransition(R.anim.grow_fade_in_center, 0x10A0001);
            this.showSplash();
        }
        String string2 = this.getIntent().getAction();
        Bundle bundle2 = this.getIntent().getExtras();
        String string3 = bundle2 != null ? bundle2.getString("android.intent.extra.shortcut.NAME") : null;
        this.setTitle(string3 != null ? string3 : "Web App");
        this.mTitlebarText = (TextView)this.findViewById(R.id.webapp_title);
        this.mTitlebar = this.findViewById(R.id.webapp_titlebar);
        if (!string2.startsWith("org.mozilla.gecko.WEBAPP")) {
            Log.e((String)LOGTAG, (String)("Webapp launch, but intent action is " + string2 + "!"));
            return;
        }
        String string4 = WebappAllocator.getInstance((Context)this).getAppForIndex(this.getIndex());
        try {
            this.mOrigin = new URI(string4);
        }
        catch (URISyntaxException uRISyntaxException) {
            if (!string4.startsWith("app://")) {
                return;
            }
            Log.i((String)LOGTAG, (String)"Webapp is not registered with allocator");
            try {
                this.mOrigin = new URI(this.getIntent().getData().toString());
            }
            catch (URISyntaxException uRISyntaxException2) {
                Log.e((String)LOGTAG, (String)"Unable to parse intent url: ", (Throwable)uRISyntaxException);
            }
        }
    }

    protected void loadStartupTab(String string2) {
        String string3 = this.getIntent().getAction();
        if ("org.mozilla.gecko.WEBAPP".equals(string3)) {
            int n = WebappAllocator.getInstance((Context)this).findAndAllocateIndex(string2, "App", (Bitmap)null);
            Intent intent = GeckoAppShell.getWebappIntent(n, string2);
            this.startActivity(intent);
            this.finish();
        }
    }

    private void showSplash() {
        SharedPreferences sharedPreferences = this.getSharedPreferences("webapps", 4);
        int[] nArray = new int[2];
        int n = sharedPreferences.getInt(WebappAllocator.iconKey(this.getIndex()), -1);
        float[] fArray = new float[3];
        Color.colorToHSV((int)n, (float[])fArray);
        fArray[2] = Math.min(fArray[2] * 2.0f, 1.0f);
        nArray[0] = Color.HSVToColor((int)255, (float[])fArray);
        fArray[2] = (float)((double)fArray[2] * 0.75);
        nArray[1] = Color.HSVToColor((int)255, (float[])fArray);
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TL_BR, nArray);
        gradientDrawable.setGradientType(1);
        Display display = this.getWindowManager().getDefaultDisplay();
        gradientDrawable.setGradientCenter(0.5f, 0.5f);
        gradientDrawable.setGradientRadius((float)Math.max(display.getWidth() / 2, display.getHeight() / 2));
        this.mSplashscreen.setBackgroundDrawable((Drawable)gradientDrawable);
        File file = this.getProfile().getDir();
        File file2 = new File(file, "logo.png");
        if (file2.exists()) {
            ImageView imageView = (ImageView)this.findViewById(R.id.splashscreen_icon);
            Drawable drawable2 = Drawable.createFromPath((String)file2.getPath());
            imageView.setImageDrawable(drawable2);
            Animation animation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.grow_fade_in_center);
            animation.setStartOffset(500L);
            animation.setDuration(1000L);
            imageView.startAnimation(animation);
        }
    }

    protected String getDefaultProfileName() {
        String string2 = this.getIntent().getAction();
        if (!string2.startsWith("org.mozilla.gecko.WEBAPP")) {
            Log.e((String)LOGTAG, (String)("Webapp launch, but intent action is " + string2 + "!"));
            return null;
        }
        return "webapp" + string2.substring("org.mozilla.gecko.WEBAPP".length());
    }

    protected boolean getSessionRestoreState(Bundle bundle) {
        return false;
    }

    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case SELECTED: 
            case LOCATION_CHANGE: {
                URI uRI;
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                String string2 = tab.getURL();
                try {
                    uRI = new URI(string2);
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.mTitlebarText.setText((CharSequence)string2);
                    if (!string2.startsWith("app://")) {
                        this.mTitlebar.setVisibility(0);
                    } else {
                        this.mTitlebar.setVisibility(8);
                    }
                    return;
                }
                if (this.mOrigin != null && this.mOrigin.getHost().equals(uRI.getHost())) {
                    this.mTitlebar.setVisibility(8);
                    break;
                }
                this.mTitlebarText.setText((CharSequence)(uRI.getScheme() + "://" + uRI.getHost()));
                this.mTitlebar.setVisibility(0);
                break;
            }
            case LOADED: {
                if (this.mSplashscreen == null || this.mSplashscreen.getVisibility() != 0) break;
                Animation animation = AnimationUtils.loadAnimation((Context)this, (int)0x10A0001);
                animation.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationEnd(Animation animation) {
                        WebappImpl.this.mSplashscreen.setVisibility(8);
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }

                    public void onAnimationStart(Animation animation) {
                    }
                });
                this.mSplashscreen.startAnimation(animation);
                break;
            }
            case START: {
                if (this.mSplashscreen == null || this.mSplashscreen.getVisibility() != 0) break;
                View view = this.findViewById(R.id.splashscreen_progress);
                view.setVisibility(0);
                Animation animation = AnimationUtils.loadAnimation((Context)this, (int)0x10A0000);
                animation.setDuration(1000L);
                view.startAnimation(animation);
            }
        }
        super.onTabChanged(tab, tabEvents, object);
    }
}

