/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.animation;

import android.os.Build;
import android.os.Handler;
import android.support.v4.view.ViewCompat;
import android.view.Choreographer;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.animation.AnimatorProxy;

public class PropertyAnimator
implements Runnable {
    private static final String LOGTAG = "GeckoPropertyAnimator";
    private Interpolator mInterpolator;
    private long mStartTime;
    private long mDuration;
    private float mDurationReciprocal;
    private List<ElementHolder> mElementsList;
    private List<PropertyAnimationListener> mListeners;
    private FramePoster mFramePoster;
    private boolean mUseHardwareLayer;

    public PropertyAnimator(long l) {
        this(l, (Interpolator)new DecelerateInterpolator());
    }

    public PropertyAnimator(long l, Interpolator interpolator) {
        this.mDuration = l;
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
        this.mInterpolator = interpolator;
        this.mElementsList = new ArrayList<ElementHolder>();
        this.mFramePoster = FramePoster.create(this);
        this.mUseHardwareLayer = true;
        this.mListeners = null;
    }

    public void setUseHardwareLayer(boolean bl) {
        this.mUseHardwareLayer = bl;
    }

    public void attach(View view, Property property, float f) {
        ElementHolder elementHolder = new ElementHolder();
        elementHolder.view = view;
        elementHolder.proxy = AnimatorProxy.create(view);
        elementHolder.property = property;
        elementHolder.to = f;
        this.mElementsList.add(elementHolder);
    }

    public void addPropertyAnimationListener(PropertyAnimationListener propertyAnimationListener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<PropertyAnimationListener>();
        }
        this.mListeners.add(propertyAnimationListener);
    }

    public long getDuration() {
        return this.mDuration;
    }

    public long getRemainingTime() {
        int n = (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
        return this.mDuration - (long)n;
    }

    public void run() {
        int n = (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
        if ((long)n >= this.mDuration) {
            this.stop();
            return;
        }
        float f = this.mInterpolator.getInterpolation((float)n * this.mDurationReciprocal);
        for (ElementHolder elementHolder : this.mElementsList) {
            float f2 = elementHolder.from + (elementHolder.to - elementHolder.from) * f;
            this.invalidate(elementHolder, f2);
        }
        this.mFramePoster.postNextAnimationFrame();
    }

    public void start() {
        if (this.mDuration == 0L) {
            return;
        }
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        for (ElementHolder object : this.mElementsList) {
            if (object.property == Property.ALPHA) {
                object.from = object.proxy.getAlpha();
            } else if (object.property == Property.TRANSLATION_Y) {
                object.from = object.proxy.getTranslationY();
            } else if (object.property == Property.TRANSLATION_X) {
                object.from = object.proxy.getTranslationX();
            } else if (object.property == Property.SCROLL_Y) {
                object.from = object.proxy.getScrollY();
            } else if (object.property == Property.SCROLL_X) {
                object.from = object.proxy.getScrollX();
            } else if (object.property == Property.WIDTH) {
                object.from = object.proxy.getWidth();
            } else if (object.property == Property.HEIGHT) {
                object.from = object.proxy.getHeight();
            }
            ViewCompat.setHasTransientState((View)object.view, (boolean)true);
            if (this.shouldEnableHardwareLayer(object)) {
                object.view.setLayerType(2, null);
                continue;
            }
            object.view.setDrawingCacheEnabled(true);
        }
        Object object = this.mElementsList.size() > 0 ? this.mElementsList.get((int)0).view.getViewTreeObserver() : null;
        if (Build.VERSION.SDK_INT >= 11 && object != null && object.isAlive()) {
            object.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener((ViewTreeObserver)object){
                final /* synthetic */ ViewTreeObserver val$treeObserver;
                {
                    this.val$treeObserver = viewTreeObserver;
                }

                public boolean onPreDraw() {
                    if (this.val$treeObserver.isAlive()) {
                        this.val$treeObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    }
                    PropertyAnimator.this.mFramePoster.postFirstAnimationFrame();
                    return true;
                }
            });
        } else {
            this.mFramePoster.postFirstAnimationFrame();
        }
        if (this.mListeners != null) {
            for (PropertyAnimationListener propertyAnimationListener : this.mListeners) {
                propertyAnimationListener.onPropertyAnimationStart();
            }
        }
    }

    public void stop(boolean bl) {
        this.mFramePoster.cancelAnimationFrame();
        for (ElementHolder object : this.mElementsList) {
            if (bl) {
                this.invalidate(object, object.to);
            }
            ViewCompat.setHasTransientState((View)object.view, (boolean)false);
            if (this.shouldEnableHardwareLayer(object)) {
                object.view.setLayerType(0, null);
                continue;
            }
            object.view.setDrawingCacheEnabled(false);
        }
        this.mElementsList.clear();
        if (this.mListeners != null) {
            if (bl) {
                for (PropertyAnimationListener propertyAnimationListener : this.mListeners) {
                    propertyAnimationListener.onPropertyAnimationEnd();
                }
            }
            this.mListeners.clear();
            this.mListeners = null;
        }
    }

    public void stop() {
        this.stop(true);
    }

    private boolean shouldEnableHardwareLayer(ElementHolder elementHolder) {
        if (!this.mUseHardwareLayer) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 11) {
            return false;
        }
        if (!(elementHolder.view instanceof ViewGroup)) {
            return false;
        }
        return elementHolder.property == Property.ALPHA || elementHolder.property == Property.TRANSLATION_Y || elementHolder.property == Property.TRANSLATION_X;
    }

    private void invalidate(ElementHolder elementHolder, float f) {
        View view = elementHolder.view;
        if (view.getHandler() == null) {
            return;
        }
        if (elementHolder.property == Property.ALPHA) {
            elementHolder.proxy.setAlpha(f);
        } else if (elementHolder.property == Property.TRANSLATION_Y) {
            elementHolder.proxy.setTranslationY(f);
        } else if (elementHolder.property == Property.TRANSLATION_X) {
            elementHolder.proxy.setTranslationX(f);
        } else if (elementHolder.property == Property.SCROLL_Y) {
            elementHolder.proxy.scrollTo(elementHolder.proxy.getScrollX(), (int)f);
        } else if (elementHolder.property == Property.SCROLL_X) {
            elementHolder.proxy.scrollTo((int)f, elementHolder.proxy.getScrollY());
        } else if (elementHolder.property == Property.WIDTH) {
            elementHolder.proxy.setWidth((int)f);
        } else if (elementHolder.property == Property.HEIGHT) {
            elementHolder.proxy.setHeight((int)f);
        }
    }

    private static class FramePosterPostJB
    extends FramePoster {
        private Choreographer mChoreographer = Choreographer.getInstance();
        private Choreographer.FrameCallback mCallback;

        public FramePosterPostJB(final Runnable runnable) {
            this.mCallback = new Choreographer.FrameCallback(){

                public void doFrame(long l) {
                    runnable.run();
                }
            };
        }

        public void postFirstAnimationFrame() {
            this.postNextAnimationFrame();
        }

        public void postNextAnimationFrame() {
            this.mChoreographer.postFrameCallback(this.mCallback);
        }

        public void cancelAnimationFrame() {
            this.mChoreographer.removeFrameCallback(this.mCallback);
        }
    }

    private static class FramePosterPreJB
    extends FramePoster {
        private static final int INTERVAL = 10;
        private Handler mHandler = new Handler();
        private Runnable mRunnable;

        public FramePosterPreJB(Runnable runnable) {
            this.mRunnable = runnable;
        }

        public void postFirstAnimationFrame() {
            this.mHandler.post(this.mRunnable);
        }

        public void postNextAnimationFrame() {
            this.mHandler.postDelayed(this.mRunnable, 10L);
        }

        public void cancelAnimationFrame() {
            this.mHandler.removeCallbacks(this.mRunnable);
        }
    }

    private static abstract class FramePoster {
        private FramePoster() {
        }

        public static FramePoster create(Runnable runnable) {
            if (Build.VERSION.SDK_INT >= 16) {
                return new FramePosterPostJB(runnable);
            }
            return new FramePosterPreJB(runnable);
        }

        public abstract void postFirstAnimationFrame();

        public abstract void postNextAnimationFrame();

        public abstract void cancelAnimationFrame();
    }

    public static interface PropertyAnimationListener {
        public void onPropertyAnimationStart();

        public void onPropertyAnimationEnd();
    }

    private class ElementHolder {
        View view;
        AnimatorProxy proxy;
        Property property;
        float from;
        float to;

        private ElementHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        ALPHA,
        TRANSLATION_X,
        TRANSLATION_Y,
        SCROLL_X,
        SCROLL_Y,
        WIDTH,
        HEIGHT;

    }
}

