/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.ContentObserver;
import android.database.Cursor;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.LocalBrowserDB;
import org.mozilla.gecko.db.SuggestedSites;
import org.mozilla.gecko.db.TopSitesCursorWrapper;
import org.mozilla.gecko.favicons.decoders.LoadFaviconResult;
import org.mozilla.gecko.mozglue.RobocopTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserDB {
    private static boolean sAreContentProvidersEnabled = true;
    private static BrowserDBIface sDb = null;
    private static SuggestedSites sSuggestedSites;

    public static void initialize(String string2) {
        sDb = new LocalBrowserDB(string2);
    }

    public static void setSuggestedSites(SuggestedSites suggestedSites) {
        sSuggestedSites = suggestedSites;
    }

    public static void invalidateCachedState() {
        sDb.invalidateCachedState();
    }

    @RobocopTarget
    public static Cursor filter(ContentResolver contentResolver, CharSequence charSequence, int n) {
        return sDb.filter(contentResolver, charSequence, n);
    }

    private static void appendUrlsFromCursor(List<String> list, Cursor cursor) {
        cursor.moveToPosition(-1);
        while (cursor.moveToNext()) {
            list.add(cursor.getString(cursor.getColumnIndex("url")));
        }
    }

    public static Cursor getTopSites(ContentResolver contentResolver, int n, int n2) {
        int n3;
        Cursor cursor = sDb.getPinnedSites(contentResolver, n);
        int n4 = cursor.getCount();
        Cursor cursor2 = sDb.getTopSites(contentResolver, n2 - n4);
        int n5 = cursor2.getCount();
        Cursor cursor3 = null;
        if (sSuggestedSites != null && (n3 = n - n4 - n5) > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(n4 + n5);
            BrowserDB.appendUrlsFromCursor(arrayList, cursor);
            BrowserDB.appendUrlsFromCursor(arrayList, cursor2);
            cursor3 = sSuggestedSites.get(n3, arrayList);
        }
        return new TopSitesCursorWrapper(cursor, cursor2, cursor3, n);
    }

    public static void updateVisitedHistory(ContentResolver contentResolver, String string2) {
        if (sAreContentProvidersEnabled) {
            sDb.updateVisitedHistory(contentResolver, string2);
        }
    }

    public static void updateHistoryTitle(ContentResolver contentResolver, String string2, String string3) {
        if (sAreContentProvidersEnabled) {
            sDb.updateHistoryTitle(contentResolver, string2, string3);
        }
    }

    public static void updateHistoryEntry(ContentResolver contentResolver, String string2, String string3, long l, int n) {
        if (sAreContentProvidersEnabled) {
            sDb.updateHistoryEntry(contentResolver, string2, string3, l, n);
        }
    }

    @RobocopTarget
    public static Cursor getAllVisitedHistory(ContentResolver contentResolver) {
        return sAreContentProvidersEnabled ? sDb.getAllVisitedHistory(contentResolver) : null;
    }

    public static Cursor getRecentHistory(ContentResolver contentResolver, int n) {
        return sDb.getRecentHistory(contentResolver, n);
    }

    public static void expireHistory(ContentResolver contentResolver, BrowserContract.ExpirePriority expirePriority) {
        if (sDb == null) {
            return;
        }
        if (expirePriority == null) {
            expirePriority = BrowserContract.ExpirePriority.NORMAL;
        }
        sDb.expireHistory(contentResolver, expirePriority);
    }

    public static void removeHistoryEntry(ContentResolver contentResolver, int n) {
        sDb.removeHistoryEntry(contentResolver, n);
    }

    @RobocopTarget
    public static void removeHistoryEntry(ContentResolver contentResolver, String string2) {
        sDb.removeHistoryEntry(contentResolver, string2);
    }

    @RobocopTarget
    public static void clearHistory(ContentResolver contentResolver) {
        sDb.clearHistory(contentResolver);
    }

    @RobocopTarget
    public static Cursor getBookmarksInFolder(ContentResolver contentResolver, long l) {
        return sDb.getBookmarksInFolder(contentResolver, l);
    }

    @RobocopTarget
    public static Cursor getReadingList(ContentResolver contentResolver) {
        return sDb.getReadingList(contentResolver);
    }

    public static String getUrlForKeyword(ContentResolver contentResolver, String string2) {
        return sDb.getUrlForKeyword(contentResolver, string2);
    }

    public static boolean isVisited(ContentResolver contentResolver, String string2) {
        return sDb.isVisited(contentResolver, string2);
    }

    public static int getReadingListCount(ContentResolver contentResolver) {
        return sDb.getReadingListCount(contentResolver);
    }

    @RobocopTarget
    public static boolean isBookmark(ContentResolver contentResolver, String string2) {
        return sAreContentProvidersEnabled && sDb.isBookmark(contentResolver, string2);
    }

    public static boolean isReadingListItem(ContentResolver contentResolver, String string2) {
        return sAreContentProvidersEnabled && sDb.isReadingListItem(contentResolver, string2);
    }

    public static int getItemFlags(ContentResolver contentResolver, String string2) {
        if (!sAreContentProvidersEnabled) {
            return 0;
        }
        return sDb.getItemFlags(contentResolver, string2);
    }

    public static void addBookmark(ContentResolver contentResolver, String string2, String string3) {
        sDb.addBookmark(contentResolver, string2, string3);
    }

    public static void removeBookmark(ContentResolver contentResolver, int n) {
        sDb.removeBookmark(contentResolver, n);
    }

    @RobocopTarget
    public static void removeBookmarksWithURL(ContentResolver contentResolver, String string2) {
        sDb.removeBookmarksWithURL(contentResolver, string2);
    }

    @RobocopTarget
    public static void updateBookmark(ContentResolver contentResolver, int n, String string2, String string3, String string4) {
        sDb.updateBookmark(contentResolver, n, string2, string3, string4);
    }

    public static void addReadingListItem(ContentResolver contentResolver, ContentValues contentValues) {
        sDb.addReadingListItem(contentResolver, contentValues);
    }

    public static void removeReadingListItemWithURL(ContentResolver contentResolver, String string2) {
        sDb.removeReadingListItemWithURL(contentResolver, string2);
    }

    public static void removeReadingListItem(ContentResolver contentResolver, int n) {
        sDb.removeReadingListItem(contentResolver, n);
    }

    public static LoadFaviconResult getFaviconForFaviconUrl(ContentResolver contentResolver, String string2) {
        return sDb.getFaviconForUrl(contentResolver, string2);
    }

    public static String getFaviconUrlForHistoryUrl(ContentResolver contentResolver, String string2) {
        return sDb.getFaviconUrlForHistoryUrl(contentResolver, string2);
    }

    public static void updateFaviconForUrl(ContentResolver contentResolver, String string2, byte[] byArray, String string3) {
        sDb.updateFaviconForUrl(contentResolver, string2, byArray, string3);
    }

    public static void updateThumbnailForUrl(ContentResolver contentResolver, String string2, BitmapDrawable bitmapDrawable) {
        sDb.updateThumbnailForUrl(contentResolver, string2, bitmapDrawable);
    }

    @RobocopTarget
    public static byte[] getThumbnailForUrl(ContentResolver contentResolver, String string2) {
        return sDb.getThumbnailForUrl(contentResolver, string2);
    }

    public static Cursor getThumbnailsForUrls(ContentResolver contentResolver, List<String> list) {
        return sDb.getThumbnailsForUrls(contentResolver, list);
    }

    @RobocopTarget
    public static void removeThumbnails(ContentResolver contentResolver) {
        sDb.removeThumbnails(contentResolver);
    }

    public static void registerBookmarkObserver(ContentResolver contentResolver, ContentObserver contentObserver) {
        sDb.registerBookmarkObserver(contentResolver, contentObserver);
    }

    public static void registerHistoryObserver(ContentResolver contentResolver, ContentObserver contentObserver) {
        sDb.registerHistoryObserver(contentResolver, contentObserver);
    }

    public static void unregisterContentObserver(ContentResolver contentResolver, ContentObserver contentObserver) {
        contentResolver.unregisterContentObserver(contentObserver);
    }

    public static int getCount(ContentResolver contentResolver, String string2) {
        return sDb.getCount(contentResolver, string2);
    }

    public static void pinSite(ContentResolver contentResolver, String string2, String string3, int n) {
        sDb.pinSite(contentResolver, string2, string3, n);
    }

    public static void unpinSite(ContentResolver contentResolver, int n) {
        sDb.unpinSite(contentResolver, n);
    }

    public static void unpinAllSites(ContentResolver contentResolver) {
        sDb.unpinAllSites(contentResolver);
    }

    public static Cursor getPinnedSites(ContentResolver contentResolver, int n) {
        return sDb.getPinnedSites(contentResolver, n);
    }

    @RobocopTarget
    public static Cursor getBookmarkForUrl(ContentResolver contentResolver, String string2) {
        return sDb.getBookmarkForUrl(contentResolver, string2);
    }

    public static boolean areContentProvidersDisabled() {
        return sAreContentProvidersEnabled;
    }

    public static void setEnableContentProviders(boolean bl) {
        sAreContentProvidersEnabled = bl;
    }

    public static boolean hasSuggestedImageUrl(String string2) {
        return sSuggestedSites.contains(string2);
    }

    public static String getSuggestedImageUrlForUrl(String string2) {
        return sSuggestedSites.getImageUrlForUrl(string2);
    }

    public static int getSuggestedBackgroundColorForUrl(String string2) {
        String string3 = sSuggestedSites.getBackgroundColorForUrl(string2);
        if (string3 != null) {
            return Color.parseColor((String)string3);
        }
        return 0;
    }

    static {
        sDb = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BrowserDBIface {
        public void invalidateCachedState();

        @RobocopTarget
        public Cursor filter(ContentResolver var1, CharSequence var2, int var3);

        public Cursor getTopSites(ContentResolver var1, int var2);

        public void updateVisitedHistory(ContentResolver var1, String var2);

        public void updateHistoryTitle(ContentResolver var1, String var2, String var3);

        public void updateHistoryEntry(ContentResolver var1, String var2, String var3, long var4, int var6);

        @RobocopTarget
        public Cursor getAllVisitedHistory(ContentResolver var1);

        public Cursor getRecentHistory(ContentResolver var1, int var2);

        public void expireHistory(ContentResolver var1, BrowserContract.ExpirePriority var2);

        public void removeHistoryEntry(ContentResolver var1, int var2);

        @RobocopTarget
        public void removeHistoryEntry(ContentResolver var1, String var2);

        public void clearHistory(ContentResolver var1);

        @RobocopTarget
        public Cursor getBookmarksInFolder(ContentResolver var1, long var2);

        public Cursor getReadingList(ContentResolver var1);

        public boolean isVisited(ContentResolver var1, String var2);

        public int getReadingListCount(ContentResolver var1);

        @RobocopTarget
        public boolean isBookmark(ContentResolver var1, String var2);

        public boolean isReadingListItem(ContentResolver var1, String var2);

        public int getItemFlags(ContentResolver var1, String var2);

        public String getUrlForKeyword(ContentResolver var1, String var2);

        @RobocopTarget
        public void addBookmark(ContentResolver var1, String var2, String var3);

        public void removeBookmark(ContentResolver var1, int var2);

        @RobocopTarget
        public void removeBookmarksWithURL(ContentResolver var1, String var2);

        @RobocopTarget
        public void updateBookmark(ContentResolver var1, int var2, String var3, String var4, String var5);

        public void addReadingListItem(ContentResolver var1, ContentValues var2);

        public void removeReadingListItemWithURL(ContentResolver var1, String var2);

        public void removeReadingListItem(ContentResolver var1, int var2);

        public LoadFaviconResult getFaviconForUrl(ContentResolver var1, String var2);

        public String getFaviconUrlForHistoryUrl(ContentResolver var1, String var2);

        public void updateFaviconForUrl(ContentResolver var1, String var2, byte[] var3, String var4);

        public void updateThumbnailForUrl(ContentResolver var1, String var2, BitmapDrawable var3);

        @RobocopTarget
        public byte[] getThumbnailForUrl(ContentResolver var1, String var2);

        public Cursor getThumbnailsForUrls(ContentResolver var1, List<String> var2);

        @RobocopTarget
        public void removeThumbnails(ContentResolver var1);

        public void registerBookmarkObserver(ContentResolver var1, ContentObserver var2);

        public void registerHistoryObserver(ContentResolver var1, ContentObserver var2);

        public int getCount(ContentResolver var1, String var2);

        public void pinSite(ContentResolver var1, String var2, String var3, int var4);

        public void unpinSite(ContentResolver var1, int var2);

        public void unpinAllSites(ContentResolver var1);

        public Cursor getPinnedSites(ContentResolver var1, int var2);

        @RobocopTarget
        public Cursor getBookmarkForUrl(ContentResolver var1, String var2);
    }

    public static interface URLColumns {
        public static final String URL = "url";
        public static final String TITLE = "title";
        public static final String FAVICON = "favicon";
        public static final String THUMBNAIL = "thumbnail";
        public static final String DATE_LAST_VISITED = "date-last-visited";
        public static final String VISITS = "visits";
        public static final String KEYWORD = "keyword";
    }
}

