/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.SingleLineTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.Patterns;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.background.fxa.PasswordStretcher;
import org.mozilla.gecko.background.fxa.QuickPasswordStretcher;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractActivity;
import org.mozilla.gecko.fxa.activities.FxAccountConfirmAccountActivity;
import org.mozilla.gecko.fxa.activities.FxAccountVerifiedAccountActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.Engaged;
import org.mozilla.gecko.fxa.tasks.FxAccountSetupTask;
import org.mozilla.gecko.sync.SyncConfiguration;
import org.mozilla.gecko.sync.setup.activities.ActivityUtils;

public abstract class FxAccountAbstractSetupActivity
extends FxAccountAbstractActivity
implements FxAccountSetupTask.ProgressDisplay {
    private static final String LOG_TAG = FxAccountAbstractSetupActivity.class.getSimpleName();
    protected int minimumPasswordLength = 8;
    protected AutoCompleteTextView emailEdit;
    protected EditText passwordEdit;
    protected Button showPasswordButton;
    protected TextView remoteErrorTextView;
    protected Button button;
    protected ProgressBar progressBar;

    public FxAccountAbstractSetupActivity() {
        super(5);
    }

    protected FxAccountAbstractSetupActivity(int n) {
        super(n);
    }

    protected void createShowPasswordButton() {
        this.showPasswordButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean bl = FxAccountAbstractSetupActivity.this.passwordEdit.getTransformationMethod() instanceof SingleLineTransformationMethod;
                int n = FxAccountAbstractSetupActivity.this.passwordEdit.getSelectionStart();
                int n2 = FxAccountAbstractSetupActivity.this.passwordEdit.getSelectionEnd();
                if (bl) {
                    FxAccountAbstractSetupActivity.this.passwordEdit.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                    FxAccountAbstractSetupActivity.this.showPasswordButton.setText(R.string.fxaccount_password_show);
                    FxAccountAbstractSetupActivity.this.showPasswordButton.setBackgroundDrawable(FxAccountAbstractSetupActivity.this.getResources().getDrawable(R.drawable.fxaccount_password_button_show_background));
                    FxAccountAbstractSetupActivity.this.showPasswordButton.setTextColor(FxAccountAbstractSetupActivity.this.getResources().getColor(R.color.fxaccount_password_show_textcolor));
                } else {
                    FxAccountAbstractSetupActivity.this.passwordEdit.setTransformationMethod((TransformationMethod)SingleLineTransformationMethod.getInstance());
                    FxAccountAbstractSetupActivity.this.showPasswordButton.setText(R.string.fxaccount_password_hide);
                    FxAccountAbstractSetupActivity.this.showPasswordButton.setBackgroundDrawable(FxAccountAbstractSetupActivity.this.getResources().getDrawable(R.drawable.fxaccount_password_button_hide_background));
                    FxAccountAbstractSetupActivity.this.showPasswordButton.setTextColor(FxAccountAbstractSetupActivity.this.getResources().getColor(R.color.fxaccount_password_hide_textcolor));
                }
                FxAccountAbstractSetupActivity.this.passwordEdit.setSelection(n, n2);
            }
        });
    }

    protected void linkifyPolicy() {
        TextView textView = (TextView)this.ensureFindViewById(null, R.id.policy, "policy links");
        String string2 = this.getString(R.string.fxaccount_link_tos);
        String string3 = this.getString(R.string.fxaccount_link_pn);
        String string4 = "<a href=\"" + string2 + "\">" + this.getString(R.string.fxaccount_policy_linktos) + "</a>";
        String string5 = "<a href=\"" + string3 + "\">" + this.getString(R.string.fxaccount_policy_linkprivacy) + "</a>";
        textView.setText((CharSequence)this.getString(R.string.fxaccount_create_account_policy_text, new Object[]{string4, string5}));
        ActivityUtils.linkifyTextView(textView, true);
    }

    protected void hideRemoteError() {
        this.remoteErrorTextView.setVisibility(4);
    }

    protected void showRemoteError(Exception exception, int n) {
        if (exception instanceof IOException) {
            this.remoteErrorTextView.setText(R.string.fxaccount_remote_error_COULD_NOT_CONNECT);
        } else if (exception instanceof FxAccountClientException.FxAccountClientRemoteException) {
            this.showClientRemoteException((FxAccountClientException.FxAccountClientRemoteException)exception);
        } else {
            this.remoteErrorTextView.setText(n);
        }
        Logger.warn(LOG_TAG, "Got exception; showing error message: " + ((Object)this.remoteErrorTextView.getText()).toString(), exception);
        this.remoteErrorTextView.setVisibility(0);
    }

    protected void showClientRemoteException(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
        this.remoteErrorTextView.setText(fxAccountClientRemoteException.getErrorMessageStringResource());
    }

    protected void addListeners() {
        TextChangedListener textChangedListener = new TextChangedListener();
        EditorActionListener editorActionListener = new EditorActionListener();
        FocusChangeListener focusChangeListener = new FocusChangeListener();
        this.emailEdit.addTextChangedListener((TextWatcher)textChangedListener);
        this.emailEdit.setOnEditorActionListener((TextView.OnEditorActionListener)editorActionListener);
        this.emailEdit.setOnFocusChangeListener((View.OnFocusChangeListener)focusChangeListener);
        this.passwordEdit.addTextChangedListener((TextWatcher)textChangedListener);
        this.passwordEdit.setOnEditorActionListener((TextView.OnEditorActionListener)editorActionListener);
        this.passwordEdit.setOnFocusChangeListener((View.OnFocusChangeListener)focusChangeListener);
    }

    protected boolean shouldButtonBeEnabled() {
        String string2 = this.emailEdit.getText().toString();
        String string3 = this.passwordEdit.getText().toString();
        boolean bl = string2.length() > 0 && Patterns.EMAIL_ADDRESS.matcher(string2).matches() && string3.length() >= this.minimumPasswordLength;
        return bl;
    }

    protected boolean updateButtonState() {
        boolean bl = this.shouldButtonBeEnabled();
        if (!bl) {
            this.hideRemoteError();
        }
        if (bl != this.button.isEnabled()) {
            Logger.debug(LOG_TAG, (bl ? "En" : "Dis") + "abling button.");
            this.button.setEnabled(bl);
        }
        return bl;
    }

    public void showProgress() {
        this.progressBar.setVisibility(0);
        this.button.setVisibility(4);
    }

    public void dismissProgress() {
        this.progressBar.setVisibility(4);
        this.button.setVisibility(0);
    }

    public Intent makeSuccessIntent(String string2, FxAccountClient20.LoginResponse loginResponse) {
        Intent intent = loginResponse.verified ? new Intent((Context)this, FxAccountVerifiedAccountActivity.class) : new Intent((Context)this, FxAccountConfirmAccountActivity.class);
        intent.setFlags(65536);
        return intent;
    }

    protected PasswordStretcher makePasswordStretcher(String string2) {
        return new QuickPasswordStretcher(string2);
    }

    protected void populateEmailAddressAutocomplete(Account[] accountArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Account account : accountArray) {
            if (!Patterns.EMAIL_ADDRESS.matcher(account.name).matches()) continue;
            hashSet.add(account.name);
        }
        Object[] objectArray = hashSet.toArray(new String[0]);
        Arrays.sort(objectArray);
        ArrayAdapter arrayAdapter = new ArrayAdapter((Context)this, 17367050, objectArray);
        this.emailEdit.setAdapter((ListAdapter)arrayAdapter);
    }

    public void onResume() {
        super.onResume();
        GetAccountsAsyncTask getAccountsAsyncTask = new GetAccountsAsyncTask((Context)this){

            public void onPostExecute(Account[] accountArray) {
                FxAccountAbstractSetupActivity.this.populateEmailAddressAutocomplete(accountArray);
            }
        };
        getAccountsAsyncTask.execute(new Void[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class GetAccountsAsyncTask
    extends AsyncTask<Void, Void, Account[]> {
        protected final Context context;

        public GetAccountsAsyncTask(Context context) {
            this.context = context;
        }

        protected Account[] doInBackground(Void ... voidArray) {
            return AccountManager.get((Context)this.context).getAccounts();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AddAccountDelegate
    implements FxAccountClient10.RequestDelegate<FxAccountClient20.LoginResponse> {
        public final String email;
        public final PasswordStretcher passwordStretcher;
        public final String serverURI;
        public final Map<String, Boolean> selectedEngines;

        public AddAccountDelegate(String string2, PasswordStretcher passwordStretcher, String string3) {
            this(string2, passwordStretcher, string3, null);
        }

        public AddAccountDelegate(String string2, PasswordStretcher passwordStretcher, String string3, Map<String, Boolean> map) {
            if (string2 == null) {
                throw new IllegalArgumentException("email must not be null");
            }
            if (passwordStretcher == null) {
                throw new IllegalArgumentException("passwordStretcher must not be null");
            }
            if (string3 == null) {
                throw new IllegalArgumentException("serverURI must not be null");
            }
            this.email = string2;
            this.passwordStretcher = passwordStretcher;
            this.serverURI = string3;
            this.selectedEngines = map;
        }

        @Override
        public void handleSuccess(FxAccountClient20.LoginResponse loginResponse) {
            AndroidFxAccount androidFxAccount;
            Logger.info(LOG_TAG, "Got success response; adding Android account.");
            try {
                byte[] byArray = this.passwordStretcher.getQuickStretchedPW(loginResponse.remoteEmail.getBytes("UTF-8"));
                byte[] byArray2 = FxAccountUtils.generateUnwrapBKey(byArray);
                Engaged engaged = new Engaged(this.email, loginResponse.uid, loginResponse.verified, byArray2, loginResponse.sessionToken, loginResponse.keyFetchToken);
                androidFxAccount = AndroidFxAccount.addAndroidAccount(FxAccountAbstractSetupActivity.this.getApplicationContext(), this.email, "default", this.serverURI, "https://token.services.mozilla.com/1.0/sync/1.5", engaged);
                if (androidFxAccount == null) {
                    throw new RuntimeException("Could not add Android account.");
                }
                if (this.selectedEngines != null) {
                    Logger.info(LOG_TAG, "User has selected engines; storing to prefs.");
                    SyncConfiguration.storeSelectedEnginesToPrefs(androidFxAccount.getSyncPrefs(), this.selectedEngines);
                }
            }
            catch (Exception exception) {
                this.handleError(exception);
                return;
            }
            if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                androidFxAccount.dump();
            }
            Intent intent = new Intent();
            intent.putExtra("authAccount", this.email);
            intent.putExtra("accountType", "org.mozilla.fennec_fxaccount");
            FxAccountAbstractSetupActivity.this.setResult(-1, intent);
            Intent intent2 = FxAccountAbstractSetupActivity.this.makeSuccessIntent(this.email, loginResponse);
            FxAccountAbstractSetupActivity.this.startActivity(intent2);
            FxAccountAbstractSetupActivity.this.finish();
        }
    }

    protected class TextChangedListener
    implements TextWatcher {
        protected TextChangedListener() {
        }

        public void afterTextChanged(Editable editable) {
            FxAccountAbstractSetupActivity.this.updateButtonState();
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }

    protected class EditorActionListener
    implements TextView.OnEditorActionListener {
        protected EditorActionListener() {
        }

        public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
            FxAccountAbstractSetupActivity.this.updateButtonState();
            return false;
        }
    }

    protected class FocusChangeListener
    implements View.OnFocusChangeListener {
        protected FocusChangeListener() {
        }

        public void onFocusChange(View view, boolean bl) {
            if (bl) {
                return;
            }
            FxAccountAbstractSetupActivity.this.updateButtonState();
        }
    }
}

