/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.receivers;

import android.accounts.Account;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.sync.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FxAccountUpgradeReceiver
extends BroadcastReceiver {
    private static final String LOG_TAG = FxAccountUpgradeReceiver.class.getSimpleName();

    protected List<Runnable> onUpgradeRunnables(Context context) {
        LinkedList<Runnable> linkedList = new LinkedList<Runnable>();
        linkedList.add(new MaybeUnpickleRunnable(context));
        linkedList.add(new AdvanceFromDoghouseRunnable(context));
        return linkedList;
    }

    public void onReceive(Context context, Intent intent) {
        Logger.setThreadLogTag("FxAccounts");
        Logger.info(LOG_TAG, "Upgrade broadcast received.");
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        for (final Runnable runnable : this.onUpgradeRunnables(context)) {
            executorService.execute(new Runnable(){

                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Exception exception) {
                        Logger.error(LOG_TAG, "Got exception executing background upgrade Runnable; ignoring.", exception);
                    }
                }
            });
        }
    }

    protected static class AdvanceFromDoghouseRunnable
    implements Runnable {
        protected final Context context;

        public AdvanceFromDoghouseRunnable(Context context) {
            this.context = context;
        }

        public void run() {
            Account[] accountArray = FirefoxAccounts.getFirefoxAccounts(this.context);
            Logger.info(LOG_TAG, "Trying to advance " + accountArray.length + " existing Firefox Accounts from the Doghouse to Separated (if necessary).");
            for (Account account : accountArray) {
                try {
                    State state;
                    AndroidFxAccount androidFxAccount = new AndroidFxAccount(this.context, account);
                    if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                        androidFxAccount.dump();
                    }
                    if ((state = androidFxAccount.getState()) == null || state.getStateLabel() != State.StateLabel.Doghouse) {
                        Logger.debug(LOG_TAG, "Account named like " + Utils.obfuscateEmail(account.name) + " is not in the Doghouse; skipping.");
                        continue;
                    }
                    Logger.debug(LOG_TAG, "Account named like " + Utils.obfuscateEmail(account.name) + " is in the Doghouse; advancing to Separated.");
                    androidFxAccount.setState(state.makeSeparatedState());
                }
                catch (Exception exception) {
                    Logger.warn(LOG_TAG, "Got exception trying to advance account named like " + Utils.obfuscateEmail(account.name) + " from Doghouse to Separated state; ignoring.", exception);
                }
            }
        }
    }

    protected static class MaybeUnpickleRunnable
    implements Runnable {
        protected final Context context;

        public MaybeUnpickleRunnable(Context context) {
            this.context = context;
        }

        public void run() {
            Logger.info(LOG_TAG, "Trying to unpickle any pickled Firefox Account.");
            FirefoxAccounts.getFirefoxAccounts(this.context);
        }
    }
}

