/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.View;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.BookmarkFolderView;
import org.mozilla.gecko.home.MultiTypeCursorAdapter;
import org.mozilla.gecko.home.TwoLinePageRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BookmarksListAdapter
extends MultiTypeCursorAdapter {
    private static final int VIEW_TYPE_ITEM = 0;
    private static final int VIEW_TYPE_FOLDER = 1;
    private static final int[] VIEW_TYPES = new int[]{0, 1};
    private static final int[] LAYOUT_TYPES = new int[]{R.layout.bookmark_item_row, R.layout.bookmark_folder_row};
    private LinkedList<FolderInfo> mParentStack;
    private OnRefreshFolderListener mListener;

    public BookmarksListAdapter(Context context, Cursor cursor, List<FolderInfo> list) {
        super(context, cursor, VIEW_TYPES, LAYOUT_TYPES);
        this.mParentStack = list == null ? new LinkedList() : new LinkedList<FolderInfo>(list);
    }

    public List<FolderInfo> getParentStack() {
        return Collections.unmodifiableList(this.mParentStack);
    }

    public boolean moveToParentFolder() {
        if (this.mParentStack.size() <= 1) {
            return false;
        }
        if (this.mListener != null) {
            this.mListener.onRefreshFolder(this.mParentStack.get(1), RefreshType.PARENT);
        }
        return true;
    }

    public void moveToChildFolder(int n, String string2) {
        FolderInfo folderInfo = new FolderInfo(n, string2);
        if (this.mListener != null) {
            this.mListener.onRefreshFolder(folderInfo, RefreshType.CHILD);
        }
    }

    public void setOnRefreshFolderListener(OnRefreshFolderListener onRefreshFolderListener) {
        this.mListener = onRefreshFolderListener;
    }

    private boolean isCurrentFolder(FolderInfo folderInfo) {
        return this.mParentStack.size() > 0 && this.mParentStack.peek().id == folderInfo.id;
    }

    public void swapCursor(Cursor cursor, FolderInfo folderInfo, RefreshType refreshType) {
        switch (refreshType) {
            case PARENT: {
                if (this.isCurrentFolder(folderInfo)) break;
                this.mParentStack.removeFirst();
                break;
            }
            case CHILD: {
                if (this.isCurrentFolder(folderInfo)) break;
                this.mParentStack.addFirst(folderInfo);
                break;
            }
        }
        this.swapCursor(cursor);
    }

    public int getItemViewType(int n) {
        Cursor cursor;
        if (this.isShowingChildFolder()) {
            if (n == 0) {
                return 1;
            }
            --n;
        }
        if ((cursor = this.getCursor(n)).getInt(cursor.getColumnIndexOrThrow("type")) == 0) {
            return 1;
        }
        return 0;
    }

    public String getFolderTitle(Context context, Cursor cursor) {
        String string2 = cursor.getString(cursor.getColumnIndexOrThrow("guid"));
        if (string2 == null || string2.length() == 12) {
            return cursor.getString(cursor.getColumnIndexOrThrow("title"));
        }
        Resources resources = context.getResources();
        if (string2.equals("desktop")) {
            return resources.getString(R.string.bookmarks_folder_desktop);
        }
        if (string2.equals("menu")) {
            return resources.getString(R.string.bookmarks_folder_menu);
        }
        if (string2.equals("toolbar")) {
            return resources.getString(R.string.bookmarks_folder_toolbar);
        }
        if (string2.equals("unfiled")) {
            return resources.getString(R.string.bookmarks_folder_unfiled);
        }
        return cursor.getString(cursor.getColumnIndexOrThrow("title"));
    }

    public boolean isShowingChildFolder() {
        if (this.mParentStack.size() == 0) {
            return false;
        }
        return this.mParentStack.peek().id != 0;
    }

    public int getCount() {
        return super.getCount() + (this.isShowingChildFolder() ? 1 : 0);
    }

    @Override
    public void bindView(View view, Context context, int n) {
        int n2 = this.getItemViewType(n);
        Cursor cursor = this.isShowingChildFolder() ? (n == 0 ? null : this.getCursor(--n)) : this.getCursor(n);
        if (n2 == 0) {
            TwoLinePageRow twoLinePageRow = (TwoLinePageRow)view;
            twoLinePageRow.updateFromCursor(cursor);
        } else {
            BookmarkFolderView bookmarkFolderView = (BookmarkFolderView)view;
            if (cursor == null) {
                bookmarkFolderView.setText(this.mParentStack.peek().title);
                bookmarkFolderView.open();
            } else {
                bookmarkFolderView.setText(this.getFolderTitle(context, cursor));
                bookmarkFolderView.close();
            }
        }
    }

    public static interface OnRefreshFolderListener {
        public void onRefreshFolder(FolderInfo var1, RefreshType var2);
    }

    public static class FolderInfo
    implements Parcelable {
        public final int id;
        public final String title;
        public static final Parcelable.Creator<FolderInfo> CREATOR = new Parcelable.Creator<FolderInfo>(){

            public FolderInfo createFromParcel(Parcel parcel) {
                return new FolderInfo(parcel);
            }

            public FolderInfo[] newArray(int n) {
                return new FolderInfo[n];
            }
        };

        public FolderInfo(int n) {
            this(n, "");
        }

        public FolderInfo(Parcel parcel) {
            this(parcel.readInt(), parcel.readString());
        }

        public FolderInfo(int n, String string2) {
            this.id = n;
            this.title = string2;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.id);
            parcel.writeString(this.title);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RefreshType implements Parcelable
    {
        PARENT,
        CHILD;

        public static final Parcelable.Creator<RefreshType> CREATOR;

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<RefreshType>(){

                public RefreshType createFromParcel(Parcel parcel) {
                    return RefreshType.values()[parcel.readInt()];
                }

                public RefreshType[] newArray(int n) {
                    return new RefreshType[n];
                }
            };
        }
    }
}

