/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.util.HardwareUtils;

class HomeConfigPrefsBackend
implements HomeConfig.HomeConfigBackend {
    private static final String LOGTAG = "GeckoHomeConfigBackend";
    private static final String PREFS_CONFIG_KEY = "home_panels";
    private static final String PREFS_LOCALE_KEY = "home_locale";
    private static final String RELOAD_BROADCAST = "HomeConfigPrefsBackend:Reload";
    private final Context mContext;
    private ReloadBroadcastReceiver mReloadBroadcastReceiver;
    private HomeConfig.OnReloadListener mReloadListener;

    public HomeConfigPrefsBackend(Context context) {
        this.mContext = context;
    }

    private SharedPreferences getSharedPreferences() {
        return GeckoSharedPrefs.forProfile(this.mContext);
    }

    private HomeConfig.State loadDefaultConfig() {
        ArrayList<HomeConfig.PanelConfig> arrayList = new ArrayList<HomeConfig.PanelConfig>();
        arrayList.add(HomeConfig.createBuiltinPanelConfig(this.mContext, HomeConfig.PanelType.TOP_SITES, EnumSet.of(HomeConfig.PanelConfig.Flags.DEFAULT_PANEL)));
        arrayList.add(HomeConfig.createBuiltinPanelConfig(this.mContext, HomeConfig.PanelType.BOOKMARKS));
        if (!HardwareUtils.isLowMemoryPlatform()) {
            arrayList.add(HomeConfig.createBuiltinPanelConfig(this.mContext, HomeConfig.PanelType.READING_LIST));
        }
        HomeConfig.PanelConfig panelConfig = HomeConfig.createBuiltinPanelConfig(this.mContext, HomeConfig.PanelType.HISTORY);
        if (HardwareUtils.isTablet()) {
            arrayList.add(panelConfig);
        } else {
            arrayList.add(0, panelConfig);
        }
        return new HomeConfig.State(arrayList, true);
    }

    private HomeConfig.State loadConfigFromString(String string2) {
        JSONArray jSONArray;
        try {
            jSONArray = new JSONArray(string2);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error loading the list of home panels from JSON prefs", (Throwable)jSONException);
            return this.loadDefaultConfig();
        }
        ArrayList<HomeConfig.PanelConfig> arrayList = new ArrayList<HomeConfig.PanelConfig>();
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                HomeConfig.PanelConfig panelConfig = new HomeConfig.PanelConfig(jSONObject);
                arrayList.add(panelConfig);
                continue;
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)"Exception loading PanelConfig from JSON", (Throwable)exception);
            }
        }
        return new HomeConfig.State(arrayList, false);
    }

    public HomeConfig.State load() {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        String string2 = sharedPreferences.getString(PREFS_CONFIG_KEY, null);
        HomeConfig.State state = TextUtils.isEmpty((CharSequence)string2) ? this.loadDefaultConfig() : this.loadConfigFromString(string2);
        return state;
    }

    public void save(HomeConfig.State state) {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        if (!state.isDefault()) {
            JSONArray jSONArray = new JSONArray();
            for (HomeConfig.PanelConfig panelConfig : state) {
                try {
                    JSONObject jSONObject = panelConfig.toJSON();
                    jSONArray.put((Object)jSONObject);
                }
                catch (Exception exception) {
                    Log.e((String)LOGTAG, (String)"Exception converting PanelConfig to JSON", (Throwable)exception);
                }
            }
            editor.putString(PREFS_CONFIG_KEY, jSONArray.toString());
        }
        editor.putString(PREFS_LOCALE_KEY, Locale.getDefault().toString());
        editor.commit();
        this.sendReloadBroadcast();
    }

    public String getLocale() {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        String string2 = sharedPreferences.getString(PREFS_LOCALE_KEY, null);
        if (string2 == null) {
            String string3 = Locale.getDefault().toString();
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(PREFS_LOCALE_KEY, string3);
            editor.commit();
            if (!sharedPreferences.contains(PREFS_CONFIG_KEY)) {
                string2 = string3;
            }
        }
        return string2;
    }

    public void setOnReloadListener(HomeConfig.OnReloadListener onReloadListener) {
        if (this.mReloadListener != null) {
            this.unregisterReloadReceiver();
            this.mReloadBroadcastReceiver = null;
        }
        this.mReloadListener = onReloadListener;
        if (this.mReloadListener != null) {
            this.mReloadBroadcastReceiver = new ReloadBroadcastReceiver();
            this.registerReloadReceiver();
        }
    }

    private void sendReloadBroadcast() {
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this.mContext);
        Intent intent = new Intent(RELOAD_BROADCAST);
        localBroadcastManager.sendBroadcast(intent);
    }

    private void registerReloadReceiver() {
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this.mContext);
        localBroadcastManager.registerReceiver((BroadcastReceiver)this.mReloadBroadcastReceiver, new IntentFilter(RELOAD_BROADCAST));
    }

    private void unregisterReloadReceiver() {
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this.mContext);
        localBroadcastManager.unregisterReceiver((BroadcastReceiver)this.mReloadBroadcastReceiver);
    }

    private class ReloadBroadcastReceiver
    extends BroadcastReceiver {
        private ReloadBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            HomeConfigPrefsBackend.this.mReloadListener.onReload();
        }
    }
}

