/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;
import org.mozilla.gecko.EditBookmarkDialog;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.ReaderModeUtils;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.TopSitesGridView;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UiAsyncTask;
import org.mozilla.gecko.widget.ButtonToast;

abstract class HomeFragment
extends Fragment {
    private static final String LOGTAG = "GeckoHomeFragment";
    protected static final String SHARE_MIME_TYPE = "text/plain";
    static final boolean DEFAULT_CAN_LOAD_HINT = false;
    private boolean mCanLoadHint;
    private boolean mIsLoaded;

    HomeFragment() {
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Bundle bundle2 = this.getArguments();
        this.mCanLoadHint = bundle2 != null ? bundle2.getBoolean("canLoad", false) : false;
        this.mIsLoaded = false;
    }

    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        if (contextMenuInfo == null || !(contextMenuInfo instanceof HomeContextMenuInfo)) {
            return;
        }
        HomeContextMenuInfo homeContextMenuInfo = (HomeContextMenuInfo)contextMenuInfo;
        if (homeContextMenuInfo.isFolder) {
            return;
        }
        MenuInflater menuInflater = new MenuInflater(view.getContext());
        menuInflater.inflate(R.menu.home_contextmenu, (Menu)contextMenu);
        contextMenu.setHeaderTitle((CharSequence)homeContextMenuInfo.getDisplayTitle());
        contextMenu.findItem(R.id.top_sites_edit).setVisible(false);
        contextMenu.findItem(R.id.top_sites_pin).setVisible(false);
        contextMenu.findItem(R.id.top_sites_unpin).setVisible(false);
        if (!homeContextMenuInfo.hasBookmarkId() || homeContextMenuInfo.isInReadingList()) {
            contextMenu.findItem(R.id.home_edit_bookmark).setVisible(false);
        }
        if (!homeContextMenuInfo.canRemove()) {
            contextMenu.findItem(R.id.home_remove).setVisible(false);
        }
        contextMenu.findItem(R.id.home_share).setVisible(!GeckoProfile.get((Context)this.getActivity()).inGuestMode());
        boolean bl = homeContextMenuInfo.display == 1;
        contextMenu.findItem(R.id.home_open_in_reader).setVisible(bl);
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        ContextMenu.ContextMenuInfo contextMenuInfo = menuItem.getMenuInfo();
        if (contextMenuInfo == null || !(contextMenuInfo instanceof HomeContextMenuInfo)) {
            return false;
        }
        HomeContextMenuInfo homeContextMenuInfo = (HomeContextMenuInfo)contextMenuInfo;
        FragmentActivity fragmentActivity = this.getActivity();
        int n = menuItem.getItemId();
        Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.CONTEXT_MENU, this.getResources().getResourceEntryName(n));
        if (n == R.id.home_copyurl) {
            if (homeContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't copy address because URL is null");
                return false;
            }
            Clipboard.setText((CharSequence)homeContextMenuInfo.url);
            return true;
        }
        if (n == R.id.home_share) {
            if (homeContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't share because URL is null");
                return false;
            }
            GeckoAppShell.openUriExternal(homeContextMenuInfo.url, SHARE_MIME_TYPE, "", "", "android.intent.action.SEND", homeContextMenuInfo.getDisplayTitle());
            Telemetry.sendUIEvent(TelemetryContract.Event.SHARE, TelemetryContract.Method.LIST);
            return true;
        }
        if (n == R.id.home_add_to_launcher) {
            if (homeContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't add to home screen because URL is null");
                return false;
            }
            Favicons.getPreferredSizeFaviconForPage(homeContextMenuInfo.url, new GeckoAppShell.CreateShortcutFaviconLoadedListener(homeContextMenuInfo.url, homeContextMenuInfo.getDisplayTitle()));
            return true;
        }
        if (n == R.id.home_open_private_tab || n == R.id.home_open_new_tab) {
            boolean bl;
            if (homeContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't open in new tab because URL is null");
                return false;
            }
            int n2 = 65;
            boolean bl2 = bl = menuItem.getItemId() == R.id.home_open_private_tab;
            if (bl) {
                n2 |= 4;
            }
            Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.CONTEXT_MENU);
            String string2 = homeContextMenuInfo.isInReadingList() ? ReaderModeUtils.getAboutReaderForUrl(homeContextMenuInfo.url) : homeContextMenuInfo.url;
            Tab tab = Tabs.getInstance().loadUrl(HomeFragment.decodeUserEnteredUrl(string2), n2);
            final int n3 = tab.getId();
            String string3 = bl ? this.getResources().getString(R.string.new_private_tab_opened) : this.getResources().getString(R.string.new_tab_opened);
            String string4 = this.getResources().getString(R.string.switch_button_message);
            GeckoApp geckoApp = (GeckoApp)fragmentActivity;
            geckoApp.getButtonToast().show(false, (CharSequence)string3, (CharSequence)string4, R.drawable.switch_button_icon, new ButtonToast.ToastListener(){

                public void onButtonClicked() {
                    Tabs.getInstance().selectTab(n3);
                }

                public void onToastHidden(ButtonToast.ReasonHidden reasonHidden) {
                }
            });
            return true;
        }
        if (n == R.id.home_edit_bookmark) {
            new EditBookmarkDialog((Context)fragmentActivity).show(homeContextMenuInfo.url);
            return true;
        }
        if (n == R.id.home_open_in_reader) {
            String string5 = ReaderModeUtils.getAboutReaderForUrl(homeContextMenuInfo.url);
            Tabs.getInstance().loadUrl(string5, 0);
            return true;
        }
        if (n == R.id.home_remove) {
            if (homeContextMenuInfo instanceof TopSitesGridView.TopSitesGridContextMenuInfo) {
                new RemoveItemByUrlTask((Context)fragmentActivity, homeContextMenuInfo.url, homeContextMenuInfo.position).execute(new Void[0]);
                return true;
            }
            if (homeContextMenuInfo.isInReadingList() || homeContextMenuInfo.hasBookmarkId() || homeContextMenuInfo.hasHistoryId()) {
                new RemoveItemByUrlTask((Context)fragmentActivity, homeContextMenuInfo.url).execute(new Void[0]);
                return true;
            }
        }
        return false;
    }

    public void setUserVisibleHint(boolean bl) {
        if (bl == this.getUserVisibleHint()) {
            return;
        }
        super.setUserVisibleHint(bl);
        this.loadIfVisible();
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
    }

    void setCanLoadHint(boolean bl) {
        if (this.mCanLoadHint == bl) {
            return;
        }
        this.mCanLoadHint = bl;
        this.loadIfVisible();
    }

    boolean getCanLoadHint() {
        return this.mCanLoadHint;
    }

    public static String decodeUserEnteredUrl(String string2) {
        Uri uri = Uri.parse((String)string2);
        if ("user-entered".equals(uri.getScheme())) {
            return uri.getSchemeSpecificPart();
        }
        return string2;
    }

    protected abstract void load();

    protected boolean canLoad() {
        return this.mCanLoadHint && this.isVisible() && this.getUserVisibleHint();
    }

    protected void loadIfVisible() {
        if (!this.canLoad() || this.mIsLoaded) {
            return;
        }
        this.load();
        this.mIsLoaded = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoveItemByUrlTask
    extends UiAsyncTask<Void, Void, Void> {
        private final Context mContext;
        private final String mUrl;
        private final int mPosition;

        public RemoveItemByUrlTask(Context context, String string2) {
            this(context, string2, -1);
        }

        public RemoveItemByUrlTask(Context context, String string2, int n) {
            super(ThreadUtils.getBackgroundHandler());
            this.mContext = context;
            this.mUrl = string2;
            this.mPosition = n;
        }

        public Void doInBackground(Void ... voidArray) {
            ContentResolver contentResolver = this.mContext.getContentResolver();
            if (this.mPosition > -1) {
                BrowserDB.unpinSite(contentResolver, this.mPosition);
            }
            BrowserDB.removeBookmarksWithURL(contentResolver, this.mUrl);
            BrowserDB.removeHistoryEntry(contentResolver, this.mUrl);
            BrowserDB.removeReadingListItemWithURL(contentResolver, this.mUrl);
            GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Reader:Remove", this.mUrl);
            GeckoAppShell.sendEventToGecko(geckoEvent);
            return null;
        }

        public void onPostExecute(Void void_) {
            Toast.makeText((Context)this.mContext, (int)R.string.page_removed, (int)0).show();
        }
    }
}

