/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.EnumSet;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.home.HomeAdapter;
import org.mozilla.gecko.home.HomeBanner;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomeConfigLoader;
import org.mozilla.gecko.home.HomePagerTabStrip;
import org.mozilla.gecko.util.ThreadUtils;

public class HomePager
extends ViewPager {
    private static final int LOADER_ID_CONFIG = 0;
    private final Context mContext;
    private volatile boolean mVisible;
    private Decor mDecor;
    private View mTabStrip;
    private HomeBanner mHomeBanner;
    private int mDefaultPageIndex = -1;
    private final HomeAdapter.OnAddPanelListener mAddPanelListener;
    private final HomeConfig mConfig;
    private ConfigLoaderCallbacks mConfigLoaderCallbacks;
    private String mInitialPanelId;
    private final Drawable mOriginalBackground;
    private TelemetryContract.Session mCurrentPanelSession;
    private String mCurrentPanelSessionSuffix;
    private LoadState mLoadState;
    private OnPanelChangeListener mPanelChangedListener;
    static final String LIST_TAG_HISTORY = "history";
    static final String LIST_TAG_BOOKMARKS = "bookmarks";
    static final String LIST_TAG_READING_LIST = "reading_list";
    static final String LIST_TAG_TOP_SITES = "top_sites";
    static final String LIST_TAG_MOST_RECENT = "most_recent";
    static final String LIST_TAG_LAST_TABS = "last_tabs";
    static final String LIST_TAG_BROWSER_SEARCH = "browser_search";
    static final String CAN_LOAD_ARG = "canLoad";
    static final String PANEL_CONFIG_ARG = "panelConfig";

    public HomePager(Context context) {
        this(context, null);
    }

    public HomePager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.mConfig = HomeConfig.getDefault(this.mContext);
        this.mConfigLoaderCallbacks = new ConfigLoaderCallbacks();
        this.mAddPanelListener = new HomeAdapter.OnAddPanelListener(){

            public void onAddPanel(String string2) {
                if (HomePager.this.mDecor != null) {
                    HomePager.this.mDecor.onAddPagerView(string2);
                }
            }
        };
        this.setOffscreenPageLimit(3);
        this.setFocusableInTouchMode(true);
        this.mOriginalBackground = this.getBackground();
        this.setOnPageChangeListener(new PageChangeListener());
        this.mLoadState = LoadState.UNLOADED;
    }

    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        if (view instanceof Decor) {
            ((ViewPager.LayoutParams)layoutParams).isDecor = true;
            this.mDecor = (Decor)view;
            this.mTabStrip = view;
            this.mDecor.setOnTitleClickListener(new OnTitleClickListener(){

                public void onTitleClicked(int n) {
                    HomePager.this.setCurrentItem(n, true);
                }
            });
        } else if (view instanceof HomePagerTabStrip) {
            this.mTabStrip = view;
        }
        super.addView(view, n, layoutParams);
    }

    public void load(LoaderManager loaderManager, FragmentManager fragmentManager, String string2, PropertyAnimator propertyAnimator) {
        this.mLoadState = LoadState.LOADING;
        this.mVisible = true;
        this.mInitialPanelId = string2;
        if (this.mHomeBanner != null) {
            this.mHomeBanner.update();
        }
        boolean bl = propertyAnimator != null && Build.VERSION.SDK_INT >= 11;
        final HomeAdapter homeAdapter = new HomeAdapter(this.mContext, fragmentManager);
        homeAdapter.setOnAddPanelListener(this.mAddPanelListener);
        homeAdapter.setCanLoadHint(!bl);
        this.setAdapter((PagerAdapter)homeAdapter);
        this.mTabStrip.setVisibility(4);
        loaderManager.initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mConfigLoaderCallbacks);
        if (bl) {
            propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

                public void onPropertyAnimationStart() {
                    HomePager.this.setLayerType(2, null);
                }

                public void onPropertyAnimationEnd() {
                    HomePager.this.setLayerType(0, null);
                    homeAdapter.setCanLoadHint(true);
                }
            });
            ViewHelper.setAlpha((View)this, 0.0f);
            propertyAnimator.attach((View)this, PropertyAnimator.Property.ALPHA, 1.0f);
        }
        Telemetry.startUISession(TelemetryContract.Session.HOME);
    }

    public void unload() {
        this.mVisible = false;
        this.setAdapter(null);
        this.mLoadState = LoadState.UNLOADED;
        this.stopCurrentPanelTelemetrySession();
        Telemetry.stopUISession(TelemetryContract.Session.HOME);
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public void setCurrentItem(int n, boolean bl) {
        super.setCurrentItem(n, bl);
        if (this.mDecor != null) {
            this.mDecor.onPageSelected(n);
        }
        if (this.mHomeBanner != null) {
            this.mHomeBanner.setActive(n == this.mDefaultPageIndex);
        }
    }

    public void showPanel(String string2) {
        if (!this.mVisible) {
            return;
        }
        switch (this.mLoadState) {
            case LOADING: {
                this.mInitialPanelId = string2;
                break;
            }
            case LOADED: {
                int n = this.mDefaultPageIndex;
                if (string2 != null) {
                    n = ((HomeAdapter)this.getAdapter()).getItemPosition(string2);
                }
                if (n <= -1) break;
                this.setCurrentItem(n);
                break;
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getActionMasked() == 0) {
            this.requestFocus();
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    public void setBanner(HomeBanner homeBanner) {
        this.mHomeBanner = homeBanner;
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (this.mHomeBanner != null) {
            this.mHomeBanner.handleHomeTouch(motionEvent);
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    public void onToolbarFocusChange(boolean bl) {
        if (this.mHomeBanner == null) {
            return;
        }
        boolean bl2 = !bl && this.getCurrentItem() == this.mDefaultPageIndex;
        this.mHomeBanner.setActive(bl2);
    }

    private void updateUiFromConfigState(HomeConfig.State state) {
        if (!this.mVisible) {
            return;
        }
        if (this.mDecor != null) {
            this.mDecor.removeAllPagerViews();
        }
        final HomeAdapter homeAdapter = (HomeAdapter)this.getAdapter();
        boolean bl = homeAdapter.getCanLoadHint();
        homeAdapter.setCanLoadHint(false);
        this.setAdapter(null);
        ArrayList<HomeConfig.PanelConfig> arrayList = new ArrayList<HomeConfig.PanelConfig>();
        for (HomeConfig.PanelConfig panelConfig : state) {
            if (panelConfig.isDisabled()) continue;
            arrayList.add(panelConfig);
        }
        homeAdapter.update(arrayList);
        int n = arrayList.size();
        if (n == 0) {
            this.setBackgroundResource(R.drawable.home_pager_empty_state);
            this.mTabStrip.setVisibility(4);
        } else {
            this.mTabStrip.setVisibility(0);
            this.setBackgroundDrawable(this.mOriginalBackground);
        }
        this.setAdapter((PagerAdapter)homeAdapter);
        if (n == 0) {
            this.mDefaultPageIndex = -1;
            if (this.mHomeBanner != null) {
                this.mHomeBanner.setActive(false);
            }
        } else {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                if (!((HomeConfig.PanelConfig)arrayList.get(n2)).isDefault()) continue;
                this.mDefaultPageIndex = n2;
                break;
            }
            int n3 = n2 = this.mInitialPanelId == null ? -1 : homeAdapter.getItemPosition(this.mInitialPanelId);
            if (n2 > -1) {
                this.setCurrentItem(n2, false);
                this.mInitialPanelId = null;
            } else {
                this.setCurrentItem(this.mDefaultPageIndex, false);
            }
        }
        if (bl) {
            ThreadUtils.getUiHandler().post(new Runnable(){

                public void run() {
                    homeAdapter.setCanLoadHint(true);
                }
            });
        }
    }

    public void setOnPanelChangeListener(OnPanelChangeListener onPanelChangeListener) {
        this.mPanelChangedListener = onPanelChangeListener;
    }

    private void notifyPanelSelected(int n) {
        if (this.mDecor != null) {
            this.mDecor.onPageSelected(n);
        }
        if (this.mPanelChangedListener != null) {
            String string2 = ((HomeAdapter)this.getAdapter()).getPanelIdAtPosition(n);
            this.mPanelChangedListener.onPanelSelected(string2);
        }
    }

    private void startNewPanelTelemetrySession(String string2) {
        this.stopCurrentPanelTelemetrySession();
        this.mCurrentPanelSession = TelemetryContract.Session.HOME_PANEL;
        this.mCurrentPanelSessionSuffix = string2;
        Telemetry.startUISession(this.mCurrentPanelSession, this.mCurrentPanelSessionSuffix);
    }

    private void stopCurrentPanelTelemetrySession() {
        if (this.mCurrentPanelSession != null) {
            Telemetry.stopUISession(this.mCurrentPanelSession, this.mCurrentPanelSessionSuffix);
            this.mCurrentPanelSession = null;
            this.mCurrentPanelSessionSuffix = null;
        }
    }

    private class PageChangeListener
    implements ViewPager.OnPageChangeListener {
        private PageChangeListener() {
        }

        public void onPageSelected(int n) {
            HomePager.this.notifyPanelSelected(n);
            if (HomePager.this.mHomeBanner != null) {
                HomePager.this.mHomeBanner.setActive(n == HomePager.this.mDefaultPageIndex);
            }
            String string2 = ((HomeAdapter)HomePager.this.getAdapter()).getPanelIdAtPosition(n);
            HomePager.this.startNewPanelTelemetrySession(string2);
        }

        public void onPageScrolled(int n, float f, int n2) {
            if (HomePager.this.mDecor != null) {
                HomePager.this.mDecor.onPageScrolled(n, f, n2);
            }
            if (HomePager.this.mHomeBanner != null) {
                HomePager.this.mHomeBanner.setScrollingPages(n2 != 0);
            }
        }

        public void onPageScrollStateChanged(int n) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<HomeConfig.State> {
        private ConfigLoaderCallbacks() {
        }

        public Loader<HomeConfig.State> onCreateLoader(int n, Bundle bundle) {
            return new HomeConfigLoader(HomePager.this.mContext, HomePager.this.mConfig);
        }

        public void onLoadFinished(Loader<HomeConfig.State> loader, HomeConfig.State state) {
            HomePager.this.mLoadState = LoadState.LOADED;
            HomePager.this.updateUiFromConfigState(state);
        }

        public void onLoaderReset(Loader<HomeConfig.State> loader) {
            HomePager.this.mLoadState = LoadState.UNLOADED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LoadState {
        UNLOADED,
        LOADING,
        LOADED;

    }

    static interface Decor {
        public void onAddPagerView(String var1);

        public void removeAllPagerViews();

        public void onPageSelected(int var1);

        public void onPageScrolled(int var1, float var2, int var3);

        public void setOnTitleClickListener(OnTitleClickListener var1);
    }

    static interface OnTitleClickListener {
        public void onTitleClicked(int var1);
    }

    public static interface OnPanelChangeListener {
        public void onPanelSelected(String var1);
    }

    public static interface OnNewTabsListener {
        public void onNewTabs(String[] var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OnUrlOpenListener {
        public void onUrlOpen(String var1, EnumSet<Flags> var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Flags {
            ALLOW_SWITCH_TO_TAB,
            OPEN_WITH_INTENT;

        }
    }
}

