/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.squareup.picasso.Picasso;
import org.mozilla.gecko.R;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.home.TopSitesThumbnailView;

public class TopSitesGridItemView
extends RelativeLayout {
    private static final String LOGTAG = "GeckoTopSitesGridItemView";
    private static final int[] STATE_EMPTY = new int[]{16842921};
    private static final ImageView.ScaleType SCALE_TYPE_FAVICON = ImageView.ScaleType.CENTER;
    private static final ImageView.ScaleType SCALE_TYPE_RESOURCE = ImageView.ScaleType.CENTER;
    private static final ImageView.ScaleType SCALE_TYPE_THUMBNAIL = ImageView.ScaleType.CENTER_CROP;
    private final TextView mTitleView;
    private final TopSitesThumbnailView mThumbnailView;
    private String mTitle;
    private String mUrl;
    private String mFaviconURL;
    private boolean mThumbnailSet;
    private int mType = -1;
    private boolean mIsDirty = false;
    private int mLoadId = 0;

    public TopSitesGridItemView(Context context) {
        this(context, null);
    }

    public TopSitesGridItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.topSitesGridItemViewStyle);
    }

    public TopSitesGridItemView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        LayoutInflater.from((Context)context).inflate(R.layout.top_sites_grid_item_view, (ViewGroup)this);
        this.mTitleView = (TextView)this.findViewById(R.id.title);
        this.mThumbnailView = (TopSitesThumbnailView)this.findViewById(R.id.thumbnail);
    }

    public int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 1);
        if (this.mType == 0) {
            TopSitesGridItemView.mergeDrawableStates((int[])nArray, (int[])STATE_EMPTY);
        }
        return nArray;
    }

    public String getTitle() {
        return !TextUtils.isEmpty((CharSequence)this.mTitle) ? this.mTitle : this.mUrl;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public int getType() {
        return this.mType;
    }

    public void setTitle(String string2) {
        if (this.mTitle != null && this.mTitle.equals(string2)) {
            return;
        }
        this.mTitle = string2;
        this.updateTitleView();
    }

    public void setUrl(String string2) {
        if (this.mUrl != null && this.mUrl.equals(string2)) {
            return;
        }
        this.mUrl = string2;
        this.updateTitleView();
    }

    public void blankOut() {
        this.mUrl = "";
        this.mTitle = "";
        this.mType = 0;
        this.updateTitleView();
        this.mTitleView.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        this.setLoadId(0);
        Picasso.with((Context)this.getContext()).cancelRequest((ImageView)this.mThumbnailView);
        this.displayThumbnail(R.drawable.top_site_add);
    }

    public void markAsDirty() {
        this.mIsDirty = true;
    }

    public boolean updateState(String string2, String string3, int n, Bitmap bitmap) {
        boolean bl = false;
        if (this.mUrl == null || !this.mUrl.equals(string3)) {
            this.mUrl = string3;
            bl = true;
        }
        if (this.mTitle == null || !this.mTitle.equals(string2)) {
            this.mTitle = string2;
            bl = true;
        }
        if (bitmap != null) {
            this.displayThumbnail(bitmap);
        } else if (bl) {
            this.mThumbnailSet = false;
        }
        if (bl) {
            this.updateTitleView();
            this.setLoadId(0);
            Picasso.with((Context)this.getContext()).cancelRequest((ImageView)this.mThumbnailView);
        }
        if (this.mType != n) {
            this.mType = n;
            int n2 = n == 2 ? R.drawable.pin : 0;
            this.mTitleView.setCompoundDrawablesWithIntrinsicBounds(n2, 0, 0, 0);
            bl = true;
        }
        bl = bl || this.mIsDirty;
        this.mIsDirty = false;
        return bl;
    }

    public void displayThumbnail(int n) {
        this.mThumbnailView.setScaleType(SCALE_TYPE_RESOURCE);
        this.mThumbnailView.setImageResource(n);
        this.mThumbnailView.setBackgroundColor(0);
        this.mThumbnailSet = false;
    }

    public void displayThumbnail(Bitmap bitmap) {
        if (bitmap == null) {
            this.displayThumbnail(R.drawable.favicon);
            return;
        }
        this.mThumbnailSet = true;
        Favicons.cancelFaviconLoad(this.mLoadId);
        Picasso.with((Context)this.getContext()).cancelRequest((ImageView)this.mThumbnailView);
        this.mThumbnailView.setScaleType(SCALE_TYPE_THUMBNAIL);
        this.mThumbnailView.setImageBitmap(bitmap);
        this.mThumbnailView.setBackgroundDrawable(null);
    }

    public void displayThumbnail(String string2, int n) {
        this.mThumbnailView.setScaleType(SCALE_TYPE_RESOURCE);
        this.mThumbnailView.setBackgroundColor(n);
        this.mThumbnailSet = true;
        Picasso.with((Context)this.getContext()).load(string2).noFade().error(R.drawable.favicon).into((ImageView)this.mThumbnailView);
    }

    public void displayFavicon(Bitmap bitmap, String string2, int n) {
        if (this.mLoadId != 0 && this.mLoadId != n) {
            return;
        }
        this.displayFavicon(bitmap, string2);
    }

    public void displayFavicon(Bitmap bitmap, String string2) {
        if (this.mThumbnailSet) {
            return;
        }
        if (bitmap == null) {
            this.displayThumbnail(R.drawable.favicon);
            return;
        }
        if (string2 != null) {
            this.mFaviconURL = string2;
        }
        this.mThumbnailView.setScaleType(SCALE_TYPE_FAVICON);
        this.mThumbnailView.setImageBitmap(bitmap);
        if (this.mFaviconURL != null) {
            int n = Favicons.getFaviconColor(this.mFaviconURL);
            this.mThumbnailView.setBackgroundColorWithOpacityFilter(n);
        }
    }

    private void updateTitleView() {
        String string2 = this.getTitle();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.mTitleView.setText((CharSequence)string2);
        } else {
            this.mTitleView.setText(R.string.home_top_sites_add);
        }
        this.refreshDrawableState();
    }

    public void setLoadId(int n) {
        Favicons.cancelFaviconLoad(this.mLoadId);
        this.mLoadId = n;
    }
}

