/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.ref.WeakReference;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.widget.FaviconView;

public class TwoLinePageRow
extends LinearLayout
implements Tabs.OnTabsChangedListener {
    protected static final int NO_ICON = 0;
    private final TextView mTitle;
    private final TextView mUrl;
    private int mSwitchToTabIconId;
    private int mPageTypeIconId;
    private final FaviconView mFavicon;
    private boolean mShowIcons;
    private int mLoadFaviconJobId = 0;
    private final OnFaviconLoadedListener mFaviconListener;
    private String mPageUrl;

    public TwoLinePageRow(Context context) {
        this(context, null);
    }

    public TwoLinePageRow(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setGravity(16);
        LayoutInflater.from((Context)context).inflate(R.layout.two_line_page_row, (ViewGroup)this);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mUrl = (TextView)this.findViewById(R.id.url);
        this.mSwitchToTabIconId = 0;
        this.mPageTypeIconId = 0;
        this.mShowIcons = true;
        this.mFavicon = (FaviconView)this.findViewById(R.id.icon);
        this.mFaviconListener = new UpdateViewFaviconLoadedListener(this.mFavicon);
    }

    protected void onAttachedToWindow() {
        Tabs.registerOnTabsChangedListener(this);
    }

    protected void onDetachedFromWindow() {
        Tabs.unregisterOnTabsChangedListener(this);
    }

    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case ADDED: 
            case CLOSED: 
            case LOCATION_CHANGE: {
                this.updateDisplayedUrl();
            }
        }
    }

    private void setTitle(String string2) {
        this.mTitle.setText((CharSequence)string2);
    }

    protected void setUrl(String string2) {
        this.mUrl.setText((CharSequence)string2);
    }

    protected void setUrl(int n) {
        this.mUrl.setText(n);
    }

    protected String getUrl() {
        return this.mPageUrl;
    }

    protected void setSwitchToTabIcon(int n) {
        if (this.mSwitchToTabIconId == n) {
            return;
        }
        this.mSwitchToTabIconId = n;
        this.mUrl.setCompoundDrawablesWithIntrinsicBounds(this.mSwitchToTabIconId, 0, this.mPageTypeIconId, 0);
    }

    private void setPageTypeIcon(int n) {
        if (this.mPageTypeIconId == n) {
            return;
        }
        this.mPageTypeIconId = n;
        this.mUrl.setCompoundDrawablesWithIntrinsicBounds(this.mSwitchToTabIconId, 0, this.mPageTypeIconId, 0);
    }

    private void updateDisplayedUrl(String string2) {
        this.mPageUrl = string2;
        this.updateDisplayedUrl();
    }

    protected void updateDisplayedUrl() {
        boolean bl = Tabs.getInstance().getSelectedTab().isPrivate();
        Tab tab = Tabs.getInstance().getFirstTabForUrl(this.mPageUrl, bl);
        if (!this.mShowIcons || tab == null) {
            this.setUrl(this.mPageUrl);
            this.setSwitchToTabIcon(0);
        } else {
            this.setUrl(R.string.switch_to_tab);
            this.setSwitchToTabIcon(R.drawable.ic_url_bar_tab);
        }
    }

    public void setShowIcons(boolean bl) {
        this.mShowIcons = bl;
    }

    public void updateFromCursor(Cursor cursor) {
        if (cursor == null) {
            return;
        }
        int n = cursor.getColumnIndexOrThrow("title");
        String string2 = cursor.getString(n);
        int n2 = cursor.getColumnIndexOrThrow("url");
        String string3 = cursor.getString(n2);
        if (this.mShowIcons) {
            int n3 = cursor.getColumnIndex("bookmark_id");
            if (n3 != -1) {
                long l = cursor.getLong(n3);
                int n4 = cursor.getColumnIndex("display");
                int n5 = n4 != -1 ? cursor.getInt(n4) : 0;
                if (l == 0L) {
                    this.setPageTypeIcon(0);
                } else if (n5 == 1) {
                    this.setPageTypeIcon(R.drawable.ic_url_bar_reader);
                } else {
                    this.setPageTypeIcon(R.drawable.ic_url_bar_star);
                }
            } else {
                this.setPageTypeIcon(0);
            }
        }
        this.setTitle(TextUtils.isEmpty((CharSequence)string2) ? string3 : string2);
        if (string3.equals(this.mPageUrl)) {
            return;
        }
        this.mFavicon.clearImage();
        this.mLoadFaviconJobId = Favicons.getSizedFaviconForPageFromLocal(string3, this.mFaviconListener);
        this.updateDisplayedUrl(string3);
    }

    private static class UpdateViewFaviconLoadedListener
    implements OnFaviconLoadedListener {
        private final WeakReference<FaviconView> view;

        public UpdateViewFaviconLoadedListener(FaviconView faviconView) {
            this.view = new WeakReference<FaviconView>(faviconView);
        }

        public void onFaviconLoaded(String string2, String string3, Bitmap bitmap) {
            FaviconView faviconView = (FaviconView)((Object)this.view.get());
            if (faviconView == null) {
                return;
            }
            if (bitmap == null) {
                faviconView.showDefaultFavicon();
                return;
            }
            faviconView.updateImage(bitmap, string3);
        }
    }
}

