/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.preferences.CustomListCategory;
import org.mozilla.gecko.preferences.CustomListPreference;
import org.mozilla.gecko.preferences.PanelsPreference;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UiAsyncTask;

public class PanelsPreferenceCategory
extends CustomListCategory {
    public static final String LOGTAG = "PanelsPrefCategory";
    protected HomeConfig mHomeConfig;
    protected HomeConfig.Editor mConfigEditor;
    protected UiAsyncTask<Void, Void, HomeConfig.State> mLoadTask;

    public PanelsPreferenceCategory(Context context) {
        super(context);
        this.initConfig(context);
    }

    public PanelsPreferenceCategory(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initConfig(context);
    }

    public PanelsPreferenceCategory(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initConfig(context);
    }

    protected void initConfig(Context context) {
        this.mHomeConfig = HomeConfig.getDefault(context);
    }

    public void onAttachedToActivity() {
        super.onAttachedToActivity();
        this.loadHomeConfig(null);
    }

    private void loadHomeConfig(final String string2) {
        this.mLoadTask = new UiAsyncTask<Void, Void, HomeConfig.State>(ThreadUtils.getBackgroundHandler()){

            public HomeConfig.State doInBackground(Void ... voidArray) {
                return PanelsPreferenceCategory.this.mHomeConfig.load();
            }

            public void onPostExecute(HomeConfig.State state) {
                PanelsPreferenceCategory.this.mConfigEditor = state.edit();
                PanelsPreferenceCategory.this.displayHomeConfig(state, string2);
            }
        };
        this.mLoadTask.execute((Object[])new Void[0]);
    }

    public void refresh() {
        this.refresh(null, null);
    }

    public void refresh(HomeConfig.State state, String string2) {
        this.removeAll();
        if (state == null) {
            this.loadHomeConfig(string2);
        } else {
            this.displayHomeConfig(state, string2);
        }
    }

    private void displayHomeConfig(HomeConfig.State state, String string2) {
        int n = 0;
        for (HomeConfig.PanelConfig panelConfig : state) {
            String string3 = panelConfig.getId();
            boolean bl = TextUtils.equals((CharSequence)string2, (CharSequence)string3);
            PanelsPreference panelsPreference = new PanelsPreference(this.getContext(), this, n, bl);
            panelsPreference.setTitle(panelConfig.getTitle());
            panelsPreference.setKey(panelConfig.getId());
            this.addPreference(panelsPreference);
            if (panelConfig.isDisabled()) {
                panelsPreference.setHidden(true);
            }
            ++n;
        }
        this.setPositionState();
        this.setDefaultFromConfig();
    }

    private void setPositionState() {
        int n = this.getPreferenceCount();
        PanelsPreference panelsPreference = (PanelsPreference)this.getPreference(0);
        panelsPreference.setIsFirst();
        PanelsPreference panelsPreference2 = (PanelsPreference)this.getPreference(n - 1);
        panelsPreference2.setIsLast();
    }

    private void setDefaultFromConfig() {
        String string2 = this.mConfigEditor.getDefaultPanelId();
        if (string2 == null) {
            this.mDefaultReference = null;
            return;
        }
        int n = this.getPreferenceCount();
        for (int i = 0; i < n; ++i) {
            PanelsPreference panelsPreference = (PanelsPreference)this.getPreference(i);
            if (!string2.equals(panelsPreference.getKey())) continue;
            super.setDefault(panelsPreference);
            break;
        }
    }

    public void setDefault(CustomListPreference customListPreference) {
        super.setDefault(customListPreference);
        String string2 = customListPreference.getKey();
        String string3 = this.mConfigEditor.getDefaultPanelId();
        if (string3 != null && string3.equals(string2)) {
            return;
        }
        this.mConfigEditor.setDefault(string2);
        this.mConfigEditor.apply();
        Telemetry.sendUIEvent(TelemetryContract.Event.PANEL_SET_DEFAULT, TelemetryContract.Method.NONE, string2);
    }

    protected void onPrepareForRemoval() {
        if (this.mLoadTask != null) {
            this.mLoadTask.cancel(true);
        }
    }

    public void uninstall(CustomListPreference customListPreference) {
        this.mConfigEditor.uninstall(customListPreference.getKey());
        this.mConfigEditor.apply();
        super.uninstall(customListPreference);
    }

    public void moveUp(PanelsPreference panelsPreference) {
        int n = panelsPreference.getIndex();
        if (n > 0) {
            String string2 = panelsPreference.getKey();
            this.mConfigEditor.moveTo(string2, n - 1);
            HomeConfig.State state = this.mConfigEditor.apply();
            this.refresh(state, string2);
        }
    }

    public void moveDown(PanelsPreference panelsPreference) {
        int n = panelsPreference.getIndex();
        if (n < this.getPreferenceCount() - 1) {
            String string2 = panelsPreference.getKey();
            this.mConfigEditor.moveTo(string2, n + 1);
            HomeConfig.State state = this.mConfigEditor.apply();
            this.refresh(state, string2);
        }
    }

    protected void setHidden(PanelsPreference panelsPreference, boolean bl) {
        this.mConfigEditor.setDisabled(panelsPreference.getKey(), bl);
        this.mConfigEditor.apply();
        panelsPreference.setHidden(bl);
        this.setDefaultFromConfig();
    }

    protected void setFallbackDefault() {
        this.setDefaultFromConfig();
    }
}

