/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.preferences.MultiChoicePreference;

class PrivateDataPreference
extends MultiChoicePreference {
    private static final String LOGTAG = "GeckoPrivateDataPreference";
    private static final String PREF_KEY_PREFIX = "private.data.";

    public PrivateDataPreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        if (!bl) {
            return;
        }
        Telemetry.sendUIEvent(TelemetryContract.Event.SANITIZE, TelemetryContract.Method.DIALOG, "settings");
        CharSequence[] charSequenceArray = this.getEntryKeys();
        boolean[] blArray = this.getValues();
        JSONObject jSONObject = new JSONObject();
        for (int i = 0; i < charSequenceArray.length; ++i) {
            String string2 = ((Object)charSequenceArray[i]).toString().substring(PREF_KEY_PREFIX.length());
            boolean bl2 = blArray[i];
            try {
                jSONObject.put(string2, bl2);
                continue;
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"JSON error", (Throwable)jSONException);
            }
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Sanitize:ClearData", jSONObject.toString()));
    }
}

