/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.ContentProviderClient;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import java.util.ArrayList;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.db.Tab;
import org.mozilla.gecko.sync.delegates.ClientsDataDelegate;
import org.mozilla.gecko.sync.repositories.InactiveSessionException;
import org.mozilla.gecko.sync.repositories.NoContentProviderException;
import org.mozilla.gecko.sync.repositories.NoStoreDelegateException;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.RepositorySession;
import org.mozilla.gecko.sync.repositories.android.BrowserContractHelpers;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionCreationDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFetchRecordsDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFinishDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionGuidsSinceDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionWipeDelegate;
import org.mozilla.gecko.sync.repositories.domain.Record;
import org.mozilla.gecko.sync.repositories.domain.TabsRecord;

public class FennecTabsRepository
extends Repository {
    protected final ClientsDataDelegate clientsDataDelegate;

    public FennecTabsRepository(ClientsDataDelegate clientsDataDelegate) {
        this.clientsDataDelegate = clientsDataDelegate;
    }

    public void createSession(RepositorySessionCreationDelegate repositorySessionCreationDelegate, Context context) {
        try {
            FennecTabsRepositorySession fennecTabsRepositorySession = new FennecTabsRepositorySession(this, context);
            repositorySessionCreationDelegate.onSessionCreated(fennecTabsRepositorySession);
        }
        catch (Exception exception) {
            repositorySessionCreationDelegate.onSessionCreateFailed(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TabsRecord tabsRecordFromCursor(Cursor cursor, String string2, String string3) {
        TabsRecord tabsRecord = new TabsRecord(string2, "tabs", 0L, false);
        tabsRecord.tabs = new ArrayList();
        tabsRecord.clientName = string3;
        tabsRecord.androidID = -1L;
        tabsRecord.deleted = false;
        tabsRecord.lastModified = 0L;
        int n = cursor.getPosition();
        try {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                Tab tab = Tab.fromCursor(cursor);
                tabsRecord.tabs.add(tab);
                if (tab.lastUsed > tabsRecord.lastModified) {
                    tabsRecord.lastModified = tab.lastUsed;
                }
                cursor.moveToNext();
            }
        }
        finally {
            cursor.moveToPosition(n);
        }
        return tabsRecord;
    }

    public class FennecTabsRepositorySession
    extends RepositorySession {
        protected static final String LOG_TAG = "FennecTabsSession";
        private final ContentProviderClient tabsProvider;
        private final ContentProviderClient clientsProvider;
        protected final RepoUtils.QueryHelper tabsHelper;
        private static final String TABS_CLIENT_GUID_IS = "client_guid = ?";
        private static final String CLIENT_GUID_IS = "guid = ?";

        protected ContentProviderClient getContentProvider(Context context, Uri uri) throws NoContentProviderException {
            ContentProviderClient contentProviderClient = context.getContentResolver().acquireContentProviderClient(uri);
            if (contentProviderClient == null) {
                throw new NoContentProviderException(uri);
            }
            return contentProviderClient;
        }

        protected void releaseProviders() {
            try {
                this.clientsProvider.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.tabsProvider.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public FennecTabsRepositorySession(Repository repository, Context context) throws NoContentProviderException {
            super(repository);
            this.clientsProvider = this.getContentProvider(context, BrowserContractHelpers.CLIENTS_CONTENT_URI);
            try {
                this.tabsProvider = this.getContentProvider(context, BrowserContractHelpers.TABS_CONTENT_URI);
            }
            catch (NoContentProviderException noContentProviderException) {
                this.clientsProvider.release();
                throw noContentProviderException;
            }
            catch (Exception exception) {
                this.clientsProvider.release();
                throw new RuntimeException(exception);
            }
            this.tabsHelper = new RepoUtils.QueryHelper(context, BrowserContractHelpers.TABS_CONTENT_URI, LOG_TAG);
        }

        public void abort() {
            this.releaseProviders();
            super.abort();
        }

        public void finish(RepositorySessionFinishDelegate repositorySessionFinishDelegate) throws InactiveSessionException {
            this.releaseProviders();
            super.finish(repositorySessionFinishDelegate);
        }

        protected String localClientSelection() {
            return "client_guid IS NULL";
        }

        protected String[] localClientSelectionArgs() {
            return null;
        }

        public void guidsSince(long l, final RepositorySessionGuidsSinceDelegate repositorySessionGuidsSinceDelegate) {
            Logger.warn(LOG_TAG, "Not returning anything from guidsSince.");
            this.delegateQueue.execute(new Runnable(){

                public void run() {
                    repositorySessionGuidsSinceDelegate.onGuidsSinceSucceeded(new String[0]);
                }
            });
        }

        public void fetchSince(final long l, final RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
            if (this.tabsProvider == null) {
                throw new IllegalArgumentException("tabsProvider was null.");
            }
            if (this.tabsHelper == null) {
                throw new IllegalArgumentException("tabsHelper was null.");
            }
            final String string2 = this.localClientSelection();
            final String[] stringArray = this.localClientSelectionArgs();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Cursor cursor = FennecTabsRepositorySession.this.tabsHelper.safeQuery(FennecTabsRepositorySession.this.tabsProvider, ".fetchSince()", null, string2, stringArray, "position ASC");
                        try {
                            String string22 = FennecTabsRepository.this.clientsDataDelegate.getAccountGUID();
                            String string3 = FennecTabsRepository.this.clientsDataDelegate.getClientName();
                            TabsRecord tabsRecord = FennecTabsRepository.tabsRecordFromCursor(cursor, string22, string3);
                            if (tabsRecord.lastModified >= l || FennecTabsRepository.this.clientsDataDelegate.getLastModifiedTimestamp() >= l) {
                                repositorySessionFetchRecordsDelegate.onFetchedRecord(tabsRecord);
                            }
                        }
                        finally {
                            cursor.close();
                        }
                    }
                    catch (Exception exception) {
                        repositorySessionFetchRecordsDelegate.onFetchFailed(exception, null);
                        return;
                    }
                    repositorySessionFetchRecordsDelegate.onFetchCompleted(RepositorySession.now());
                }
            };
            this.delegateQueue.execute(runnable);
        }

        public void fetch(String[] stringArray, final RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
            Logger.warn(LOG_TAG, "Not returning anything from fetch");
            this.delegateQueue.execute(new Runnable(){

                public void run() {
                    repositorySessionFetchRecordsDelegate.onFetchCompleted(RepositorySession.now());
                }
            });
        }

        public void fetchAll(RepositorySessionFetchRecordsDelegate repositorySessionFetchRecordsDelegate) {
            this.fetchSince(0L, repositorySessionFetchRecordsDelegate);
        }

        public void store(final Record record) throws NoStoreDelegateException {
            if (this.delegate == null) {
                Logger.warn(LOG_TAG, "No store delegate.");
                throw new NoStoreDelegateException();
            }
            if (record == null) {
                Logger.error(LOG_TAG, "Record sent to store was null");
                throw new IllegalArgumentException("Null record passed to FennecTabsRepositorySession.store().");
            }
            if (!(record instanceof TabsRecord)) {
                Logger.error(LOG_TAG, "Can't store anything but a TabsRecord");
                throw new IllegalArgumentException("Non-TabsRecord passed to FennecTabsRepositorySession.store().");
            }
            final TabsRecord tabsRecord = (TabsRecord)record;
            Runnable runnable = new Runnable(){

                public void run() {
                    Logger.debug(FennecTabsRepositorySession.LOG_TAG, "Storing tabs for client " + tabsRecord.guid);
                    if (!FennecTabsRepositorySession.this.isActive()) {
                        FennecTabsRepositorySession.this.delegate.onRecordStoreFailed(new InactiveSessionException(null), record.guid);
                        return;
                    }
                    if (tabsRecord.guid == null) {
                        FennecTabsRepositorySession.this.delegate.onRecordStoreFailed(new RuntimeException("Can't store record with null GUID."), record.guid);
                        return;
                    }
                    try {
                        String[] stringArray = new String[]{tabsRecord.guid};
                        if (tabsRecord.deleted) {
                            try {
                                Logger.debug(FennecTabsRepositorySession.LOG_TAG, "Clearing entry for client " + tabsRecord.guid);
                                FennecTabsRepositorySession.this.clientsProvider.delete(BrowserContractHelpers.CLIENTS_CONTENT_URI, FennecTabsRepositorySession.CLIENT_GUID_IS, stringArray);
                                FennecTabsRepositorySession.this.delegate.onRecordStoreSucceeded(record.guid);
                            }
                            catch (Exception exception) {
                                FennecTabsRepositorySession.this.delegate.onRecordStoreFailed(exception, record.guid);
                            }
                            return;
                        }
                        ContentValues contentValues = tabsRecord.getClientsContentValues();
                        Logger.debug(FennecTabsRepositorySession.LOG_TAG, "Updating clients provider.");
                        int n = FennecTabsRepositorySession.this.clientsProvider.update(BrowserContractHelpers.CLIENTS_CONTENT_URI, contentValues, FennecTabsRepositorySession.CLIENT_GUID_IS, stringArray);
                        if (0 == n) {
                            FennecTabsRepositorySession.this.clientsProvider.insert(BrowserContractHelpers.CLIENTS_CONTENT_URI, contentValues);
                        }
                        ContentValues[] contentValuesArray = tabsRecord.getTabsContentValues();
                        Logger.debug(FennecTabsRepositorySession.LOG_TAG, "Inserting " + contentValuesArray.length + " tabs for client " + tabsRecord.guid);
                        FennecTabsRepositorySession.this.tabsProvider.delete(BrowserContractHelpers.TABS_CONTENT_URI, FennecTabsRepositorySession.TABS_CLIENT_GUID_IS, stringArray);
                        int n2 = FennecTabsRepositorySession.this.tabsProvider.bulkInsert(BrowserContractHelpers.TABS_CONTENT_URI, contentValuesArray);
                        Logger.trace(FennecTabsRepositorySession.LOG_TAG, "Inserted: " + n2);
                        FennecTabsRepositorySession.this.delegate.onRecordStoreSucceeded(record.guid);
                    }
                    catch (Exception exception) {
                        Logger.warn(FennecTabsRepositorySession.LOG_TAG, "Error storing tabs.", exception);
                        FennecTabsRepositorySession.this.delegate.onRecordStoreFailed(exception, record.guid);
                    }
                }
            };
            this.storeWorkQueue.execute(runnable);
        }

        public void wipe(RepositorySessionWipeDelegate repositorySessionWipeDelegate) {
            try {
                this.tabsProvider.delete(BrowserContractHelpers.TABS_CONTENT_URI, null, null);
                this.clientsProvider.delete(BrowserContractHelpers.CLIENTS_CONTENT_URI, null, null);
            }
            catch (RemoteException remoteException) {
                Logger.warn(LOG_TAG, "Got RemoteException in wipe.", remoteException);
                repositorySessionWipeDelegate.onWipeFailed((Exception)((Object)remoteException));
                return;
            }
            repositorySessionWipeDelegate.onWipeSucceeded();
        }
    }
}

