/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabspanel;

import android.content.Context;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.SimpleExpandableListAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.TabsAccessor;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.tabspanel.TabsPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteTabsList
extends ExpandableListView
implements ExpandableListView.OnGroupClickListener,
ExpandableListView.OnChildClickListener,
TabsAccessor.OnQueryTabsCompleteListener {
    private static final String[] CLIENT_KEY = new String[]{"name", "last_synced"};
    private static final String[] TAB_KEY = new String[]{"title", "url"};
    private static final int[] CLIENT_RESOURCE = new int[]{R.id.client, R.id.last_synced};
    private static final int[] TAB_RESOURCE = new int[]{R.id.tab, R.id.url};
    private final Context context;
    private TabsPanel tabsPanel;
    private ArrayList<ArrayList<HashMap<String, String>>> tabsList;

    public RemoteTabsList(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.context = context;
        this.setOnGroupClickListener(this);
        this.setOnChildClickListener(this);
    }

    public void setTabsPanel(TabsPanel tabsPanel) {
        this.tabsPanel = tabsPanel;
    }

    private void autoHidePanel() {
        this.tabsPanel.autoHidePanel();
    }

    public boolean onGroupClick(ExpandableListView expandableListView, View view, int n, long l) {
        return true;
    }

    public boolean onChildClick(ExpandableListView expandableListView, View view, int n, int n2, long l) {
        HashMap<String, String> hashMap = this.tabsList.get(n).get(n2);
        if (hashMap == null) {
            this.autoHidePanel();
            return true;
        }
        Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.NONE, "remote");
        Tabs.getInstance().loadUrl(hashMap.get("url"), 1);
        this.autoHidePanel();
        return true;
    }

    @Override
    public void onQueryTabsComplete(List<TabsAccessor.RemoteTab> list) {
        ArrayList<TabsAccessor.RemoteTab> arrayList = new ArrayList<TabsAccessor.RemoteTab>(list);
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        ArrayList arrayList2 = new ArrayList();
        this.tabsList = new ArrayList();
        String string2 = null;
        ArrayList arrayList3 = null;
        long l = System.currentTimeMillis();
        for (TabsAccessor.RemoteTab remoteTab : arrayList) {
            if (string2 == null || !TextUtils.equals(string2, (CharSequence)remoteTab.guid)) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("name", remoteTab.name);
                hashMap.put("last_synced", this.getLastSyncedString(l, remoteTab.lastModified));
                arrayList2.add(hashMap);
                arrayList3 = new ArrayList();
                this.tabsList.add(arrayList3);
                string2 = new String(remoteTab.guid);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("title", TextUtils.isEmpty((CharSequence)remoteTab.title) ? remoteTab.url : remoteTab.title);
            hashMap.put("url", remoteTab.url);
            arrayList3.add(hashMap);
        }
        this.setAdapter((ExpandableListAdapter)new SimpleExpandableListAdapter(this.context, arrayList2, R.layout.remote_tabs_group, CLIENT_KEY, CLIENT_RESOURCE, this.tabsList, R.layout.remote_tabs_child, TAB_KEY, TAB_RESOURCE));
        for (int i = 0; i < arrayList2.size(); ++i) {
            this.expandGroup(i);
        }
    }

    protected String getLastSyncedString(long l, long l2) {
        CharSequence charSequence = DateUtils.getRelativeTimeSpanString((long)l2, (long)l, (long)60000L);
        return this.getResources().getString(R.string.remote_tabs_last_synced, new Object[]{charSequence});
    }
}

