/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabspanel;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.tabspanel.TabsPanel;

class RemoteTabsVerificationPanel
extends LinearLayout
implements TabsPanel.PanelView {
    private static final String LOG_TAG = RemoteTabsVerificationPanel.class.getSimpleName();
    private TabsPanel tabsPanel;

    public RemoteTabsVerificationPanel(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        View view = this.findViewById(R.id.remote_tabs_confirm_resend);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                State state = FirefoxAccounts.getFirefoxAccountState(RemoteTabsVerificationPanel.this.getContext());
                State.Action action = state.getNeededAction();
                if (state.getNeededAction() != State.Action.NeedsVerification) {
                    RemoteTabsVerificationPanel.this.autoHideTabsPanelOnUnexpectedState("Account expected to need verification on resend, but action was " + (Object)((Object)action) + " instead.");
                    return;
                }
                if (!FirefoxAccounts.resendVerificationEmail(RemoteTabsVerificationPanel.this.getContext())) {
                    RemoteTabsVerificationPanel.this.autoHideTabsPanelOnUnexpectedState("Account DNE when resending verification email.");
                    return;
                }
            }
        });
    }

    private void refresh() {
        TextView textView = (TextView)this.findViewById(R.id.remote_tabs_confirm_verification);
        String string2 = FirefoxAccounts.getFirefoxAccountEmail(this.getContext());
        if (string2 == null) {
            this.autoHideTabsPanelOnUnexpectedState("Account email DNE on View refresh.");
            return;
        }
        String string3 = this.getResources().getString(R.string.fxaccount_confirm_account_verification_link, new Object[]{string2});
        textView.setText((CharSequence)string3);
    }

    private void autoHideTabsPanelOnUnexpectedState(String string2) {
        Log.w((String)LOG_TAG, (String)("Unexpected state: " + string2 + " Closing the tabs panel."));
        if (this.tabsPanel != null) {
            this.tabsPanel.autoHidePanel();
        }
    }

    public void setTabsPanel(TabsPanel tabsPanel) {
        this.tabsPanel = tabsPanel;
    }

    public void show() {
        this.refresh();
        this.setVisibility(0);
    }

    public void hide() {
        this.setVisibility(8);
    }

    public boolean shouldExpand() {
        return this.getOrientation() == 1;
    }
}

