/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.TabWidget;
import android.widget.TextView;
import org.mozilla.gecko.R;

public class IconTabWidget
extends TabWidget {
    private OnTabChangedListener mListener;
    private final int mButtonLayoutId;
    private final boolean mIsIcon;

    public IconTabWidget(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.IconTabWidget);
        this.mButtonLayoutId = typedArray.getResourceId(0, 0);
        this.mIsIcon = typedArray.getInt(1, 0) == 0;
        typedArray.recycle();
        if (this.mButtonLayoutId == 0) {
            throw new RuntimeException("You must supply layout attribute");
        }
    }

    public void addTab(int n, int n2) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(this.mButtonLayoutId, (ViewGroup)this, false);
        if (this.mIsIcon) {
            ((ImageButton)view).setImageResource(n);
            view.setContentDescription((CharSequence)this.getContext().getString(n2));
        } else {
            ((TextView)view).setText((CharSequence)this.getContext().getString(n2));
        }
        this.addView(view);
        view.setOnClickListener((View.OnClickListener)new TabClickListener(this.getTabCount() - 1));
        view.setOnFocusChangeListener((View.OnFocusChangeListener)this);
    }

    public void setTabSelectionListener(OnTabChangedListener onTabChangedListener) {
        this.mListener = onTabChangedListener;
    }

    public void onFocusChange(View view, boolean bl) {
    }

    public Drawable getIconDrawable(int n) {
        if (!this.mIsIcon) {
            return null;
        }
        View view = this.getChildTabViewAt(n);
        if (view instanceof ImageButton) {
            return ((ImageButton)view).getDrawable();
        }
        return null;
    }

    public void setIconDrawable(int n, int n2) {
        if (!this.mIsIcon) {
            return;
        }
        View view = this.getChildTabViewAt(n);
        if (view instanceof ImageButton) {
            ((ImageButton)view).setImageResource(n2);
        }
    }

    private class TabClickListener
    implements View.OnClickListener {
        private final int mIndex;

        public TabClickListener(int n) {
            this.mIndex = n;
        }

        public void onClick(View view) {
            if (IconTabWidget.this.mListener != null) {
                IconTabWidget.this.mListener.onTabChanged(this.mIndex);
            }
        }
    }

    public static interface OnTabChangedListener {
        public void onTabChanged(int var1);
    }
}

