/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class ContentStreamBitmapHunter
extends BitmapHunter {
    final Context context;

    ContentStreamBitmapHunter(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        super(picasso, dispatcher, cache, stats, action);
        this.context = context;
    }

    Bitmap decode(Request request) throws IOException {
        return this.decodeContentStream(request);
    }

    Picasso.LoadedFrom getLoadedFrom() {
        return Picasso.LoadedFrom.DISK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bitmap decodeContentStream(Request request) throws IOException {
        InputStream inputStream;
        ContentResolver contentResolver = this.context.getContentResolver();
        BitmapFactory.Options options = null;
        if (request.hasSize()) {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            inputStream = null;
            try {
                inputStream = contentResolver.openInputStream(request.uri);
                BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            }
            finally {
                Utils.closeQuietly(inputStream);
            }
            ContentStreamBitmapHunter.calculateInSampleSize(request.targetWidth, request.targetHeight, options);
        }
        inputStream = contentResolver.openInputStream(request.uri);
        try {
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            Utils.closeQuietly(inputStream);
        }
    }
}

