/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.message;

import ch.boye.httpclientandroidlib.HeaderElement;
import ch.boye.httpclientandroidlib.NameValuePair;
import ch.boye.httpclientandroidlib.message.HeaderValueFormatter;
import ch.boye.httpclientandroidlib.util.CharArrayBuffer;

public class BasicHeaderValueFormatter
implements HeaderValueFormatter {
    public static final BasicHeaderValueFormatter DEFAULT = new BasicHeaderValueFormatter();
    public static final String SEPARATORS = " ;,:@()<>\\\"/[]?={}\t";
    public static final String UNSAFE_CHARS = "\"\\";

    public static final String formatElements(HeaderElement[] headerElementArray, boolean bl, HeaderValueFormatter headerValueFormatter) {
        if (headerValueFormatter == null) {
            headerValueFormatter = DEFAULT;
        }
        return headerValueFormatter.formatElements(null, headerElementArray, bl).toString();
    }

    public CharArrayBuffer formatElements(CharArrayBuffer charArrayBuffer, HeaderElement[] headerElementArray, boolean bl) {
        if (headerElementArray == null) {
            throw new IllegalArgumentException("Header element array must not be null.");
        }
        int n = this.estimateElementsLen(headerElementArray);
        if (charArrayBuffer == null) {
            charArrayBuffer = new CharArrayBuffer(n);
        } else {
            charArrayBuffer.ensureCapacity(n);
        }
        for (int i = 0; i < headerElementArray.length; ++i) {
            if (i > 0) {
                charArrayBuffer.append(", ");
            }
            this.formatHeaderElement(charArrayBuffer, headerElementArray[i], bl);
        }
        return charArrayBuffer;
    }

    protected int estimateElementsLen(HeaderElement[] headerElementArray) {
        if (headerElementArray == null || headerElementArray.length < 1) {
            return 0;
        }
        int n = (headerElementArray.length - 1) * 2;
        for (int i = 0; i < headerElementArray.length; ++i) {
            n += this.estimateHeaderElementLen(headerElementArray[i]);
        }
        return n;
    }

    public static final String formatHeaderElement(HeaderElement headerElement, boolean bl, HeaderValueFormatter headerValueFormatter) {
        if (headerValueFormatter == null) {
            headerValueFormatter = DEFAULT;
        }
        return headerValueFormatter.formatHeaderElement(null, headerElement, bl).toString();
    }

    public CharArrayBuffer formatHeaderElement(CharArrayBuffer charArrayBuffer, HeaderElement headerElement, boolean bl) {
        int n;
        if (headerElement == null) {
            throw new IllegalArgumentException("Header element must not be null.");
        }
        int n2 = this.estimateHeaderElementLen(headerElement);
        if (charArrayBuffer == null) {
            charArrayBuffer = new CharArrayBuffer(n2);
        } else {
            charArrayBuffer.ensureCapacity(n2);
        }
        charArrayBuffer.append(headerElement.getName());
        String string = headerElement.getValue();
        if (string != null) {
            charArrayBuffer.append('=');
            this.doFormatValue(charArrayBuffer, string, bl);
        }
        if ((n = headerElement.getParameterCount()) > 0) {
            for (int i = 0; i < n; ++i) {
                charArrayBuffer.append("; ");
                this.formatNameValuePair(charArrayBuffer, headerElement.getParameter(i), bl);
            }
        }
        return charArrayBuffer;
    }

    protected int estimateHeaderElementLen(HeaderElement headerElement) {
        int n;
        if (headerElement == null) {
            return 0;
        }
        int n2 = headerElement.getName().length();
        String string = headerElement.getValue();
        if (string != null) {
            n2 += 3 + string.length();
        }
        if ((n = headerElement.getParameterCount()) > 0) {
            for (int i = 0; i < n; ++i) {
                n2 += 2 + this.estimateNameValuePairLen(headerElement.getParameter(i));
            }
        }
        return n2;
    }

    public static final String formatParameters(NameValuePair[] nameValuePairArray, boolean bl, HeaderValueFormatter headerValueFormatter) {
        if (headerValueFormatter == null) {
            headerValueFormatter = DEFAULT;
        }
        return headerValueFormatter.formatParameters(null, nameValuePairArray, bl).toString();
    }

    public CharArrayBuffer formatParameters(CharArrayBuffer charArrayBuffer, NameValuePair[] nameValuePairArray, boolean bl) {
        if (nameValuePairArray == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        int n = this.estimateParametersLen(nameValuePairArray);
        if (charArrayBuffer == null) {
            charArrayBuffer = new CharArrayBuffer(n);
        } else {
            charArrayBuffer.ensureCapacity(n);
        }
        for (int i = 0; i < nameValuePairArray.length; ++i) {
            if (i > 0) {
                charArrayBuffer.append("; ");
            }
            this.formatNameValuePair(charArrayBuffer, nameValuePairArray[i], bl);
        }
        return charArrayBuffer;
    }

    protected int estimateParametersLen(NameValuePair[] nameValuePairArray) {
        if (nameValuePairArray == null || nameValuePairArray.length < 1) {
            return 0;
        }
        int n = (nameValuePairArray.length - 1) * 2;
        for (int i = 0; i < nameValuePairArray.length; ++i) {
            n += this.estimateNameValuePairLen(nameValuePairArray[i]);
        }
        return n;
    }

    public static final String formatNameValuePair(NameValuePair nameValuePair, boolean bl, HeaderValueFormatter headerValueFormatter) {
        if (headerValueFormatter == null) {
            headerValueFormatter = DEFAULT;
        }
        return headerValueFormatter.formatNameValuePair(null, nameValuePair, bl).toString();
    }

    public CharArrayBuffer formatNameValuePair(CharArrayBuffer charArrayBuffer, NameValuePair nameValuePair, boolean bl) {
        if (nameValuePair == null) {
            throw new IllegalArgumentException("NameValuePair must not be null.");
        }
        int n = this.estimateNameValuePairLen(nameValuePair);
        if (charArrayBuffer == null) {
            charArrayBuffer = new CharArrayBuffer(n);
        } else {
            charArrayBuffer.ensureCapacity(n);
        }
        charArrayBuffer.append(nameValuePair.getName());
        String string = nameValuePair.getValue();
        if (string != null) {
            charArrayBuffer.append('=');
            this.doFormatValue(charArrayBuffer, string, bl);
        }
        return charArrayBuffer;
    }

    protected int estimateNameValuePairLen(NameValuePair nameValuePair) {
        if (nameValuePair == null) {
            return 0;
        }
        int n = nameValuePair.getName().length();
        String string = nameValuePair.getValue();
        if (string != null) {
            n += 3 + string.length();
        }
        return n;
    }

    protected void doFormatValue(CharArrayBuffer charArrayBuffer, String string, boolean bl) {
        int n;
        if (!bl) {
            for (n = 0; n < string.length() && !bl; ++n) {
                bl = this.isSeparator(string.charAt(n));
            }
        }
        if (bl) {
            charArrayBuffer.append('\"');
        }
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (this.isUnsafe(c)) {
                charArrayBuffer.append('\\');
            }
            charArrayBuffer.append(c);
        }
        if (bl) {
            charArrayBuffer.append('\"');
        }
    }

    protected boolean isSeparator(char c) {
        return SEPARATORS.indexOf(c) >= 0;
    }

    protected boolean isUnsafe(char c) {
        return UNSAFE_CHARS.indexOf(c) >= 0;
    }
}

