/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.protocol;

import ch.boye.httpclientandroidlib.HttpClientConnection;
import ch.boye.httpclientandroidlib.HttpEntityEnclosingRequest;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.HttpVersion;
import ch.boye.httpclientandroidlib.ProtocolVersion;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import ch.boye.httpclientandroidlib.protocol.HttpProcessor;
import java.io.IOException;
import java.net.ProtocolException;

public class HttpRequestExecutor {
    protected boolean canResponseHaveBody(HttpRequest httpRequest, HttpResponse httpResponse) {
        if ("HEAD".equalsIgnoreCase(httpRequest.getRequestLine().getMethod())) {
            return false;
        }
        int n = httpResponse.getStatusLine().getStatusCode();
        return n >= 200 && n != 204 && n != 304 && n != 205;
    }

    public HttpResponse execute(HttpRequest httpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws IOException, HttpException {
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (httpClientConnection == null) {
            throw new IllegalArgumentException("Client connection may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        try {
            HttpResponse httpResponse = this.doSendRequest(httpRequest, httpClientConnection, httpContext);
            if (httpResponse == null) {
                httpResponse = this.doReceiveResponse(httpRequest, httpClientConnection, httpContext);
            }
            return httpResponse;
        }
        catch (IOException iOException) {
            HttpRequestExecutor.closeConnection(httpClientConnection);
            throw iOException;
        }
        catch (HttpException httpException) {
            HttpRequestExecutor.closeConnection(httpClientConnection);
            throw httpException;
        }
        catch (RuntimeException runtimeException) {
            HttpRequestExecutor.closeConnection(httpClientConnection);
            throw runtimeException;
        }
    }

    private static final void closeConnection(HttpClientConnection httpClientConnection) {
        try {
            httpClientConnection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void preProcess(HttpRequest httpRequest, HttpProcessor httpProcessor, HttpContext httpContext) throws HttpException, IOException {
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        httpContext.setAttribute("http.request", httpRequest);
        httpProcessor.process(httpRequest, httpContext);
    }

    protected HttpResponse doSendRequest(HttpRequest httpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws IOException, HttpException {
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (httpClientConnection == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        HttpResponse httpResponse = null;
        httpContext.setAttribute("http.connection", httpClientConnection);
        httpContext.setAttribute("http.request_sent", Boolean.FALSE);
        httpClientConnection.sendRequestHeader(httpRequest);
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            boolean bl = true;
            ProtocolVersion protocolVersion = httpRequest.getRequestLine().getProtocolVersion();
            if (((HttpEntityEnclosingRequest)httpRequest).expectContinue() && !protocolVersion.lessEquals(HttpVersion.HTTP_1_0)) {
                httpClientConnection.flush();
                int n = httpRequest.getParams().getIntParameter("http.protocol.wait-for-continue", 2000);
                if (httpClientConnection.isResponseAvailable(n)) {
                    int n2;
                    httpResponse = httpClientConnection.receiveResponseHeader();
                    if (this.canResponseHaveBody(httpRequest, httpResponse)) {
                        httpClientConnection.receiveResponseEntity(httpResponse);
                    }
                    if ((n2 = httpResponse.getStatusLine().getStatusCode()) < 200) {
                        if (n2 != 100) {
                            throw new ProtocolException("Unexpected response: " + httpResponse.getStatusLine());
                        }
                        httpResponse = null;
                    } else {
                        bl = false;
                    }
                }
            }
            if (bl) {
                httpClientConnection.sendRequestEntity((HttpEntityEnclosingRequest)httpRequest);
            }
        }
        httpClientConnection.flush();
        httpContext.setAttribute("http.request_sent", Boolean.TRUE);
        return httpResponse;
    }

    protected HttpResponse doReceiveResponse(HttpRequest httpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws HttpException, IOException {
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (httpClientConnection == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        HttpResponse httpResponse = null;
        int n = 0;
        while (httpResponse == null || n < 200) {
            httpResponse = httpClientConnection.receiveResponseHeader();
            if (this.canResponseHaveBody(httpRequest, httpResponse)) {
                httpClientConnection.receiveResponseEntity(httpResponse);
            }
            n = httpResponse.getStatusLine().getStatusCode();
        }
        return httpResponse;
    }

    public void postProcess(HttpResponse httpResponse, HttpProcessor httpProcessor, HttpContext httpContext) throws HttpException, IOException {
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        httpContext.setAttribute("http.response", httpResponse);
        httpProcessor.process(httpResponse, httpContext);
    }
}

