/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.mozglue.JNITarget;

public class GeckoNetworkManager
extends BroadcastReceiver {
    private static final String LOGTAG = "GeckoNetworkManager";
    private static final GeckoNetworkManager sInstance = new GeckoNetworkManager();
    private ConnectionType mConnectionType = ConnectionType.NONE;
    private final IntentFilter mNetworkFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
    private boolean mShouldBeListening = false;
    private boolean mShouldNotify = false;
    private volatile Context mApplicationContext;

    public static GeckoNetworkManager getInstance() {
        return sInstance;
    }

    public void onReceive(Context context, Intent intent) {
        this.updateConnectionType();
    }

    public void start(Context context) {
        this.mApplicationContext = context.getApplicationContext();
        if (this.mConnectionType == ConnectionType.NONE) {
            this.mConnectionType = this.getConnectionType();
        }
        this.mShouldBeListening = true;
        this.updateConnectionType();
        if (this.mShouldNotify) {
            this.startListening();
        }
    }

    private void startListening() {
        Context context = this.mApplicationContext;
        if (context == null) {
            Log.w((String)LOGTAG, (String)"Not registering receiver: no context!");
            return;
        }
        Log.v((String)LOGTAG, (String)"Registering receiver.");
        context.registerReceiver((BroadcastReceiver)this, this.mNetworkFilter);
    }

    public void stop() {
        this.mShouldBeListening = false;
        if (this.mShouldNotify) {
            this.stopListening();
        }
    }

    private void stopListening() {
        if (null == this.mApplicationContext) {
            return;
        }
        this.mApplicationContext.unregisterReceiver((BroadcastReceiver)this);
    }

    private int wifiDhcpGatewayAddress() {
        if (this.mConnectionType != ConnectionType.WIFI) {
            return 0;
        }
        if (null == this.mApplicationContext) {
            return 0;
        }
        try {
            WifiManager wifiManager = (WifiManager)this.mApplicationContext.getSystemService("wifi");
            DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
            if (dhcpInfo == null) {
                return 0;
            }
            return dhcpInfo.gateway;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void updateConnectionType() {
        ConnectionType connectionType = this.mConnectionType;
        this.mConnectionType = this.getConnectionType();
        if (this.mConnectionType == connectionType || !this.mShouldNotify) {
            return;
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createNetworkEvent(this.mConnectionType.value, this.mConnectionType == ConnectionType.WIFI, this.wifiDhcpGatewayAddress()));
    }

    public double[] getCurrentInformation() {
        return new double[]{this.mConnectionType.value, this.mConnectionType == ConnectionType.WIFI ? 1.0 : 0.0, this.wifiDhcpGatewayAddress()};
    }

    public void enableNotifications() {
        this.mConnectionType = ConnectionType.NONE;
        this.updateConnectionType();
        this.mShouldNotify = true;
        if (this.mShouldBeListening) {
            this.startListening();
        }
    }

    public void disableNotifications() {
        this.mShouldNotify = false;
        if (this.mShouldBeListening) {
            this.stopListening();
        }
    }

    private ConnectionType getConnectionType() {
        Context context = this.mApplicationContext;
        if (null == context) {
            return ConnectionType.NONE;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            Log.e((String)LOGTAG, (String)"Connectivity service does not exist");
            return ConnectionType.NONE;
        }
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (networkInfo == null) {
            return ConnectionType.NONE;
        }
        switch (networkInfo.getType()) {
            case 7: {
                return ConnectionType.BLUETOOTH;
            }
            case 9: {
                return ConnectionType.ETHERNET;
            }
            case 0: 
            case 6: {
                return ConnectionType.CELLULAR;
            }
            case 1: {
                return ConnectionType.WIFI;
            }
        }
        Log.w((String)LOGTAG, (String)"Ignoring the current network type.");
        return ConnectionType.OTHER;
    }

    private static int getNetworkOperator(InfoType infoType, Context context) {
        if (null == context) {
            return -1;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            Log.e((String)LOGTAG, (String)"Telephony service does not exist");
            return -1;
        }
        String string2 = telephonyManager.getNetworkOperator();
        if (string2 == null || string2.length() <= 3) {
            return -1;
        }
        if (infoType == InfoType.MNC) {
            return Integer.parseInt(string2.substring(3));
        }
        if (infoType == InfoType.MCC) {
            return Integer.parseInt(string2.substring(0, 3));
        }
        return -1;
    }

    @JNITarget
    public static int getMCC() {
        return GeckoNetworkManager.getNetworkOperator(InfoType.MCC, GeckoAppShell.getContext().getApplicationContext());
    }

    @JNITarget
    public static int getMNC() {
        return GeckoNetworkManager.getNetworkOperator(InfoType.MNC, GeckoAppShell.getContext().getApplicationContext());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InfoType {
        MCC,
        MNC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConnectionType {
        CELLULAR(0),
        BLUETOOTH(1),
        ETHERNET(2),
        WIFI(3),
        OTHER(4),
        NONE(5);

        public final int value;

        private ConnectionType(int n2) {
            this.value = n2;
        }
    }
}

