/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ContentResolver;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoProfileDirectories;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.distribution.Distribution;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.util.INIParser;
import org.mozilla.gecko.util.INISection;

public final class GeckoProfile {
    private static final String LOGTAG = "GeckoProfile";
    private static final String LOCK_FILE_NAME = ".active_lock";
    public static final String DEFAULT_PROFILE = "default";
    private static final String GUEST_PROFILE = "guest";
    private static HashMap<String, GeckoProfile> sProfileCache = new HashMap();
    private static String sDefaultProfileName = null;
    private static File sGuestDir = null;
    private static GeckoProfile sGuestProfile = null;
    public static boolean sIsUsingCustomProfile = false;
    private final String mName;
    private final File mMozillaDir;
    private final boolean mIsWebAppProfile;
    private final Context mApplicationContext;
    private File mProfileDir;
    private volatile LockState mLocked = LockState.UNDEFINED;
    private volatile boolean mInGuestMode = false;

    public static GeckoProfile get(Context context) {
        Object object;
        boolean bl = false;
        try {
            bl = context instanceof GeckoApp;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (bl) {
            object = (GeckoApp)context;
            if (((GeckoApp)object).mProfile != null) {
                return ((GeckoApp)object).mProfile;
            }
        }
        if ((object = GeckoProfile.getGuestProfile(context)) != null && ((GeckoProfile)object).locked()) {
            return object;
        }
        if (bl) {
            String string2;
            GeckoApp geckoApp = (GeckoApp)context;
            try {
                string2 = geckoApp.getDefaultProfileName();
            }
            catch (GeckoProfileDirectories.NoMozillaDirectoryException noMozillaDirectoryException) {
                Log.wtf((String)LOGTAG, (String)"Unable to get default profile name.", (Throwable)noMozillaDirectoryException);
                throw new RuntimeException(noMozillaDirectoryException);
            }
            return GeckoProfile.get(context, string2);
        }
        return GeckoProfile.get(context, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeckoProfile get(Context context, String string2) {
        HashMap<String, GeckoProfile> hashMap = sProfileCache;
        synchronized (hashMap) {
            GeckoProfile geckoProfile = sProfileCache.get(string2);
            if (geckoProfile != null) {
                return geckoProfile;
            }
        }
        return GeckoProfile.get(context, string2, (File)null);
    }

    @RobocopTarget
    public static GeckoProfile get(Context context, String string2, String string3) {
        File file = null;
        if (!(TextUtils.isEmpty((CharSequence)string3) || (file = new File(string3)).exists() && file.isDirectory())) {
            Log.w((String)LOGTAG, (String)("requested profile directory missing: " + string3));
        }
        return GeckoProfile.get(context, string2, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RobocopTarget
    public static GeckoProfile get(Context context, String string2, File file) {
        if (context == null) {
            throw new IllegalArgumentException("context must be non-null");
        }
        if (TextUtils.isEmpty((CharSequence)string2) && file == null) {
            try {
                string2 = GeckoProfile.getDefaultProfileName(context);
            }
            catch (GeckoProfileDirectories.NoMozillaDirectoryException noMozillaDirectoryException) {
                throw new RuntimeException(noMozillaDirectoryException);
            }
        }
        HashMap<String, GeckoProfile> hashMap = sProfileCache;
        synchronized (hashMap) {
            GeckoProfile geckoProfile = sProfileCache.get(string2);
            if (geckoProfile == null) {
                try {
                    geckoProfile = new GeckoProfile(context, string2);
                }
                catch (GeckoProfileDirectories.NoMozillaDirectoryException noMozillaDirectoryException) {
                    throw new RuntimeException(noMozillaDirectoryException);
                }
                geckoProfile.setDir(file);
                sProfileCache.put(string2, geckoProfile);
            } else {
                geckoProfile.setDir(file);
            }
            return geckoProfile;
        }
    }

    public static boolean removeProfile(Context context, String string2) {
        boolean bl;
        if (string2 == null) {
            Log.w((String)LOGTAG, (String)"Unable to remove profile: null profile name.");
            return false;
        }
        try {
            bl = new GeckoProfile(context, string2).remove();
        }
        catch (GeckoProfileDirectories.NoMozillaDirectoryException noMozillaDirectoryException) {
            Log.w((String)LOGTAG, (String)"Unable to remove profile: no Mozilla directory.", (Throwable)noMozillaDirectoryException);
            return true;
        }
        if (bl) {
            GeckoSharedPrefs.forProfileName(context, string2).edit().clear().commit();
        }
        return bl;
    }

    public static GeckoProfile createGuestProfile(Context context) {
        try {
            GeckoProfile.removeGuestProfile(context);
            GeckoProfile.getGuestDir(context).mkdir();
            GeckoProfile geckoProfile = GeckoProfile.getGuestProfile(context);
            geckoProfile.lock();
            geckoProfile.enqueueInitialization();
            return geckoProfile;
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error creating guest profile", (Throwable)exception);
            return null;
        }
    }

    public static void leaveGuestSession(Context context) {
        GeckoProfile geckoProfile = GeckoProfile.getGuestProfile(context);
        if (geckoProfile != null) {
            geckoProfile.unlock();
        }
    }

    private static File getGuestDir(Context context) {
        if (sGuestDir == null) {
            sGuestDir = context.getFileStreamPath(GUEST_PROFILE);
        }
        return sGuestDir;
    }

    private static GeckoProfile getGuestProfile(Context context) {
        File file;
        if (sGuestProfile == null && (file = GeckoProfile.getGuestDir(context)).exists()) {
            sGuestProfile = GeckoProfile.get(context, GUEST_PROFILE, file);
            GeckoProfile.sGuestProfile.mInGuestMode = true;
        }
        return sGuestProfile;
    }

    public static boolean maybeCleanupGuestProfile(Context context) {
        GeckoProfile geckoProfile = GeckoProfile.getGuestProfile(context);
        if (geckoProfile == null) {
            return false;
        }
        if (!geckoProfile.locked()) {
            geckoProfile.mInGuestMode = false;
            GeckoProfile.removeGuestProfile(context);
            return true;
        }
        return false;
    }

    private static void removeGuestProfile(Context context) {
        boolean bl = false;
        try {
            File file = GeckoProfile.getGuestDir(context);
            if (file.exists()) {
                bl = GeckoProfile.delete(file);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error removing guest profile", (Throwable)exception);
        }
        if (bl) {
            GeckoSharedPrefs.forProfileName(context, GUEST_PROFILE).edit().clear().commit();
        }
    }

    public static boolean delete(File file) throws IOException {
        if (file.delete()) {
            return true;
        }
        if (file.isDirectory()) {
            String[] stringArray;
            for (String string2 : stringArray = file.list()) {
                File file2 = new File(file, string2);
                GeckoProfile.delete(file2);
            }
        }
        return file.delete();
    }

    private GeckoProfile(Context context, String string2) throws GeckoProfileDirectories.NoMozillaDirectoryException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Unable to create GeckoProfile for empty profile name.");
        }
        this.mApplicationContext = context.getApplicationContext();
        this.mName = string2;
        this.mIsWebAppProfile = string2.startsWith("webapp");
        this.mMozillaDir = GeckoProfileDirectories.getMozillaDirectory(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean locked() {
        boolean bl;
        boolean bl2;
        if (this.mLocked != LockState.UNDEFINED) {
            return this.mLocked == LockState.LOCKED;
        }
        Object object = this;
        synchronized (object) {
            bl2 = this.mProfileDir != null && this.mProfileDir.exists();
        }
        this.mLocked = bl2 ? ((bl = ((File)(object = new File(this.mProfileDir, LOCK_FILE_NAME))).exists()) ? LockState.LOCKED : LockState.UNLOCKED) : LockState.UNLOCKED;
        return this.mLocked == LockState.LOCKED;
    }

    public boolean lock() {
        try {
            File file = new File(this.getDir(), LOCK_FILE_NAME);
            boolean bl = file.createNewFile();
            this.mLocked = bl ? LockState.LOCKED : LockState.UNLOCKED;
            return bl;
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error locking profile", (Throwable)iOException);
            this.mLocked = LockState.UNLOCKED;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock() {
        File file;
        Object object = this;
        synchronized (object) {
            file = this.mProfileDir;
        }
        if (file == null || !file.exists()) {
            return true;
        }
        try {
            object = new File(file, LOCK_FILE_NAME);
            boolean bl = GeckoProfile.delete((File)object);
            this.mLocked = bl ? LockState.UNLOCKED : LockState.LOCKED;
            return bl;
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error unlocking profile", (Throwable)iOException);
            this.mLocked = LockState.LOCKED;
            return false;
        }
    }

    public boolean inGuestMode() {
        return this.mInGuestMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDir(File file) {
        if (file != null && file.exists() && file.isDirectory()) {
            GeckoProfile geckoProfile = this;
            synchronized (geckoProfile) {
                this.mProfileDir = file;
            }
        }
    }

    public String getName() {
        return this.mName;
    }

    public synchronized File getDir() {
        this.forceCreate();
        return this.mProfileDir;
    }

    public synchronized GeckoProfile forceCreate() {
        if (this.mProfileDir != null) {
            return this;
        }
        try {
            try {
                this.mProfileDir = this.findProfileDir();
                Log.d((String)LOGTAG, (String)"Found profile dir.");
            }
            catch (GeckoProfileDirectories.NoSuchProfileException noSuchProfileException) {
                this.mProfileDir = this.createProfileDir();
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error getting profile dir", (Throwable)iOException);
        }
        return this;
    }

    public File getFile(String string2) {
        File file = this.getDir();
        if (file == null) {
            return null;
        }
        return new File(file, string2);
    }

    public void moveSessionFile() {
        File file = this.getFile("sessionstore.js");
        if (file != null && file.exists()) {
            File file2 = this.getFile("sessionstore.bak");
            file.renameTo(file2);
        }
    }

    public String readSessionFile(boolean bl) {
        File file = this.getFile(bl ? "sessionstore.bak" : "sessionstore.js");
        try {
            if (file != null && file.exists()) {
                return this.readFile(file);
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Unable to read session file", (Throwable)iOException);
        }
        return null;
    }

    public String readFile(String string2) throws IOException {
        File file = this.getDir();
        if (file == null) {
            throw new IOException("No profile directory found");
        }
        File file2 = new File(file, string2);
        return this.readFile(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        try {
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[8192];
            int n = fileReader.read(cArray);
            while (n >= 0) {
                stringBuilder.append(cArray, 0, n);
                n = fileReader.read(cArray);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            fileReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove() {
        try {
            Serializable serializable;
            GeckoProfile geckoProfile = this;
            synchronized (geckoProfile) {
                serializable = this.getDir();
                if (((File)serializable).exists()) {
                    GeckoProfile.delete((File)serializable);
                }
                try {
                    this.mProfileDir = this.findProfileDir();
                }
                catch (GeckoProfileDirectories.NoSuchProfileException noSuchProfileException) {
                    return false;
                }
            }
            geckoProfile = GeckoProfileDirectories.getProfilesINI(this.mMozillaDir);
            serializable = geckoProfile.getSections();
            Enumeration enumeration = ((Hashtable)serializable).elements();
            while (enumeration.hasMoreElements()) {
                INISection iNISection = (INISection)enumeration.nextElement();
                String string2 = iNISection.getStringProperty("Name");
                if (string2 == null || !string2.equals(this.mName)) continue;
                if (iNISection.getName().startsWith("Profile")) {
                    try {
                        int n = Integer.parseInt(iNISection.getName().substring("Profile".length()));
                        String string3 = "Profile" + n;
                        String string4 = "Profile" + (n + 1);
                        ((Hashtable)serializable).remove(string3);
                        while (((Hashtable)serializable).containsKey(string4)) {
                            geckoProfile.renameSection(string4, string3);
                            string3 = string4;
                            string4 = "Profile" + (++n + 1);
                        }
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Log.e((String)LOGTAG, (String)("Malformed section name in profiles.ini: " + iNISection.getName()));
                        return false;
                    }
                }
                geckoProfile.removeSection(this.mName);
                break;
            }
            geckoProfile.write();
            return true;
        }
        catch (IOException iOException) {
            Log.w((String)LOGTAG, (String)"Failed to remove profile.", (Throwable)iOException);
            return false;
        }
    }

    public static String getDefaultProfileName(Context context) throws GeckoProfileDirectories.NoMozillaDirectoryException {
        if (sDefaultProfileName != null) {
            return sDefaultProfileName;
        }
        String string2 = GeckoProfileDirectories.findDefaultProfileName(context);
        if (string2 == null) {
            sDefaultProfileName = DEFAULT_PROFILE;
            return DEFAULT_PROFILE;
        }
        sDefaultProfileName = string2;
        return sDefaultProfileName;
    }

    private File findProfileDir() throws GeckoProfileDirectories.NoSuchProfileException {
        return GeckoProfileDirectories.findProfileDir(this.mMozillaDir, this.mName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createProfileDir() throws IOException {
        Object object;
        INISection iNISection;
        INIParser iNIParser = GeckoProfileDirectories.getProfilesINI(this.mMozillaDir);
        String string2 = GeckoProfileDirectories.saltProfileName(this.mName);
        File file = new File(this.mMozillaDir, string2);
        while (file.exists()) {
            string2 = GeckoProfileDirectories.saltProfileName(this.mName);
            file = new File(this.mMozillaDir, string2);
        }
        if (!file.mkdirs()) {
            throw new IOException("Unable to create profile.");
        }
        Log.d((String)LOGTAG, (String)"Created new profile dir.");
        int n = 0;
        boolean bl = false;
        while ((iNISection = iNIParser.getSection("Profile" + n)) != null) {
            ++n;
            if (iNISection.getProperty("Default") == null) continue;
            bl = true;
        }
        iNISection = new INISection("Profile" + n);
        iNISection.setProperty("Name", (Object)this.mName);
        iNISection.setProperty("IsRelative", (Object)1);
        iNISection.setProperty("Path", (Object)string2);
        if (iNIParser.getSection("General") == null) {
            object = new INISection("General");
            object.setProperty("StartWithLastProfile", (Object)1);
            iNIParser.addSection(object);
        }
        if (!bl && !this.mIsWebAppProfile) {
            iNISection.setProperty("Default", (Object)1);
            Telemetry.startUISession(TelemetryContract.Session.FIRSTRUN);
        }
        iNIParser.addSection(iNISection);
        iNIParser.write();
        if (!this.mIsWebAppProfile) {
            this.enqueueInitialization();
        }
        try {
            object = new FileOutputStream(file.getAbsolutePath() + File.separator + "times.json");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object, Charset.forName("UTF-8"));
            try {
                outputStreamWriter.append("{\"created\": " + System.currentTimeMillis() + "}\n");
            }
            finally {
                outputStreamWriter.close();
            }
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Couldn't write times.json.", (Throwable)exception);
        }
        return file;
    }

    @RobocopTarget
    public void enqueueInitialization() {
        Log.i((String)LOGTAG, (String)"Enqueuing profile init.");
        final Context context = this.mApplicationContext;
        final Distribution distribution = Distribution.getInstance(context);
        distribution.addOnDistributionReadyCallback(new Runnable(){

            public void run() {
                Log.d((String)GeckoProfile.LOGTAG, (String)"Running post-distribution task: bookmarks.");
                ContentResolver contentResolver = context.getContentResolver();
                int n = BrowserDB.addDistributionBookmarks(contentResolver, distribution, 0);
                BrowserDB.addDefaultBookmarks(context, contentResolver, n);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LockState {
        LOCKED,
        UNLOCKED,
        UNDEFINED;

    }
}

