/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.net.Uri;
import java.util.concurrent.ConcurrentHashMap;
import org.mozilla.gecko.AlertNotification;
import org.mozilla.gecko.R;
import org.mozilla.gecko.gfx.BitmapUtils;

public class NotificationHandler {
    private final ConcurrentHashMap<Integer, Notification> mNotifications = new ConcurrentHashMap();
    private final Context mContext;
    private final NotificationManager mNotificationManager;
    private Notification mForegroundNotification;
    private int mForegroundNotificationId;

    public NotificationHandler(Context context) {
        this.mContext = context;
        this.mNotificationManager = (NotificationManager)context.getSystemService("notification");
    }

    public void add(int n, String string, String string2, String string3, PendingIntent pendingIntent) {
        this.remove(n);
        Uri uri = Uri.parse((String)string);
        int n2 = BitmapUtils.getResource(uri, R.drawable.ic_status_logo);
        AlertNotification alertNotification = new AlertNotification(this.mContext, n, n2, string2, string3, System.currentTimeMillis(), uri);
        alertNotification.setLatestEventInfo(this.mContext, string2, string3, pendingIntent);
        this.mNotificationManager.notify(n, (Notification)alertNotification);
        this.mNotifications.put(n, alertNotification);
    }

    public void add(int n, Notification notification) {
        this.mNotificationManager.notify(n, notification);
        this.mNotifications.put(n, notification);
        if (this.mForegroundNotification == null && this.isOngoing(notification)) {
            this.setForegroundNotification(n, notification);
        }
    }

    public void update(int n, long l, long l2, String string) {
        Notification notification = this.mNotifications.get(n);
        if (notification == null) {
            return;
        }
        if (notification instanceof AlertNotification) {
            AlertNotification alertNotification = (AlertNotification)notification;
            alertNotification.updateProgress(string, l, l2);
        }
        if (this.mForegroundNotification == null && this.isOngoing(notification)) {
            this.setForegroundNotification(n, notification);
        }
    }

    public void remove(int n) {
        Notification notification = this.mNotifications.remove(n);
        if (notification != null) {
            this.updateForegroundNotification(n, notification);
        }
        this.mNotificationManager.cancel(n);
    }

    public boolean isDone() {
        return this.mNotifications.isEmpty();
    }

    public boolean isOngoing(int n) {
        Notification notification = this.mNotifications.get(n);
        return this.isOngoing(notification);
    }

    public boolean isOngoing(Notification notification) {
        return notification != null && (this.isProgressStyle(notification) || (notification.flags & 2) > 0);
    }

    private boolean isProgressStyle(Notification notification) {
        if (notification != null && notification instanceof AlertNotification) {
            return ((AlertNotification)notification).isProgressStyle();
        }
        return false;
    }

    protected void setForegroundNotification(int n, Notification notification) {
        this.mForegroundNotificationId = n;
        this.mForegroundNotification = notification;
    }

    private void updateForegroundNotification(int n, Notification notification) {
        if (this.mForegroundNotificationId == n) {
            Notification notification2 = null;
            int n2 = 0;
            for (Integer n3 : this.mNotifications.keySet()) {
                Notification notification3 = this.mNotifications.get(n3);
                if (!this.isOngoing(notification3)) continue;
                notification2 = notification3;
                n2 = n3;
                break;
            }
            this.setForegroundNotification(n2, notification2);
        }
    }
}

