/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons.decoders;

import android.graphics.Bitmap;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.mozilla.gecko.favicons.decoders.FaviconDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFaviconResult {
    private static final String LOGTAG = "LoadFaviconResult";
    byte[] faviconBytes;
    int offset;
    int length;
    boolean isICO;
    Iterator<Bitmap> bitmapsDecoded;

    public Iterator<Bitmap> getBitmaps() {
        return this.bitmapsDecoded;
    }

    public byte[] getBytesForDatabaseStorage() {
        Object object;
        if (this.offset != 0 || this.length != this.faviconBytes.length) {
            object = new byte[this.length];
            System.arraycopy(this.faviconBytes, this.offset, object, 0, this.length);
            this.offset = 0;
            this.faviconBytes = object;
        }
        if (this.isICO) {
            return this.faviconBytes;
        }
        object = ((FaviconDecoder.SingleBitmapIterator)this.bitmapsDecoded).peek();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (object.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream)) {
                return byteArrayOutputStream.toByteArray();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.w((String)LOGTAG, (String)"Out of memory re-compressing favicon.");
        }
        Log.w((String)LOGTAG, (String)"Favicon re-compression failed.");
        return null;
    }
}

