/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.view.View;
import android.widget.TextView;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountAgeLockoutHelper;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.activities.FxAccountCreateAccountNotAllowedActivity;
import org.mozilla.gecko.fxa.activities.FxAccountGetStartedActivity;
import org.mozilla.gecko.fxa.activities.FxAccountStatusActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.sync.setup.activities.ActivityUtils;
import org.mozilla.gecko.sync.setup.activities.LocaleAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FxAccountAbstractActivity
extends LocaleAware.LocaleAwareActivity {
    private static final String LOG_TAG = FxAccountAbstractActivity.class.getSimpleName();
    protected final boolean cannotResumeWhenAccountsExist;
    protected final boolean cannotResumeWhenNoAccountsExist;
    protected final boolean cannotResumeWhenLockedOut;
    public static final int CAN_ALWAYS_RESUME = 0;
    public static final int CANNOT_RESUME_WHEN_ACCOUNTS_EXIST = 1;
    public static final int CANNOT_RESUME_WHEN_NO_ACCOUNTS_EXIST = 2;
    public static final int CANNOT_RESUME_WHEN_LOCKED_OUT = 4;

    public FxAccountAbstractActivity(int n) {
        this.cannotResumeWhenAccountsExist = 0 != (n & 1);
        this.cannotResumeWhenNoAccountsExist = 0 != (n & 2);
        this.cannotResumeWhenLockedOut = 0 != (n & 4);
    }

    protected void redirectIfAppropriate() {
        if (this.cannotResumeWhenAccountsExist || this.cannotResumeWhenNoAccountsExist) {
            Account account = FirefoxAccounts.getFirefoxAccount((Context)this);
            if (this.cannotResumeWhenAccountsExist && account != null) {
                this.redirectToActivity(FxAccountStatusActivity.class);
                return;
            }
            if (this.cannotResumeWhenNoAccountsExist && account == null) {
                this.redirectToActivity(FxAccountGetStartedActivity.class);
                return;
            }
        }
        if (this.cannotResumeWhenLockedOut && FxAccountAgeLockoutHelper.isLockedOut(SystemClock.elapsedRealtime())) {
            this.setResult(0);
            this.redirectToActivity(FxAccountCreateAccountNotAllowedActivity.class);
            return;
        }
    }

    public void onResume() {
        super.onResume();
        this.redirectIfAppropriate();
    }

    protected void launchActivity(Class<? extends Activity> clazz) {
        Intent intent = new Intent((Context)this, clazz);
        intent.setFlags(65536);
        this.startActivity(intent);
    }

    protected void redirectToActivity(Class<? extends Activity> clazz) {
        this.launchActivity(clazz);
        this.finish();
    }

    public View ensureFindViewById(View view, int n, String string2) {
        View view2 = view != null ? view.findViewById(n) : this.findViewById(n);
        if (view2 == null) {
            String string3 = "Could not find view " + string2 + ".";
            Logger.error(LOG_TAG, string3);
            throw new RuntimeException(string3);
        }
        return view2;
    }

    public void linkifyTextViews(View view, int[] nArray) {
        for (int n : nArray) {
            TextView textView = view != null ? (TextView)view.findViewById(n) : (TextView)this.findViewById(n);
            if (textView == null) {
                Logger.warn(LOG_TAG, "Could not process links for view with id " + n + ".");
                continue;
            }
            ActivityUtils.linkifyTextView(textView, false);
        }
    }

    protected void launchActivityOnClick(View view, final Class<? extends Activity> clazz) {
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FxAccountAbstractActivity.this.launchActivity(clazz);
            }
        });
    }

    protected AndroidFxAccount getAndroidFxAccount() {
        Account account = FirefoxAccounts.getFirefoxAccount((Context)this);
        if (account == null) {
            return null;
        }
        return new AndroidFxAccount((Context)this, account);
    }
}

