/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.db.HomeProvider;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.PanelInfoManager;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomePanelsManager
implements GeckoEventListener {
    public static final String LOGTAG = "HomePanelsManager";
    private static final HomePanelsManager sInstance = new HomePanelsManager();
    private static final int INVALIDATION_DELAY_MSEC = 500;
    private static final int PANEL_INFO_TIMEOUT_MSEC = 1000;
    private static final String EVENT_HOMEPANELS_INSTALL = "HomePanels:Install";
    private static final String EVENT_HOMEPANELS_UNINSTALL = "HomePanels:Uninstall";
    private static final String EVENT_HOMEPANELS_UPDATE = "HomePanels:Update";
    private static final String EVENT_HOMEPANELS_REFRESH = "HomePanels:RefreshDataset";
    private static final String JSON_KEY_PANEL = "panel";
    private static final String JSON_KEY_PANEL_ID = "id";
    private Context mContext;
    private HomeConfig mHomeConfig;
    private final Queue<ConfigChange> mPendingChanges = new ConcurrentLinkedQueue<ConfigChange>();
    private final Runnable mInvalidationRunnable = new InvalidationRunnable();

    public static HomePanelsManager getInstance() {
        return sInstance;
    }

    public void init(Context context) {
        this.mContext = context;
        this.mHomeConfig = HomeConfig.getDefault(context);
        EventDispatcher.getInstance().registerGeckoThreadListener(this, EVENT_HOMEPANELS_INSTALL, EVENT_HOMEPANELS_UNINSTALL, EVENT_HOMEPANELS_UPDATE, EVENT_HOMEPANELS_REFRESH);
    }

    public void onLocaleReady(final String string2) {
        ThreadUtils.getBackgroundHandler().post(new Runnable(){

            public void run() {
                String string22 = HomePanelsManager.this.mHomeConfig.getLocale();
                if (string22 == null || !string22.equals(string2)) {
                    HomePanelsManager.this.handleLocaleChange();
                }
            }
        });
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals(EVENT_HOMEPANELS_INSTALL)) {
                Log.d((String)LOGTAG, (String)EVENT_HOMEPANELS_INSTALL);
                this.handlePanelInstall(this.createPanelConfigFromMessage(jSONObject), InvalidationMode.DELAYED);
            } else if (string2.equals(EVENT_HOMEPANELS_UNINSTALL)) {
                Log.d((String)LOGTAG, (String)EVENT_HOMEPANELS_UNINSTALL);
                String string3 = jSONObject.getString(JSON_KEY_PANEL_ID);
                this.handlePanelUninstall(string3);
            } else if (string2.equals(EVENT_HOMEPANELS_UPDATE)) {
                Log.d((String)LOGTAG, (String)EVENT_HOMEPANELS_UPDATE);
                this.handlePanelUpdate(this.createPanelConfigFromMessage(jSONObject));
            } else if (string2.equals(EVENT_HOMEPANELS_REFRESH)) {
                Log.d((String)LOGTAG, (String)EVENT_HOMEPANELS_REFRESH);
                this.handleDatasetRefresh(jSONObject);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Failed to handle event " + string2), (Throwable)exception);
        }
    }

    private HomeConfig.PanelConfig createPanelConfigFromMessage(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject(JSON_KEY_PANEL);
        return new HomeConfig.PanelConfig(jSONObject2);
    }

    public void installPanel(HomeConfig.PanelConfig panelConfig) {
        Log.d((String)LOGTAG, (String)("installPanel: " + panelConfig.getTitle()));
        this.handlePanelInstall(panelConfig, InvalidationMode.IMMEDIATE);
    }

    private void handlePanelInstall(HomeConfig.PanelConfig panelConfig, InvalidationMode invalidationMode) {
        this.mPendingChanges.offer(new ConfigChange(ChangeType.INSTALL, panelConfig));
        Log.d((String)LOGTAG, (String)("handlePanelInstall: " + this.mPendingChanges.size()));
        this.scheduleInvalidation(invalidationMode);
    }

    private void handlePanelUninstall(String string2) {
        this.mPendingChanges.offer(new ConfigChange(ChangeType.UNINSTALL, string2));
        Log.d((String)LOGTAG, (String)("handlePanelUninstall: " + this.mPendingChanges.size()));
        this.scheduleInvalidation(InvalidationMode.DELAYED);
    }

    private void handlePanelUpdate(HomeConfig.PanelConfig panelConfig) {
        this.mPendingChanges.offer(new ConfigChange(ChangeType.UPDATE, panelConfig));
        Log.d((String)LOGTAG, (String)("handlePanelUpdate: " + this.mPendingChanges.size()));
        this.scheduleInvalidation(InvalidationMode.DELAYED);
    }

    private void handleLocaleChange() {
        this.mPendingChanges.offer(new ConfigChange(ChangeType.REFRESH));
        Log.d((String)LOGTAG, (String)("handleLocaleChange: " + this.mPendingChanges.size()));
        this.scheduleInvalidation(InvalidationMode.IMMEDIATE);
    }

    private void handleDatasetRefresh(JSONObject jSONObject) {
        String string2;
        try {
            string2 = jSONObject.getString("datasetId");
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Failed to handle dataset refresh", (Throwable)jSONException);
            return;
        }
        Log.d((String)LOGTAG, (String)("Refresh request for dataset: " + string2));
        ContentResolver contentResolver = this.mContext.getContentResolver();
        contentResolver.notifyChange(HomeProvider.getDatasetNotificationUri(string2), null);
    }

    private void scheduleInvalidation(InvalidationMode invalidationMode) {
        Handler handler = ThreadUtils.getBackgroundHandler();
        handler.removeCallbacks(this.mInvalidationRunnable);
        if (invalidationMode == InvalidationMode.IMMEDIATE) {
            handler.post(this.mInvalidationRunnable);
        } else {
            handler.postDelayed(this.mInvalidationRunnable, 500L);
        }
        Log.d((String)LOGTAG, (String)("scheduleInvalidation: scheduled new invalidation: " + (Object)((Object)invalidationMode)));
    }

    private void executePendingChanges(HomeConfig.Editor editor) {
        boolean bl = false;
        while (!this.mPendingChanges.isEmpty()) {
            ConfigChange configChange = this.mPendingChanges.poll();
            switch (configChange.type) {
                case UNINSTALL: {
                    Object object = (String)configChange.target;
                    if (!editor.uninstall((String)object)) break;
                    Log.d((String)LOGTAG, (String)("executePendingChanges: uninstalled panel " + (String)object));
                    break;
                }
                case INSTALL: {
                    Object object = (HomeConfig.PanelConfig)configChange.target;
                    if (!editor.install((HomeConfig.PanelConfig)object)) break;
                    Log.d((String)LOGTAG, (String)("executePendingChanges: added panel " + ((HomeConfig.PanelConfig)object).getId()));
                    break;
                }
                case UPDATE: {
                    Object object = (HomeConfig.PanelConfig)configChange.target;
                    if (!editor.update((HomeConfig.PanelConfig)object)) break;
                    Log.w((String)LOGTAG, (String)("executePendingChanges: updated panel " + ((HomeConfig.PanelConfig)object).getId()));
                    break;
                }
                case REFRESH: {
                    bl = true;
                }
            }
        }
        if (bl && !editor.isDefault()) {
            this.executeRefresh(editor);
        }
    }

    private void refreshFromPanelInfos(HomeConfig.Editor editor, List<PanelInfoManager.PanelInfo> list) {
        Log.d((String)LOGTAG, (String)"refreshFromPanelInfos");
        for (HomeConfig.PanelConfig panelConfig : editor) {
            HomeConfig.PanelConfig panelConfig2 = null;
            if (panelConfig.isDynamic()) {
                for (PanelInfoManager.PanelInfo panelInfo : list) {
                    if (!panelInfo.getId().equals(panelConfig.getId())) continue;
                    panelConfig2 = panelInfo.toPanelConfig();
                    Log.d((String)LOGTAG, (String)("refreshFromPanelInfos: refreshing from panel info: " + panelInfo.getId()));
                    break;
                }
            } else {
                panelConfig2 = HomeConfig.createBuiltinPanelConfig(this.mContext, panelConfig.getType());
                Log.d((String)LOGTAG, (String)("refreshFromPanelInfos: refreshing built-in panel: " + panelConfig.getId()));
            }
            if (panelConfig2 == null) {
                Log.d((String)LOGTAG, (String)("refreshFromPanelInfos: no refreshed panel, falling back: " + panelConfig.getId()));
                continue;
            }
            Log.d((String)LOGTAG, (String)("refreshFromPanelInfos: refreshed panel " + panelConfig2.getId()));
            editor.update(panelConfig2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRefresh(HomeConfig.Editor editor) {
        Object object2;
        if (editor.isEmpty()) {
            return;
        }
        Log.d((String)LOGTAG, (String)"executeRefresh");
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object2 : editor) {
            hashSet.add(((HomeConfig.PanelConfig)object2).getId());
        }
        final Object object3 = new Object();
        object2 = new ArrayList();
        PanelInfoManager panelInfoManager = new PanelInfoManager();
        panelInfoManager.requestPanelsById(hashSet, new PanelInfoManager.RequestCallback((List)object2){
            final /* synthetic */ List val$latestPanelInfos;
            {
                this.val$latestPanelInfos = list;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onComplete(List<PanelInfoManager.PanelInfo> list) {
                Object object = object3;
                synchronized (object) {
                    this.val$latestPanelInfos.addAll(list);
                    Log.d((String)HomePanelsManager.LOGTAG, (String)("executeRefresh: fetched panel infos: " + list.size()));
                    object3.notifyAll();
                }
            }
        });
        try {
            Object object4 = object3;
            synchronized (object4) {
                object3.wait(1000L);
                Log.d((String)LOGTAG, (String)"executeRefresh: done fetching panel infos");
                this.refreshFromPanelInfos(editor, (List<PanelInfoManager.PanelInfo>)object2);
            }
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)LOGTAG, (String)"Failed to fetch panels from gecko", (Throwable)interruptedException);
        }
    }

    private class InvalidationRunnable
    implements Runnable {
        private InvalidationRunnable() {
        }

        public void run() {
            HomeConfig.Editor editor = HomePanelsManager.this.mHomeConfig.load().edit();
            HomePanelsManager.this.executePendingChanges(editor);
            editor.commit();
        }
    }

    private static class ConfigChange {
        private final ChangeType type;
        private final Object target;

        public ConfigChange(ChangeType changeType) {
            this(changeType, null);
        }

        public ConfigChange(ChangeType changeType, Object object) {
            this.type = changeType;
            this.target = object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InvalidationMode {
        DELAYED,
        IMMEDIATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ChangeType {
        UNINSTALL,
        INSTALL,
        UPDATE,
        REFRESH;

    }
}

