/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.PanelLayout;
import org.mozilla.gecko.home.PanelViewAdapter;
import org.mozilla.gecko.home.PanelViewItemHandler;

public class PanelGridView
extends GridView
implements PanelLayout.DatasetBacked,
PanelLayout.PanelView {
    private static final String LOGTAG = "GeckoPanelGridView";
    private final HomeConfig.ViewConfig viewConfig;
    private final PanelViewAdapter adapter;
    private PanelViewItemHandler itemHandler;
    private PanelLayout.OnItemOpenListener itemOpenListener;
    private HomeContextMenuInfo mContextMenuInfo;
    private HomeContextMenuInfo.Factory mContextMenuInfoFactory;

    public PanelGridView(Context context, HomeConfig.ViewConfig viewConfig) {
        super(context, null, R.attr.panelGridViewStyle);
        this.viewConfig = viewConfig;
        this.itemHandler = new PanelViewItemHandler(viewConfig);
        this.adapter = new PanelViewAdapter(context, viewConfig);
        this.setAdapter((ListAdapter)this.adapter);
        this.setOnItemClickListener(new PanelGridItemClickListener());
        this.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> adapterView, View view, int n, long l) {
                Cursor cursor = (Cursor)adapterView.getItemAtPosition(n);
                if (cursor == null || PanelGridView.this.mContextMenuInfoFactory == null) {
                    PanelGridView.this.mContextMenuInfo = null;
                    return false;
                }
                PanelGridView.this.mContextMenuInfo = PanelGridView.this.mContextMenuInfoFactory.makeInfoForCursor(view, n, l, cursor);
                return PanelGridView.this.showContextMenuForChild((View)PanelGridView.this);
            }
        });
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.itemHandler.setOnItemOpenListener(this.itemOpenListener);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.itemHandler.setOnItemOpenListener(null);
    }

    public void setDataset(Cursor cursor) {
        Log.d((String)LOGTAG, (String)("Setting dataset: " + this.viewConfig.getDatasetId()));
        this.adapter.swapCursor(cursor);
    }

    public void setOnItemOpenListener(PanelLayout.OnItemOpenListener onItemOpenListener) {
        this.itemHandler.setOnItemOpenListener(onItemOpenListener);
        this.itemOpenListener = onItemOpenListener;
    }

    public void setFilterManager(PanelLayout.FilterManager filterManager) {
        this.adapter.setFilterManager(filterManager);
        this.itemHandler.setFilterManager(filterManager);
    }

    public HomeContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    public void setContextMenuInfoFactory(HomeContextMenuInfo.Factory factory) {
        this.mContextMenuInfoFactory = factory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PanelGridItemClickListener
    implements AdapterView.OnItemClickListener {
        private PanelGridItemClickListener() {
        }

        public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
            PanelGridView.this.itemHandler.openItemAtPosition(PanelGridView.this.adapter.getCursor(), n);
        }
    }
}

