/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.graphics.Bitmap;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.gfx.BitmapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchEngine {
    public static final String LOG_TAG = "GeckoSearchEngine";
    public final String name;
    public final String identifier;
    private final Bitmap icon;
    private volatile List<String> suggestions = new ArrayList<String>();

    public SearchEngine(JSONObject jSONObject) throws JSONException {
        if (jSONObject == null) {
            throw new IllegalArgumentException("Can't instantiate SearchEngine from null JSON.");
        }
        this.name = SearchEngine.getString(jSONObject, "name");
        if (this.name == null) {
            throw new IllegalArgumentException("Cannot have an unnamed search engine.");
        }
        this.identifier = SearchEngine.getString(jSONObject, "identifier");
        String string = SearchEngine.getString(jSONObject, "iconURI");
        if (string == null) {
            Log.w((String)LOG_TAG, (String)("iconURI is null for search engine " + this.name));
            this.icon = null;
            return;
        }
        this.icon = BitmapUtils.getBitmapFromDataURI(string);
    }

    private static String getString(JSONObject jSONObject, String string) throws JSONException {
        if (jSONObject.isNull(string)) {
            return null;
        }
        return jSONObject.getString(string);
    }

    public String getEngineIdentifier() {
        if (this.identifier != null) {
            return this.identifier;
        }
        if (this.name != null) {
            return "other-" + this.name;
        }
        return "other";
    }

    public boolean hasSuggestions() {
        return !this.suggestions.isEmpty();
    }

    public int getSuggestionsCount() {
        return this.suggestions.size();
    }

    public Iterable<String> getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(List<String> list) {
        if (list == null) {
            this.suggestions = new ArrayList<String>();
            return;
        }
        this.suggestions = list;
    }

    public Bitmap getIcon() {
        return this.icon;
    }
}

