/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.client.methods.HttpUriRequest;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import ch.boye.httpclientandroidlib.message.BasicHeader;
import ch.boye.httpclientandroidlib.protocol.BasicHttpContext;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;

public class HMACAuthHeaderProvider
implements AuthHeaderProvider {
    public static final String LOG_TAG = "HMACAuthHeaderProvider";
    public static final int NONCE_LENGTH_IN_BYTES = 8;
    public static final String HMAC_SHA1_ALGORITHM = "hmacSHA1";
    public final String identifier;
    public final String key;

    public HMACAuthHeaderProvider(String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("identifier must not be null.");
        }
        if (!HMACAuthHeaderProvider.isPlainString(string2)) {
            throw new IllegalArgumentException("identifier must be a plain-string.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("key must not be null.");
        }
        this.identifier = string2;
        this.key = string3;
    }

    public Header getAuthHeader(HttpRequestBase httpRequestBase, BasicHttpContext basicHttpContext, DefaultHttpClient defaultHttpClient) throws GeneralSecurityException {
        long l = System.currentTimeMillis() / 1000L;
        String string2 = Base64.encodeBase64String((byte[])Utils.generateRandomBytes(8));
        String string3 = "";
        try {
            return this.getAuthHeader(httpRequestBase, basicHttpContext, defaultHttpClient, l, string2, string3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new GeneralSecurityException(invalidKeyException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GeneralSecurityException(unsupportedEncodingException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new GeneralSecurityException(noSuchAlgorithmException);
        }
    }

    protected static boolean isPlainString(String string2) {
        byte[] byArray;
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        try {
            byArray = string2.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.warn(LOG_TAG, "Got exception in isPlainString; returning false.", unsupportedEncodingException);
            return false;
        }
        for (byte by : byArray) {
            if (32 <= by && by <= 33 || 35 <= by && by <= 91 || 93 <= by && by <= 126) continue;
            return false;
        }
        return true;
    }

    protected Header getAuthHeader(HttpRequestBase httpRequestBase, BasicHttpContext basicHttpContext, DefaultHttpClient defaultHttpClient, long l, String string2, String string3) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException {
        if (l < 0L) {
            throw new IllegalArgumentException("timestamp must contain only [0-9].");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("nonce must not be null.");
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("nonce must not be empty.");
        }
        if (!HMACAuthHeaderProvider.isPlainString(string2)) {
            throw new IllegalArgumentException("nonce must be a plain-string.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("extra must not be null.");
        }
        if (string3.length() > 0 && !HMACAuthHeaderProvider.isPlainString(string3)) {
            throw new IllegalArgumentException("extra must be a plain-string.");
        }
        String string4 = HMACAuthHeaderProvider.getRequestString((HttpUriRequest)httpRequestBase, l, string2, string3);
        String string5 = HMACAuthHeaderProvider.getSignature(string4, this.key);
        String string6 = "MAC id=\"" + this.identifier + "\", " + "ts=\"" + l + "\", " + "nonce=\"" + string2 + "\", " + "mac=\"" + string5 + "\"";
        if (string3 != null) {
            string6 = string6 + ", ext=\"" + string3 + "\"";
        }
        BasicHeader basicHeader = new BasicHeader("Authorization", string6);
        return basicHeader;
    }

    protected static byte[] sha1(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, HMAC_SHA1_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        mac.init(secretKeySpec);
        mac.update(byArray);
        byte[] byArray3 = mac.doFinal();
        return byArray3;
    }

    protected static String getSignature(String string2, String string3) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        String string4 = Base64.encodeBase64String((byte[])HMACAuthHeaderProvider.sha1(string2.getBytes("UTF-8"), string3.getBytes("UTF-8")));
        return string4;
    }

    protected static String getRequestString(HttpUriRequest httpUriRequest, long l, String string2, String string3) {
        String string4 = httpUriRequest.getMethod().toUpperCase();
        URI uRI = httpUriRequest.getURI();
        String string5 = uRI.getHost();
        String string6 = uRI.getRawPath();
        if (uRI.getRawQuery() != null) {
            string6 = string6 + "?";
            string6 = string6 + uRI.getRawQuery();
        }
        if (uRI.getRawFragment() != null) {
            string6 = string6 + "#";
            string6 = string6 + uRI.getRawFragment();
        }
        int n = uRI.getPort();
        String string7 = uRI.getScheme();
        if (n == -1) {
            if ("http".equalsIgnoreCase(string7)) {
                n = 80;
            } else if ("https".equalsIgnoreCase(string7)) {
                n = 443;
            } else {
                throw new IllegalArgumentException("Unsupported URI scheme: " + string7 + ".");
            }
        }
        String string8 = l + "\n" + string2 + "\n" + string4 + "\n" + string6 + "\n" + string5 + "\n" + n + "\n" + string3 + "\n";
        return string8;
    }
}

