/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.stage;

import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.NodeAuthenticationException;
import org.mozilla.gecko.sync.NullClusterURLException;
import org.mozilla.gecko.sync.ThreadPool;
import org.mozilla.gecko.sync.delegates.NodeAssignmentCallback;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.stage.AbstractNonRepositorySyncStage;
import org.mozilla.gecko.sync.stage.NoSuchStageException;

public class EnsureClusterURLStage
extends AbstractNonRepositorySyncStage {
    private static final String LOG_TAG = EnsureClusterURLStage.class.getSimpleName();
    protected final NodeAssignmentCallback callback;

    public EnsureClusterURLStage(NodeAssignmentCallback nodeAssignmentCallback) {
        this.callback = nodeAssignmentCallback;
    }

    public static void fetchClusterURL(String string2, final ClusterURLFetchDelegate clusterURLFetchDelegate) throws URISyntaxException {
        Logger.info(LOG_TAG, "In fetchClusterURL: node/weave is " + string2);
        BaseResource baseResource = new BaseResource(string2);
        baseResource.delegate = new BaseResourceDelegate(baseResource){

            public String getUserAgent() {
                return "Firefox AndroidSync 1.33.0a1.0 (Nightly)";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void handleHttpResponse(HttpResponse var1_1) {
                block19: {
                    try {
                        var2_2 = var1_1.getStatusLine().getStatusCode();
                        switch (var2_2) {
                            case 200: {
                                Logger.info(EnsureClusterURLStage.access$000(), "Got 200 for node/weave cluster URL request (user found; succeeding).");
                                var3_3 = var1_1.getEntity();
                                if (var3_3 == null) {
                                    clusterURLFetchDelegate.handleThrottled();
                                    BaseResource.consumeEntity(var1_1);
                                    return;
                                }
                                var4_4 = null;
                                try {
                                    var5_5 = var3_3.getContent();
                                    var6_9 = new BufferedReader(new InputStreamReader((InputStream)var5_5, "UTF-8"), 1024);
                                    var4_4 = var6_9.readLine();
                                    BaseResource.consumeReader(var6_9);
                                    var6_9.close();
                                }
                                catch (IllegalStateException var5_6) {
                                    clusterURLFetchDelegate.handleError(var5_6);
                                    BaseResource.consumeEntity(var1_1);
                                    BaseResource.consumeEntity(var1_1);
                                    return;
                                }
                                catch (IOException var5_7) {
                                    clusterURLFetchDelegate.handleError(var5_7);
                                    BaseResource.consumeEntity(var1_1);
                                    BaseResource.consumeEntity(var1_1);
                                    return;
                                }
                                if (var4_4 == null || var4_4.equals("null")) {
                                    clusterURLFetchDelegate.handleThrottled();
                                    return;
                                }
                                try {
                                    var5_5 = new URI(var4_4);
                                    clusterURLFetchDelegate.handleSuccess((URI)var5_5);
                                    ** break;
lbl37:
                                    // 1 sources

                                }
                                catch (URISyntaxException var5_8) {
                                    clusterURLFetchDelegate.handleError(var5_8);
                                    ** break;
                                }
lbl41:
                                // 1 sources

                                break block19;
                            }
                            case 400: 
                            case 404: {
                                Logger.info(EnsureClusterURLStage.access$000(), "Got " + var2_2 + " for node/weave cluster URL request (user not found; failing).");
                                clusterURLFetchDelegate.handleFailure(var1_1);
                                ** break;
lbl46:
                                // 1 sources

                                break block19;
                            }
                            case 503: {
                                Logger.info(EnsureClusterURLStage.access$000(), "Got 503 for node/weave cluster URL request (error fetching node; failing).");
                                clusterURLFetchDelegate.handleFailure(var1_1);
                                ** break;
lbl51:
                                // 1 sources

                                break block19;
                            }
                            default: {
                                Logger.warn(EnsureClusterURLStage.access$000(), "Got " + var2_2 + " for node/weave cluster URL request (unexpected HTTP status; failing).");
                                clusterURLFetchDelegate.handleFailure(var1_1);
                                break block19;
                            }
                        }
                        {
                            catch (Throwable var7_10) {
                                throw var7_10;
                            }
                        }
                    }
                    finally {
                        BaseResource.consumeEntity(var1_1);
                    }
                }
                BaseResource.consumeEntity(var1_1);
            }

            public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
                clusterURLFetchDelegate.handleError((Exception)((Object)clientProtocolException));
            }

            public void handleHttpIOException(IOException iOException) {
                clusterURLFetchDelegate.handleError(iOException);
            }

            public void handleTransportException(GeneralSecurityException generalSecurityException) {
                clusterURLFetchDelegate.handleError(generalSecurityException);
            }
        };
        baseResource.get();
    }

    public void execute() throws NoSuchStageException {
        final URI uRI = this.session.config.getClusterURL();
        boolean bl = this.callback.wantNodeAssignment();
        if (!bl && uRI != null) {
            Logger.info(LOG_TAG, "Cluster URL is already set and not stale. Continuing with sync.");
            this.session.advance();
            return;
        }
        Logger.info(LOG_TAG, "Fetching cluster URL.");
        final ClusterURLFetchDelegate clusterURLFetchDelegate = new ClusterURLFetchDelegate(){

            public void handleSuccess(URI uRI2) {
                Logger.info(LOG_TAG, "Node assignment pointed us to " + uRI2);
                if (uRI != null && uRI.equals(uRI2)) {
                    EnsureClusterURLStage.this.callback.informNodeAuthenticationFailed(EnsureClusterURLStage.this.session, uRI2);
                    EnsureClusterURLStage.this.session.abort(new NodeAuthenticationException(), "User password has changed.");
                    return;
                }
                EnsureClusterURLStage.this.callback.informNodeAssigned(EnsureClusterURLStage.this.session, uRI, uRI2);
                EnsureClusterURLStage.this.session.config.setClusterURL(uRI2);
                EnsureClusterURLStage.this.session.advance();
            }

            public void handleThrottled() {
                EnsureClusterURLStage.this.session.abort(new NullClusterURLException(), "Got 'null' cluster URL. Aborting.");
            }

            public void handleFailure(HttpResponse httpResponse) {
                int n = httpResponse.getStatusLine().getStatusCode();
                Logger.warn(LOG_TAG, "Got HTTP failure fetching node assignment: " + n);
                if (n == 404) {
                    URI uRI2 = null;
                    try {
                        uRI2 = new URI(EnsureClusterURLStage.this.callback.nodeWeaveURL());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                    if (uRI2 != null) {
                        Logger.info(LOG_TAG, "Using serverURL <" + uRI2.toASCIIString() + "> as clusterURL.");
                        EnsureClusterURLStage.this.session.config.setClusterURL(uRI2);
                        EnsureClusterURLStage.this.session.advance();
                        return;
                    }
                    Logger.warn(LOG_TAG, "No serverURL set to use as fallback cluster URL. Aborting sync.");
                } else {
                    EnsureClusterURLStage.this.session.interpretHTTPFailure(httpResponse);
                }
                EnsureClusterURLStage.this.session.abort(new Exception("HTTP failure."), "Got failure fetching cluster URL.");
            }

            public void handleError(Exception exception) {
                EnsureClusterURLStage.this.session.abort(exception, "Got exception fetching cluster URL.");
            }
        };
        ThreadPool.run(new Runnable(){

            public void run() {
                try {
                    EnsureClusterURLStage.fetchClusterURL(EnsureClusterURLStage.this.callback.nodeWeaveURL(), clusterURLFetchDelegate);
                }
                catch (URISyntaxException uRISyntaxException) {
                    EnsureClusterURLStage.this.session.abort(uRISyntaxException, "Invalid URL for node/weave.");
                }
            }
        });
    }

    public static interface ClusterURLFetchDelegate {
        public void handleSuccess(URI var1);

        public void handleThrottled();

        public void handleFailure(HttpResponse var1);

        public void handleError(Exception var1);
    }
}

