/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabspanel;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.LightweightTheme;
import org.mozilla.gecko.LightweightThemeDrawable;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.widget.GeckoPopupMenu;
import org.mozilla.gecko.widget.IconTabWidget;

public class TabsPanel
extends LinearLayout
implements GeckoPopupMenu.OnMenuItemClickListener,
LightweightTheme.OnChangeListener,
IconTabWidget.OnTabChangedListener {
    private static final String LOGTAG = "Gecko" + TabsPanel.class.getSimpleName();
    private Context mContext;
    private final GeckoApp mActivity;
    private final LightweightTheme mTheme;
    private RelativeLayout mHeader;
    private TabsListContainer mTabsContainer;
    private PanelView mPanel;
    private PanelView mPanelNormal;
    private PanelView mPanelPrivate;
    private PanelView mPanelRemote;
    private RelativeLayout mFooter;
    private TabsLayoutChangeListener mLayoutChangeListener;
    private GeckoAppShell.AppStateListener mAppStateListener;
    private IconTabWidget mTabWidget;
    private static ImageButton mMenuButton;
    private static ImageButton mAddTab;
    private Panel mCurrentPanel;
    private boolean mIsSideBar;
    private boolean mVisible;
    private boolean mHeaderVisible;
    private GeckoPopupMenu mPopupMenu;

    public TabsPanel(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.mActivity = (GeckoApp)context;
        this.mTheme = ((GeckoApplication)context.getApplicationContext()).getLightweightTheme();
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.setOrientation(1);
        this.mCurrentPanel = Panel.NORMAL_TABS;
        this.mVisible = false;
        this.mHeaderVisible = false;
        this.mIsSideBar = false;
        this.mPopupMenu = new GeckoPopupMenu(context);
        this.mPopupMenu.inflate(R.menu.tabs_menu);
        this.mPopupMenu.setOnMenuItemClickListener(this);
        LayoutInflater.from((Context)context).inflate(R.layout.tabs_panel, (ViewGroup)this);
        this.initialize();
        this.mAppStateListener = new GeckoAppShell.AppStateListener(){

            public void onResume() {
                if (TabsPanel.this.mPanel == TabsPanel.this.mPanelRemote) {
                    TabsPanel.this.mPanelRemote.show();
                }
            }

            public void onOrientationChanged() {
            }

            public void onPause() {
            }
        };
    }

    private void initialize() {
        this.mHeader = (RelativeLayout)this.findViewById(R.id.tabs_panel_header);
        this.mTabsContainer = (TabsListContainer)this.findViewById(R.id.tabs_container);
        this.mPanelNormal = (PanelView)this.findViewById(R.id.normal_tabs);
        this.mPanelNormal.setTabsPanel(this);
        this.mPanelPrivate = (PanelView)this.findViewById(R.id.private_tabs_panel);
        this.mPanelPrivate.setTabsPanel(this);
        this.mPanelRemote = (PanelView)this.findViewById(R.id.remote_tabs);
        this.mPanelRemote.setTabsPanel(this);
        this.mFooter = (RelativeLayout)this.findViewById(R.id.tabs_panel_footer);
        mAddTab = (ImageButton)this.findViewById(R.id.add_tab);
        mAddTab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TabsPanel.this.addTab();
            }
        });
        this.mTabWidget = (IconTabWidget)this.findViewById(R.id.tab_widget);
        this.mTabWidget.addTab(R.drawable.tabs_normal, R.string.tabs_normal);
        this.mTabWidget.addTab(R.drawable.tabs_private, R.string.tabs_private);
        if (!GeckoProfile.get(this.mContext).inGuestMode()) {
            this.mTabWidget.addTab(R.drawable.tabs_synced, R.string.tabs_synced);
        }
        this.mTabWidget.setTabSelectionListener(this);
        mMenuButton = (ImageButton)this.findViewById(R.id.menu);
        mMenuButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Menu menu2 = TabsPanel.this.mPopupMenu.getMenu();
                menu2.findItem(R.id.new_tab).setVisible(TabsPanel.this.mCurrentPanel != Panel.NORMAL_TABS);
                menu2.findItem(R.id.new_private_tab).setVisible(TabsPanel.this.mCurrentPanel != Panel.PRIVATE_TABS);
                menu2.findItem(R.id.close_all_tabs).setVisible(TabsPanel.this.mCurrentPanel == Panel.NORMAL_TABS);
                menu2.findItem(R.id.close_private_tabs).setVisible(TabsPanel.this.mCurrentPanel == Panel.PRIVATE_TABS);
                TabsPanel.this.mPopupMenu.show();
            }
        });
        this.mPopupMenu.setAnchor((View)mMenuButton);
    }

    private void addTab() {
        if (this.mCurrentPanel == Panel.NORMAL_TABS) {
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.ACTIONBAR, "new_tab");
            this.mActivity.addTab();
        } else {
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.ACTIONBAR, "new_private_tab");
            this.mActivity.addPrivateTab();
        }
        this.mActivity.autoHideTabs();
    }

    public void onTabChanged(int n) {
        if (n == 0) {
            this.show(Panel.NORMAL_TABS);
        } else if (n == 1) {
            this.show(Panel.PRIVATE_TABS);
        } else {
            this.show(Panel.REMOTE_TABS);
        }
    }

    public boolean onMenuItemClick(MenuItem menuItem) {
        int n = menuItem.getItemId();
        if (n == R.id.close_all_tabs) {
            if (this.mCurrentPanel == Panel.NORMAL_TABS) {
                String string2 = this.getResources().getResourceEntryName(n);
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.MENU, string2);
                mMenuButton.setEnabled(false);
                ((CloseAllPanelView)this.mPanelNormal).closeAll();
            } else {
                Log.e((String)LOGTAG, (String)"Close all tabs menu item should only be visible for normal tabs panel");
            }
            return true;
        }
        if (n == R.id.close_private_tabs) {
            if (this.mCurrentPanel == Panel.PRIVATE_TABS) {
                String string3 = this.getResources().getResourceEntryName(n);
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.MENU, string3);
                ((CloseAllPanelView)this.mPanelPrivate).closeAll();
            } else {
                Log.e((String)LOGTAG, (String)"Close private tabs menu item should only be visible for private tabs panel");
            }
            return true;
        }
        if (n == R.id.new_tab || n == R.id.new_private_tab) {
            this.hide();
        }
        return this.mActivity.onOptionsItemSelected(menuItem);
    }

    private static int getTabContainerHeight(TabsListContainer tabsListContainer) {
        Resources resources = tabsListContainer.getContext().getResources();
        PanelView panelView = tabsListContainer.getCurrentPanelView();
        if (panelView != null && !panelView.shouldExpand()) {
            return resources.getDimensionPixelSize(R.dimen.tabs_tray_horizontal_height);
        }
        int n = resources.getDimensionPixelSize(R.dimen.browser_toolbar_height);
        int n2 = resources.getDisplayMetrics().heightPixels;
        Rect rect = new Rect();
        tabsListContainer.getWindowVisibleDisplayFrame(rect);
        int n3 = rect.bottom - rect.top;
        return (int)Math.max((float)n2 * 0.5f, Math.min((float)n3 - 2.5f * (float)n, (float)n3 * 0.8f) - (float)n);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mTheme.addListener(this);
        this.mActivity.addAppStateListener(this.mAppStateListener);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mTheme.removeListener(this);
        this.mActivity.removeAppStateListener(this.mAppStateListener);
    }

    public void onLightweightThemeChanged() {
        int n = this.getResources().getColor(R.color.background_tabs);
        LightweightThemeDrawable lightweightThemeDrawable = this.mTheme.getColorDrawable((View)this, n, true);
        if (lightweightThemeDrawable == null) {
            return;
        }
        lightweightThemeDrawable.setAlpha(34, 0);
        this.setBackgroundDrawable(lightweightThemeDrawable);
    }

    public void onLightweightThemeReset() {
        this.setBackgroundColor(this.getContext().getResources().getColor(R.color.background_tabs));
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.onLightweightThemeChanged();
    }

    public void show(Panel panel) {
        if (!this.isShown()) {
            this.setVisibility(0);
        }
        if (this.mPanel != null) {
            this.mPanel.hide();
        }
        boolean bl = !this.mVisible;
        this.mVisible = true;
        this.mCurrentPanel = panel;
        int n = panel.ordinal();
        this.mTabWidget.setCurrentTab(n);
        switch (panel) {
            case NORMAL_TABS: {
                this.mPanel = this.mPanelNormal;
                break;
            }
            case PRIVATE_TABS: {
                this.mPanel = this.mPanelPrivate;
                break;
            }
            case REMOTE_TABS: {
                this.mPanel = this.mPanelRemote;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown panel type " + (Object)((Object)panel));
            }
        }
        this.mPanel.show();
        if (this.mCurrentPanel == Panel.REMOTE_TABS) {
            if (this.mFooter != null) {
                this.mFooter.setVisibility(8);
            }
            mAddTab.setVisibility(4);
            mMenuButton.setVisibility(4);
        } else {
            if (this.mFooter != null) {
                this.mFooter.setVisibility(0);
            }
            mAddTab.setVisibility(0);
            mAddTab.setImageLevel(n);
            mMenuButton.setVisibility(0);
            mMenuButton.setEnabled(true);
        }
        if (this.isSideBar()) {
            if (bl) {
                this.dispatchLayoutChange(this.getWidth(), this.getHeight());
            }
        } else {
            int n2 = this.mContext.getResources().getDimensionPixelSize(R.dimen.browser_toolbar_height);
            int n3 = n2 + TabsPanel.getTabContainerHeight(this.mTabsContainer);
            this.dispatchLayoutChange(this.getWidth(), n3);
        }
        this.mHeaderVisible = true;
    }

    public void hide() {
        this.mHeaderVisible = false;
        if (this.mVisible) {
            this.mVisible = false;
            this.mPopupMenu.dismiss();
            this.dispatchLayoutChange(0, 0);
        }
    }

    public void refresh() {
        this.removeAllViews();
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.tabs_panel, (ViewGroup)this);
        this.initialize();
        if (this.mVisible) {
            this.show(this.mCurrentPanel);
        }
    }

    public void autoHidePanel() {
        this.mActivity.autoHideTabs();
    }

    public boolean isShown() {
        return this.mVisible;
    }

    public boolean isSideBar() {
        return this.mIsSideBar;
    }

    public void setIsSideBar(boolean bl) {
        this.mIsSideBar = bl;
    }

    public Panel getCurrentPanel() {
        return this.mCurrentPanel;
    }

    public void prepareTabsAnimation(PropertyAnimator propertyAnimator) {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        if (this.mIsSideBar) {
            int n = this.getWidth();
            if (this.mVisible) {
                ViewHelper.setTranslationX((View)this.mHeader, -n);
                ViewHelper.setTranslationX((View)this.mTabsContainer, -n);
                ViewHelper.setTranslationX((View)this.mFooter, -n);
            }
            int n2 = this.mVisible ? 0 : -n;
            propertyAnimator.attach((View)this.mTabsContainer, PropertyAnimator.Property.TRANSLATION_X, n2);
            propertyAnimator.attach((View)this.mHeader, PropertyAnimator.Property.TRANSLATION_X, n2);
            propertyAnimator.attach((View)this.mFooter, PropertyAnimator.Property.TRANSLATION_X, n2);
        } else if (!this.mHeaderVisible) {
            Resources resources = this.getContext().getResources();
            int n = resources.getDimensionPixelSize(R.dimen.browser_toolbar_height);
            int n3 = this.mVisible ? 0 : -n;
            propertyAnimator.attach((View)this.mTabsContainer, PropertyAnimator.Property.ALPHA, 1.0f);
            propertyAnimator.attach((View)this.mTabsContainer, PropertyAnimator.Property.TRANSLATION_Y, n3);
            propertyAnimator.attach((View)this.mHeader, PropertyAnimator.Property.TRANSLATION_Y, n3);
        }
        this.mHeader.setLayerType(2, null);
        this.mTabsContainer.setLayerType(2, null);
    }

    public void finishTabsAnimation() {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        this.mHeader.setLayerType(0, null);
        this.mTabsContainer.setLayerType(0, null);
        if (!this.mVisible && this.mPanel != null) {
            this.mPanel.hide();
            this.mPanel = null;
        }
    }

    public void setTabsLayoutChangeListener(TabsLayoutChangeListener tabsLayoutChangeListener) {
        this.mLayoutChangeListener = tabsLayoutChangeListener;
    }

    private void dispatchLayoutChange(int n, int n2) {
        if (this.mLayoutChangeListener != null) {
            this.mLayoutChangeListener.onTabsLayoutChange(n, n2);
        }
    }

    public Drawable getIconDrawable(Panel panel) {
        return this.mTabWidget.getIconDrawable(panel.ordinal());
    }

    public void setIconDrawable(Panel panel, int n) {
        this.mTabWidget.setIconDrawable(panel.ordinal(), n);
    }

    static class TabsPanelToolbar
    extends LinearLayout
    implements LightweightTheme.OnChangeListener {
        private final LightweightTheme mTheme;

        public TabsPanelToolbar(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.mTheme = ((GeckoApplication)context.getApplicationContext()).getLightweightTheme();
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, (int)context.getResources().getDimension(R.dimen.browser_toolbar_height)));
            this.setOrientation(0);
        }

        public void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.mTheme.addListener(this);
        }

        public void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            this.mTheme.removeListener(this);
        }

        public void onLightweightThemeChanged() {
            int n = this.getResources().getColor(R.color.background_tabs);
            LightweightThemeDrawable lightweightThemeDrawable = this.mTheme.getColorDrawable((View)this, n);
            if (lightweightThemeDrawable == null) {
                return;
            }
            lightweightThemeDrawable.setAlpha(34, 34);
            this.setBackgroundDrawable(lightweightThemeDrawable);
        }

        public void onLightweightThemeReset() {
            this.setBackgroundColor(this.getContext().getResources().getColor(R.color.background_tabs));
        }

        protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
            super.onLayout(bl, n, n2, n3, n4);
            this.onLightweightThemeChanged();
        }
    }

    static class TabsListContainer
    extends FrameLayout {
        public TabsListContainer(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public PanelView getCurrentPanelView() {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = this.getChildAt(i);
                if (!(view instanceof PanelView) || view.getVisibility() != 0) continue;
                return (PanelView)view;
            }
            return null;
        }

        protected void onMeasure(int n, int n2) {
            if (!GeckoAppShell.getGeckoInterface().hasTabsSideBar()) {
                int n3 = View.MeasureSpec.makeMeasureSpec((int)TabsPanel.getTabContainerHeight(this), (int)0x40000000);
                super.onMeasure(n, n3);
            } else {
                super.onMeasure(n, n2);
            }
        }
    }

    public static interface TabsLayoutChangeListener {
        public void onTabsLayoutChange(int var1, int var2);
    }

    public static interface CloseAllPanelView
    extends PanelView {
        public void closeAll();
    }

    public static interface PanelView {
        public void setTabsPanel(TabsPanel var1);

        public void show();

        public void hide();

        public boolean shouldExpand();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Panel {
        NORMAL_TABS,
        PRIVATE_TABS,
        REMOTE_TABS;

    }
}

