/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tokenserver;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import ch.boye.httpclientandroidlib.message.BasicHeader;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.json.simple.JSONObject;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.SkewHandler;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonArrayJSONException;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.UnexpectedJSONException;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.BrowserIDAuthHeaderProvider;
import org.mozilla.gecko.sync.net.SyncResponse;
import org.mozilla.gecko.tokenserver.TokenServerClientDelegate;
import org.mozilla.gecko.tokenserver.TokenServerException;
import org.mozilla.gecko.tokenserver.TokenServerToken;

public class TokenServerClient {
    protected static final String LOG_TAG = "TokenServerClient";
    public static final String JSON_KEY_API_ENDPOINT = "api_endpoint";
    public static final String JSON_KEY_CONDITION_URLS = "condition_urls";
    public static final String JSON_KEY_DURATION = "duration";
    public static final String JSON_KEY_ERRORS = "errors";
    public static final String JSON_KEY_ID = "id";
    public static final String JSON_KEY_KEY = "key";
    public static final String JSON_KEY_UID = "uid";
    public static final String HEADER_CONDITIONS_ACCEPTED = "X-Conditions-Accepted";
    public static final String HEADER_CLIENT_STATE = "X-Client-State";
    protected final Executor executor;
    protected final URI uri;

    public TokenServerClient(URI uRI, Executor executor) {
        if (uRI == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        this.uri = uRI;
        this.executor = executor;
    }

    protected void invokeHandleSuccess(final TokenServerClientDelegate tokenServerClientDelegate, final TokenServerToken tokenServerToken) {
        this.executor.execute(new Runnable(){

            public void run() {
                tokenServerClientDelegate.handleSuccess(tokenServerToken);
            }
        });
    }

    protected void invokeHandleFailure(final TokenServerClientDelegate tokenServerClientDelegate, final TokenServerException tokenServerException) {
        this.executor.execute(new Runnable(){

            public void run() {
                tokenServerClientDelegate.handleFailure(tokenServerException);
            }
        });
    }

    protected void notifyBackoff(final TokenServerClientDelegate tokenServerClientDelegate, final int n) {
        this.executor.execute(new Runnable(){

            public void run() {
                tokenServerClientDelegate.handleBackoff(n);
            }
        });
    }

    protected void invokeHandleError(final TokenServerClientDelegate tokenServerClientDelegate, final Exception exception) {
        this.executor.execute(new Runnable(){

            public void run() {
                tokenServerClientDelegate.handleError(exception);
            }
        });
    }

    public TokenServerToken processResponse(SyncResponse syncResponse) throws TokenServerException {
        ExtendedJSONObject extendedJSONObject;
        int n = syncResponse.getStatusCode();
        Logger.debug(LOG_TAG, "Got token response with status code " + n + ".");
        Header header = syncResponse.getContentType();
        if (header == null) {
            throw new TokenServerException.TokenServerMalformedResponseException(null, "Non-JSON response Content-Type.");
        }
        String string2 = header.getValue();
        if (!string2.equals("application/json") && !string2.startsWith("application/json;")) {
            Logger.warn(LOG_TAG, "Got non-JSON response with Content-Type " + header + ". Misconfigured server?");
            throw new TokenServerException.TokenServerMalformedResponseException(null, "Non-JSON response Content-Type.");
        }
        try {
            extendedJSONObject = syncResponse.jsonObjectBody();
        }
        catch (Exception exception) {
            Logger.debug(LOG_TAG, "Malformed token response.", exception);
            throw new TokenServerException.TokenServerMalformedResponseException(null, (Throwable)exception);
        }
        if (syncResponse.getStatusCode() != 200) {
            ArrayList<ExtendedJSONObject> arrayList = new ArrayList<ExtendedJSONObject>();
            if (extendedJSONObject.containsKey(JSON_KEY_ERRORS)) {
                try {
                    for (Object object : extendedJSONObject.getArray(JSON_KEY_ERRORS)) {
                        Logger.warn(LOG_TAG, "" + object);
                        if (!(object instanceof JSONObject)) continue;
                        arrayList.add(new ExtendedJSONObject((JSONObject)object));
                    }
                }
                catch (NonArrayJSONException nonArrayJSONException) {
                    Logger.warn(LOG_TAG, "Got non-JSON array '" + extendedJSONObject.getString(JSON_KEY_ERRORS) + "'.", nonArrayJSONException);
                }
            }
            if (n == 400) {
                throw new TokenServerException.TokenServerMalformedRequestException(arrayList, extendedJSONObject.toJSONString());
            }
            if (n == 401) {
                throw new TokenServerException.TokenServerInvalidCredentialsException(arrayList, extendedJSONObject.toJSONString());
            }
            if (n == 403) {
                try {
                    Object object;
                    if (arrayList == null || arrayList.isEmpty()) {
                        throw new TokenServerException.TokenServerMalformedResponseException(arrayList, "403 response without proper fields.");
                    }
                    ExtendedJSONObject extendedJSONObject2 = (ExtendedJSONObject)arrayList.get(0);
                    object = extendedJSONObject2.getObject(JSON_KEY_CONDITION_URLS);
                    if (object != null) {
                        throw new TokenServerException.TokenServerConditionsRequiredException((ExtendedJSONObject)object);
                    }
                }
                catch (NonObjectJSONException nonObjectJSONException) {
                    Logger.warn(LOG_TAG, "Got non-JSON error object.");
                }
                throw new TokenServerException.TokenServerMalformedResponseException(arrayList, "403 response without proper fields.");
            }
            if (n == 404) {
                throw new TokenServerException.TokenServerUnknownServiceException(arrayList);
            }
            throw new TokenServerException(arrayList);
        }
        try {
            extendedJSONObject.throwIfFieldsMissingOrMisTyped(new String[]{JSON_KEY_ID, JSON_KEY_KEY, JSON_KEY_API_ENDPOINT}, String.class);
            extendedJSONObject.throwIfFieldsMissingOrMisTyped(new String[]{JSON_KEY_UID}, Long.class);
        }
        catch (UnexpectedJSONException.BadRequiredFieldJSONException badRequiredFieldJSONException) {
            throw new TokenServerException.TokenServerMalformedResponseException(null, (Throwable)badRequiredFieldJSONException);
        }
        Logger.debug(LOG_TAG, "Successful token response: " + extendedJSONObject.getString(JSON_KEY_ID));
        return new TokenServerToken(extendedJSONObject.getString(JSON_KEY_ID), extendedJSONObject.getString(JSON_KEY_KEY), extendedJSONObject.get(JSON_KEY_UID).toString(), extendedJSONObject.getString(JSON_KEY_API_ENDPOINT));
    }

    public void getTokenFromBrowserIDAssertion(String string2, boolean bl, String string3, TokenServerClientDelegate tokenServerClientDelegate) {
        BaseResource baseResource = new BaseResource(this.uri);
        baseResource.delegate = new TokenFetchResourceDelegate(this, baseResource, tokenServerClientDelegate, string2, string3, bl);
        baseResource.get();
    }

    public static class TokenFetchResourceDelegate
    extends BaseResourceDelegate {
        private final TokenServerClient client;
        private final TokenServerClientDelegate delegate;
        private final String assertion;
        private final String clientState;
        private final BaseResource resource;
        private final boolean conditionsAccepted;

        public TokenFetchResourceDelegate(TokenServerClient tokenServerClient, BaseResource baseResource, TokenServerClientDelegate tokenServerClientDelegate, String string2, String string3, boolean bl) {
            super(baseResource);
            this.client = tokenServerClient;
            this.delegate = tokenServerClientDelegate;
            this.assertion = string2;
            this.clientState = string3;
            this.resource = baseResource;
            this.conditionsAccepted = bl;
        }

        public String getUserAgent() {
            return this.delegate.getUserAgent();
        }

        public void handleHttpResponse(HttpResponse httpResponse) {
            SkewHandler skewHandler = SkewHandler.getSkewHandlerForResource(this.resource);
            skewHandler.updateSkew(httpResponse, System.currentTimeMillis());
            SyncResponse syncResponse = new SyncResponse(httpResponse);
            boolean bl = syncResponse.getStatusCode() == 503;
            int n = syncResponse.totalBackoffInSeconds(bl);
            if (n > -1) {
                this.client.notifyBackoff(this.delegate, n);
            }
            try {
                TokenServerToken tokenServerToken = this.client.processResponse(syncResponse);
                this.client.invokeHandleSuccess(this.delegate, tokenServerToken);
            }
            catch (TokenServerException tokenServerException) {
                this.client.invokeHandleFailure(this.delegate, tokenServerException);
            }
        }

        public void handleTransportException(GeneralSecurityException generalSecurityException) {
            this.client.invokeHandleError(this.delegate, generalSecurityException);
        }

        public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
            this.client.invokeHandleError(this.delegate, (Exception)clientProtocolException);
        }

        public void handleHttpIOException(IOException iOException) {
            this.client.invokeHandleError(this.delegate, iOException);
        }

        public AuthHeaderProvider getAuthHeaderProvider() {
            return new BrowserIDAuthHeaderProvider(this.assertion);
        }

        public void addHeaders(HttpRequestBase httpRequestBase, DefaultHttpClient defaultHttpClient) {
            String string2 = httpRequestBase.getURI().getHost();
            httpRequestBase.setHeader((Header)new BasicHeader("Host", string2));
            if (this.clientState != null) {
                httpRequestBase.setHeader((Header)new BasicHeader(TokenServerClient.HEADER_CLIENT_STATE, this.clientState));
            }
            if (this.conditionsAccepted) {
                httpRequestBase.addHeader(TokenServerClient.HEADER_CONDITIONS_ACCEPTED, "1");
            }
        }
    }
}

