/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.support.v4.util.LruCache;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonEvictingLruCache<K, V> {
    private final ConcurrentHashMap<K, V> permanent = new ConcurrentHashMap();
    private final LruCache<K, V> evictable;

    public NonEvictingLruCache(int n) {
        this.evictable = new LruCache(n);
    }

    public V get(K k) {
        V v = this.permanent.get(k);
        if (v == null) {
            return (V)this.evictable.get(k);
        }
        return v;
    }

    public void putWithoutEviction(K k, V v) {
        this.permanent.put(k, v);
    }

    public void put(K k, V v) {
        this.evictable.put(k, v);
    }

    public void evictAll() {
        this.evictable.evictAll();
    }
}

