/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl;

import ch.boye.httpclientandroidlib.HttpConnectionMetrics;
import ch.boye.httpclientandroidlib.io.HttpTransportMetrics;
import java.util.HashMap;

public class HttpConnectionMetricsImpl
implements HttpConnectionMetrics {
    public static final String REQUEST_COUNT = "http.request-count";
    public static final String RESPONSE_COUNT = "http.response-count";
    public static final String SENT_BYTES_COUNT = "http.sent-bytes-count";
    public static final String RECEIVED_BYTES_COUNT = "http.received-bytes-count";
    private final HttpTransportMetrics inTransportMetric;
    private final HttpTransportMetrics outTransportMetric;
    private long requestCount = 0L;
    private long responseCount = 0L;
    private HashMap metricsCache;

    public HttpConnectionMetricsImpl(HttpTransportMetrics httpTransportMetrics, HttpTransportMetrics httpTransportMetrics2) {
        this.inTransportMetric = httpTransportMetrics;
        this.outTransportMetric = httpTransportMetrics2;
    }

    public long getReceivedBytesCount() {
        if (this.inTransportMetric != null) {
            return this.inTransportMetric.getBytesTransferred();
        }
        return -1L;
    }

    public long getSentBytesCount() {
        if (this.outTransportMetric != null) {
            return this.outTransportMetric.getBytesTransferred();
        }
        return -1L;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public void incrementRequestCount() {
        ++this.requestCount;
    }

    public long getResponseCount() {
        return this.responseCount;
    }

    public void incrementResponseCount() {
        ++this.responseCount;
    }

    public Object getMetric(String string) {
        Long l = null;
        if (this.metricsCache != null) {
            l = (Long)this.metricsCache.get(string);
        }
        if (l == null) {
            if (REQUEST_COUNT.equals(string)) {
                l = new Long(this.requestCount);
            } else if (RESPONSE_COUNT.equals(string)) {
                l = new Long(this.responseCount);
            } else {
                if (RECEIVED_BYTES_COUNT.equals(string)) {
                    if (this.inTransportMetric != null) {
                        return new Long(this.inTransportMetric.getBytesTransferred());
                    }
                    return null;
                }
                if (SENT_BYTES_COUNT.equals(string)) {
                    if (this.outTransportMetric != null) {
                        return new Long(this.outTransportMetric.getBytesTransferred());
                    }
                    return null;
                }
            }
        }
        return l;
    }

    public void setMetric(String string, Object object) {
        if (this.metricsCache == null) {
            this.metricsCache = new HashMap();
        }
        this.metricsCache.put(string, object);
    }

    public void reset() {
        if (this.outTransportMetric != null) {
            this.outTransportMetric.reset();
        }
        if (this.inTransportMetric != null) {
            this.inTransportMetric.reset();
        }
        this.requestCount = 0L;
        this.responseCount = 0L;
        this.metricsCache = null;
    }
}

