/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.videoengine;

import android.content.Context;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.util.ThreadUtils;
import org.webrtc.videoengine.ViEAndroidGLES20;

public class ViERenderer {
    private static final String TAG = "WEBRTC-ViEREnderer";
    private static SurfaceHolder g_localRenderer = null;

    public static SurfaceView CreateRenderer(Context context) {
        return ViERenderer.CreateRenderer(context, false);
    }

    public static SurfaceView CreateRenderer(Context context, boolean bl) {
        if (bl && ViEAndroidGLES20.IsSupported(context)) {
            return new ViEAndroidGLES20(context);
        }
        return new SurfaceView(context);
    }

    public static void CreateLocalRenderer() {
        View view = GeckoAppShell.getGeckoInterface().getCameraView();
        if (view != null && view instanceof SurfaceView) {
            SurfaceView surfaceView = (SurfaceView)view;
            g_localRenderer = surfaceView.getHolder();
        }
        ThreadUtils.getUiHandler().post(new Runnable(){

            public void run() {
                try {
                    GeckoAppShell.getGeckoInterface().enableCameraView();
                }
                catch (Exception exception) {
                    Log.e((String)ViERenderer.TAG, (String)("CreateLocalRenderer enableCameraView exception: " + exception.getLocalizedMessage()));
                }
            }
        });
    }

    public static void DestroyLocalRenderer() {
        if (g_localRenderer != null) {
            g_localRenderer = null;
            ThreadUtils.getUiHandler().post(new Runnable(){

                public void run() {
                    try {
                        GeckoAppShell.getGeckoInterface().disableCameraView();
                    }
                    catch (Exception exception) {
                        Log.e((String)ViERenderer.TAG, (String)("DestroyLocalRenderer disableCameraView exception: " + exception.getLocalizedMessage()));
                    }
                }
            });
        }
    }

    public static SurfaceHolder GetLocalRenderer() {
        return g_localRenderer;
    }
}

