/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import android.content.Context;
import android.media.AudioRecord;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import org.mozilla.gecko.mozglue.WebRTCJNITarget;

@WebRTCJNITarget
class WebRtcAudioRecord {
    private AudioRecord _audioRecord = null;
    private Context _context;
    private ByteBuffer _recBuffer;
    private byte[] _tempBufRec;
    private final ReentrantLock _recLock = new ReentrantLock();
    private boolean _doRecInit = true;
    private boolean _isRecording = false;
    private int _bufferedRecSamples = 0;
    final String logTag = "WebRTC AR java";

    WebRtcAudioRecord() {
        try {
            this._recBuffer = ByteBuffer.allocateDirect(960);
        }
        catch (Exception exception) {
            this.DoLog(exception.getMessage());
        }
        this._tempBufRec = new byte[960];
    }

    private int InitRecording(int n, int n2) {
        n = Build.VERSION.SDK_INT >= 11 ? 7 : 0;
        int n3 = AudioRecord.getMinBufferSize((int)n2, (int)16, (int)2);
        int n4 = n3 * 2;
        this._bufferedRecSamples = n2 / 200;
        if (this._audioRecord != null) {
            this._audioRecord.release();
            this._audioRecord = null;
        }
        try {
            this._audioRecord = new AudioRecord(n, n2, 16, 2, n4);
        }
        catch (Exception exception) {
            this.DoLog(exception.getMessage());
            return -1;
        }
        if (this._audioRecord.getState() != 1) {
            return -1;
        }
        return this._bufferedRecSamples;
    }

    private int StartRecording() {
        try {
            this._audioRecord.startRecording();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return -1;
        }
        this._isRecording = true;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int StopRecording() {
        this._recLock.lock();
        try {
            if (this._audioRecord.getRecordingState() == 3) {
                try {
                    this._audioRecord.stop();
                }
                catch (IllegalStateException illegalStateException) {
                    illegalStateException.printStackTrace();
                    int n = -1;
                    this._doRecInit = true;
                    this._recLock.unlock();
                    return n;
                }
            }
            this._audioRecord.release();
            this._audioRecord = null;
        }
        finally {
            this._doRecInit = true;
            this._recLock.unlock();
        }
        this._isRecording = false;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int RecordAudio(int n) {
        this._recLock.lock();
        try {
            if (this._audioRecord == null) {
                int n2 = -2;
                return n2;
            }
            if (this._doRecInit) {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception exception) {
                    this.DoLog("Set rec thread priority failed: " + exception.getMessage());
                }
                this._doRecInit = false;
            }
            int n3 = 0;
            this._recBuffer.rewind();
            n3 = this._audioRecord.read(this._tempBufRec, 0, n);
            this._recBuffer.put(this._tempBufRec);
            if (n3 != n) {
                int n4 = -1;
                return n4;
            }
        }
        catch (Exception exception) {
            this.DoLogErr("RecordAudio try failed: " + exception.getMessage());
        }
        finally {
            this._recLock.unlock();
        }
        return this._bufferedRecSamples;
    }

    private void DoLog(String string) {
        Log.d((String)"WebRTC AR java", (String)string);
    }

    private void DoLogErr(String string) {
        Log.e((String)"WebRTC AR java", (String)string);
    }
}

