/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.setup.auth;

import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.setup.auth.AccountAuthenticator;
import org.mozilla.gecko.sync.setup.auth.AuthenticationResult;
import org.mozilla.gecko.sync.setup.auth.AuthenticatorStage;

public class FetchUserNodeStage
implements AuthenticatorStage {
    private final String LOG_TAG = "FetchUserNodeStage";

    public void execute(final AccountAuthenticator accountAuthenticator) throws URISyntaxException {
        FetchNodeStageDelegate fetchNodeStageDelegate = new FetchNodeStageDelegate(){

            public void handleSuccess(String string2) {
                if (string2 == null) {
                    Logger.debug("FetchUserNodeStage", "Using server as auth node.");
                    accountAuthenticator.authServer = accountAuthenticator.nodeServer;
                    accountAuthenticator.runNextStage();
                    return;
                }
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                accountAuthenticator.authServer = string2;
                accountAuthenticator.runNextStage();
            }

            public void handleFailure(HttpResponse httpResponse) {
                int n = httpResponse.getStatusLine().getStatusCode();
                Logger.debug("FetchUserNodeStage", "Failed to fetch user node, with status " + n);
                accountAuthenticator.abort(AuthenticationResult.FAILURE_OTHER, new Exception("HTTP " + n + " error."));
            }

            public void handleError(Exception exception) {
                Logger.debug("FetchUserNodeStage", "Error in fetching node.");
                accountAuthenticator.abort(AuthenticationResult.FAILURE_OTHER, exception);
            }
        };
        String string2 = Utils.nodeWeaveURL(accountAuthenticator.nodeServer, accountAuthenticator.username);
        Logger.pii("FetchUserNodeStage", "NodeUrl: " + string2);
        final BaseResource baseResource = this.makeFetchNodeRequest(fetchNodeStageDelegate, string2);
        AccountAuthenticator.runOnThread(new Runnable(){

            public void run() {
                baseResource.get();
            }
        });
    }

    private BaseResource makeFetchNodeRequest(final FetchNodeStageDelegate fetchNodeStageDelegate, String string2) throws URISyntaxException {
        BaseResource baseResource = new BaseResource(string2);
        baseResource.delegate = new BaseResourceDelegate(baseResource){

            public String getUserAgent() {
                return "Firefox AndroidSync 1.33.0a1.0 (Nightly)";
            }

            public void handleHttpResponse(HttpResponse httpResponse) {
                int n = httpResponse.getStatusLine().getStatusCode();
                switch (n) {
                    case 200: {
                        try {
                            InputStream inputStream = httpResponse.getEntity().getContent();
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"), 1024);
                            String string2 = bufferedReader.readLine();
                            fetchNodeStageDelegate.handleSuccess(string2);
                            BaseResource.consumeReader(bufferedReader);
                            bufferedReader.close();
                        }
                        catch (IllegalStateException illegalStateException) {
                            fetchNodeStageDelegate.handleError(illegalStateException);
                        }
                        catch (IOException iOException) {
                            fetchNodeStageDelegate.handleError(iOException);
                        }
                        break;
                    }
                    case 404: {
                        fetchNodeStageDelegate.handleSuccess(null);
                        break;
                    }
                    default: {
                        fetchNodeStageDelegate.handleFailure(httpResponse);
                    }
                }
                BaseResource.consumeEntity(httpResponse.getEntity());
            }

            public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
                fetchNodeStageDelegate.handleError((Exception)((Object)clientProtocolException));
            }

            public void handleHttpIOException(IOException iOException) {
                fetchNodeStageDelegate.handleError(iOException);
            }

            public void handleTransportException(GeneralSecurityException generalSecurityException) {
                fetchNodeStageDelegate.handleError(generalSecurityException);
            }
        };
        return baseResource;
    }

    public static interface FetchNodeStageDelegate {
        public void handleSuccess(String var1);

        public void handleFailure(HttpResponse var1);

        public void handleError(Exception var1);
    }
}

