/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.synchronizer;

import android.content.Context;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.repositories.InactiveSessionException;
import org.mozilla.gecko.sync.repositories.InvalidSessionTransitionException;
import org.mozilla.gecko.sync.repositories.RepositorySession;
import org.mozilla.gecko.sync.repositories.RepositorySessionBundle;
import org.mozilla.gecko.sync.repositories.delegates.DeferrableRepositorySessionCreationDelegate;
import org.mozilla.gecko.sync.repositories.delegates.DeferredRepositorySessionFinishDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFinishDelegate;
import org.mozilla.gecko.sync.synchronizer.RecordsChannel;
import org.mozilla.gecko.sync.synchronizer.RecordsChannelDelegate;
import org.mozilla.gecko.sync.synchronizer.Synchronizer;
import org.mozilla.gecko.sync.synchronizer.SynchronizerSessionDelegate;
import org.mozilla.gecko.sync.synchronizer.UnbundleError;
import org.mozilla.gecko.sync.synchronizer.UnexpectedSessionException;

public class SynchronizerSession
extends DeferrableRepositorySessionCreationDelegate
implements RecordsChannelDelegate,
RepositorySessionFinishDelegate {
    protected static final String LOG_TAG = "SynchronizerSession";
    protected Synchronizer synchronizer;
    protected SynchronizerSessionDelegate delegate;
    protected Context context;
    private RepositorySession sessionA;
    private RepositorySession sessionB;
    private RepositorySessionBundle bundleA;
    private RepositorySessionBundle bundleB;
    private long pendingATimestamp = -1L;
    private long pendingBTimestamp = -1L;
    private long storeEndATimestamp = -1L;
    private long storeEndBTimestamp = -1L;
    private boolean flowAToBCompleted = false;
    private boolean flowBToACompleted = false;
    protected final AtomicInteger numInboundRecords = new AtomicInteger(-1);
    protected final AtomicInteger numOutboundRecords = new AtomicInteger(-1);
    protected RecordsChannel channelAToB;
    protected RecordsChannel channelBToA;

    public SynchronizerSession(Synchronizer synchronizer, SynchronizerSessionDelegate synchronizerSessionDelegate) {
        this.setSynchronizer(synchronizer);
        this.delegate = synchronizerSessionDelegate;
    }

    public Synchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public void setSynchronizer(Synchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public void init(Context context, RepositorySessionBundle repositorySessionBundle, RepositorySessionBundle repositorySessionBundle2) {
        this.context = context;
        this.bundleA = repositorySessionBundle;
        this.bundleB = repositorySessionBundle2;
        this.getSynchronizer().repositoryA.createSession(this, context);
    }

    public int getInboundCount() {
        return this.numInboundRecords.get();
    }

    public int getOutboundCount() {
        return this.numOutboundRecords.get();
    }

    public synchronized void synchronize() {
        this.numInboundRecords.set(-1);
        this.numOutboundRecords.set(-1);
        if (this.sessionA.shouldSkip() || this.sessionB.shouldSkip()) {
            Logger.info(LOG_TAG, "Session requested skip. Short-circuiting sync.");
            this.sessionA.abort();
            this.sessionB.abort();
            this.delegate.onSynchronizeSkipped(this);
            return;
        }
        final SynchronizerSession synchronizerSession = this;
        this.channelBToA = new RecordsChannel(this.sessionB, this.sessionA, this);
        RecordsChannelDelegate recordsChannelDelegate = new RecordsChannelDelegate(){

            public void onFlowCompleted(RecordsChannel recordsChannel, long l, long l2) {
                synchronizerSession.onFirstFlowCompleted(recordsChannel, l, l2);
            }

            public void onFlowBeginFailed(RecordsChannel recordsChannel, Exception exception) {
                Logger.warn(SynchronizerSession.LOG_TAG, "First RecordsChannel onFlowBeginFailed. Logging session error.", exception);
                synchronizerSession.delegate.onSynchronizeFailed(synchronizerSession, exception, "Failed to begin first flow.");
            }

            public void onFlowFetchFailed(RecordsChannel recordsChannel, Exception exception) {
                Logger.warn(SynchronizerSession.LOG_TAG, "First RecordsChannel onFlowFetchFailed. Logging remote fetch error.", exception);
            }

            public void onFlowStoreFailed(RecordsChannel recordsChannel, Exception exception, String string2) {
                Logger.warn(SynchronizerSession.LOG_TAG, "First RecordsChannel onFlowStoreFailed. Logging local store error.", exception);
            }

            public void onFlowFinishFailed(RecordsChannel recordsChannel, Exception exception) {
                Logger.warn(SynchronizerSession.LOG_TAG, "First RecordsChannel onFlowFinishedFailed. Logging session error.", exception);
                synchronizerSession.delegate.onSynchronizeFailed(synchronizerSession, exception, "Failed to finish first flow.");
            }
        };
        this.channelAToB = new RecordsChannel(this.sessionA, this.sessionB, recordsChannelDelegate);
        Logger.trace(LOG_TAG, "Starting A to B flow. Channel is " + this.channelAToB);
        try {
            this.channelAToB.beginAndFlow();
        }
        catch (InvalidSessionTransitionException invalidSessionTransitionException) {
            this.onFlowBeginFailed(this.channelAToB, invalidSessionTransitionException);
        }
    }

    public void onFirstFlowCompleted(RecordsChannel recordsChannel, long l, long l2) {
        Logger.trace(LOG_TAG, "First RecordsChannel onFlowCompleted.");
        Logger.debug(LOG_TAG, "Fetch end is " + l + ". Store end is " + l2 + ". Starting next.");
        this.pendingATimestamp = l;
        this.storeEndBTimestamp = l2;
        this.numInboundRecords.set(recordsChannel.getFetchCount());
        this.flowAToBCompleted = true;
        this.channelBToA.flow();
    }

    public void onSecondFlowCompleted(RecordsChannel recordsChannel, long l, long l2) {
        Logger.trace(LOG_TAG, "Second RecordsChannel onFlowCompleted.");
        Logger.debug(LOG_TAG, "Fetch end is " + l + ". Store end is " + l2 + ". Finishing.");
        this.pendingBTimestamp = l;
        this.storeEndATimestamp = l2;
        this.numOutboundRecords.set(recordsChannel.getFetchCount());
        this.flowBToACompleted = true;
        try {
            this.sessionA.finish(this);
        }
        catch (InactiveSessionException inactiveSessionException) {
            this.onFinishFailed(inactiveSessionException);
            return;
        }
    }

    public void onFlowCompleted(RecordsChannel recordsChannel, long l, long l2) {
        this.onSecondFlowCompleted(recordsChannel, l, l2);
    }

    public void onFlowBeginFailed(RecordsChannel recordsChannel, Exception exception) {
        Logger.warn(LOG_TAG, "Second RecordsChannel onFlowBeginFailed. Logging session error.", exception);
        this.delegate.onSynchronizeFailed(this, exception, "Failed to begin second flow.");
    }

    public void onFlowFetchFailed(RecordsChannel recordsChannel, Exception exception) {
        Logger.warn(LOG_TAG, "Second RecordsChannel onFlowFetchFailed. Logging local fetch error.", exception);
    }

    public void onFlowStoreFailed(RecordsChannel recordsChannel, Exception exception, String string2) {
        Logger.warn(LOG_TAG, "Second RecordsChannel onFlowStoreFailed. Logging remote store error.", exception);
    }

    public void onFlowFinishFailed(RecordsChannel recordsChannel, Exception exception) {
        Logger.warn(LOG_TAG, "Second RecordsChannel onFlowFinishedFailed. Logging session error.", exception);
        this.delegate.onSynchronizeFailed(this, exception, "Failed to finish second flow.");
    }

    public void onSessionCreateFailed(Exception exception) {
        if (this.sessionA != null) {
            try {
                this.context = null;
                this.sessionA.finish(this);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        this.context = null;
        this.delegate.onSynchronizeFailed(this, exception, "Failed to create session");
    }

    public void onSessionCreated(RepositorySession repositorySession) {
        if (repositorySession == null || this.sessionA == repositorySession) {
            this.delegate.onSynchronizeFailed(this, new UnexpectedSessionException(repositorySession), "Failed to create session.");
            return;
        }
        if (this.sessionA == null) {
            this.sessionA = repositorySession;
            try {
                this.sessionA.unbundle(this.bundleA);
            }
            catch (Exception exception) {
                this.delegate.onSynchronizeFailed(this, new UnbundleError(exception, this.sessionA), "Failed to unbundle first session.");
                return;
            }
            this.getSynchronizer().repositoryB.createSession(this, this.context);
            return;
        }
        if (this.sessionB == null) {
            this.sessionB = repositorySession;
            this.context = null;
            try {
                this.sessionB.unbundle(this.bundleB);
            }
            catch (Exception exception) {
                this.delegate.onSynchronizeFailed(this, new UnbundleError(exception, this.sessionA), "Failed to unbundle second session.");
                return;
            }
            this.delegate.onInitialized(this);
            return;
        }
        this.delegate.onSynchronizeFailed(this, new UnexpectedSessionException(repositorySession), "Failed to create session.");
    }

    public void onFinishFailed(Exception exception) {
        if (this.sessionB == null) {
            Logger.warn(LOG_TAG, "Got exception cleaning up first after second session creation failed.", exception);
            return;
        }
        String string2 = this.sessionA == null ? "B" : "A";
        this.delegate.onSynchronizeFailed(this, exception, "Finish of session " + string2 + " failed.");
    }

    public void onFinishSucceeded(RepositorySession repositorySession, RepositorySessionBundle repositorySessionBundle) {
        Logger.debug(LOG_TAG, "onFinishSucceeded. Flows? " + this.flowAToBCompleted + ", " + this.flowBToACompleted);
        if (repositorySession == this.sessionA) {
            if (!this.flowAToBCompleted) {
                this.delegate.onSynchronizeFailed(this, new UnexpectedSessionException(this.sessionA), "Failed to finish first session.");
                return;
            }
            Logger.debug(LOG_TAG, "onFinishSucceeded: bumping session A's timestamp to " + this.pendingATimestamp + " or " + this.storeEndATimestamp);
            repositorySessionBundle.bumpTimestamp(Math.max(this.pendingATimestamp, this.storeEndATimestamp));
            this.synchronizer.bundleA = repositorySessionBundle;
            if (this.sessionB != null) {
                Logger.trace(LOG_TAG, "Finishing session B.");
                try {
                    this.sessionB.finish(this);
                }
                catch (InactiveSessionException inactiveSessionException) {
                    this.onFinishFailed(inactiveSessionException);
                    return;
                }
            }
        } else if (repositorySession == this.sessionB) {
            if (this.flowBToACompleted) {
                Logger.debug(LOG_TAG, "onFinishSucceeded: bumping session B's timestamp to " + this.pendingBTimestamp + " or " + this.storeEndBTimestamp);
                repositorySessionBundle.bumpTimestamp(Math.max(this.pendingBTimestamp, this.storeEndBTimestamp));
                this.synchronizer.bundleB = repositorySessionBundle;
                Logger.trace(LOG_TAG, "Notifying delegate.onSynchronized.");
                this.delegate.onSynchronized(this);
            } else {
                this.delegate.onSynchronizeFailed(this, new UnexpectedSessionException(this.sessionB), "Failed to finish second session.");
                return;
            }
        }
        if (this.sessionB == null) {
            this.sessionA = null;
        }
    }

    public RepositorySessionFinishDelegate deferredFinishDelegate(ExecutorService executorService) {
        return new DeferredRepositorySessionFinishDelegate(this, executorService);
    }
}

