/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.announcements;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.mozilla.gecko.background.announcements.AnnouncementsConstants;
import org.mozilla.gecko.background.announcements.AnnouncementsFetchDelegate;
import org.mozilla.gecko.background.announcements.AnnouncementsFetchResourceDelegate;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.net.BaseResource;

public class AnnouncementsFetcher {
    private static final String LOG_TAG = "AnnounceFetch";
    private static final long MILLISECONDS_PER_DAY = 86400000L;

    public static URI getSnippetURI(String string2, String string3, String string4, String string5, int n) throws URISyntaxException {
        try {
            String string6 = URLEncoder.encode(string3, "UTF-8");
            String string7 = URLEncoder.encode(string4, "UTF-8");
            String string8 = URLEncoder.encode(string5, "UTF-8");
            String string9 = string2 + string6 + "/" + string7 + "/" + string8 + (n == -1 ? "" : "?idle=" + n);
            return new URI(string9);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static URI getAnnounceURI(String string2, long l) throws URISyntaxException {
        String string3 = AnnouncementsFetcher.getChannel();
        String string4 = AnnouncementsFetcher.getVersion();
        String string5 = AnnouncementsFetcher.getPlatform();
        int n = AnnouncementsFetcher.getIdleDays(l);
        Logger.debug(LOG_TAG, "Fetch URI: idle for " + n + " days.");
        return AnnouncementsFetcher.getSnippetURI(string2, string3, string4, string5, n);
    }

    protected static String getChannel() {
        return AnnouncementsConstants.ANNOUNCE_CHANNEL;
    }

    protected static String getVersion() {
        return "33.0a1";
    }

    protected static String getPlatform() {
        return "x86";
    }

    protected static int getIdleDays(long l, long l2) {
        if (l <= 0L) {
            return -1;
        }
        if (l2 < 1405334234000L) {
            Logger.warn(LOG_TAG, "Current time " + l2 + " earlier than build date. Not calculating idle.");
            return -1;
        }
        if (l2 < l) {
            Logger.warn(LOG_TAG, "Current time " + l2 + " earlier than last launch! Not calculating idle.");
            return -1;
        }
        long l3 = l2 - l;
        int n = (int)(l3 / 86400000L);
        if ((long)n > AnnouncementsConstants.MAX_SANE_IDLE_DAYS) {
            Logger.warn(LOG_TAG, "Idle from " + l + " until " + l2 + ", which is insane. Not calculating idle.");
            return -1;
        }
        return n;
    }

    protected static int getIdleDays(long l) {
        long l2 = System.currentTimeMillis();
        return AnnouncementsFetcher.getIdleDays(l, l2);
    }

    public static void fetchAnnouncements(URI uRI, AnnouncementsFetchDelegate announcementsFetchDelegate) {
        BaseResource baseResource = new BaseResource(uRI);
        baseResource.delegate = new AnnouncementsFetchResourceDelegate(baseResource, announcementsFetchDelegate);
        baseResource.getBlocking();
    }

    public static void fetchAndProcessAnnouncements(long l, AnnouncementsFetchDelegate announcementsFetchDelegate) {
        long l2 = System.currentTimeMillis();
        Logger.debug(LOG_TAG, "Fetching announcements. Last launch: " + l + "; now: " + l2);
        try {
            String string2 = announcementsFetchDelegate.getServiceURL();
            URI uRI = AnnouncementsFetcher.getAnnounceURI(string2, l);
            Logger.info(LOG_TAG, "Fetching announcements from " + uRI.toASCIIString());
            AnnouncementsFetcher.fetchAnnouncements(uRI, announcementsFetchDelegate);
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.warn(LOG_TAG, "Couldn't create URL.", uRISyntaxException);
            return;
        }
    }
}

