/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import java.util.ArrayList;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.sync.Utils;

final class BrowserDatabaseHelper
extends SQLiteOpenHelper {
    private static final String LOGTAG = "GeckoBrowserDBHelper";
    public static final int DATABASE_VERSION = 20;
    public static final String DATABASE_NAME = "browser.db";
    protected final Context mContext;
    static final String TABLE_BOOKMARKS = "bookmarks";
    static final String TABLE_HISTORY = "history";
    static final String TABLE_FAVICONS = "favicons";
    static final String TABLE_THUMBNAILS = "thumbnails";
    static final String TABLE_READING_LIST = "reading_list";
    static final String VIEW_COMBINED = "combined";
    static final String VIEW_BOOKMARKS_WITH_FAVICONS = "bookmarks_with_favicons";
    static final String VIEW_HISTORY_WITH_FAVICONS = "history_with_favicons";
    static final String VIEW_COMBINED_WITH_FAVICONS = "combined_with_favicons";
    static final String TABLE_BOOKMARKS_JOIN_FAVICONS = "bookmarks LEFT OUTER JOIN favicons ON " + BrowserDatabaseHelper.qualifyColumn("bookmarks", "favicon_id") + " = " + BrowserDatabaseHelper.qualifyColumn("favicons", "_id");
    static final String TABLE_HISTORY_JOIN_FAVICONS = "history LEFT OUTER JOIN favicons ON " + BrowserDatabaseHelper.qualifyColumn("history", "favicon_id") + " = " + BrowserDatabaseHelper.qualifyColumn("favicons", "_id");
    static final String TABLE_BOOKMARKS_TMP = "bookmarks_tmp";
    static final String TABLE_HISTORY_TMP = "history_tmp";
    static final String TABLE_IMAGES_TMP = "images_tmp";
    private static final String[] mobileIdColumns = new String[]{"_id"};
    private static final String[] mobileIdSelectionArgs = new String[]{"mobile"};
    private static boolean logDebug = Log.isLoggable((String)"GeckoBrowserDBHelper", (int)3);
    private static boolean logVerbose = Log.isLoggable((String)"GeckoBrowserDBHelper", (int)2);

    public BrowserDatabaseHelper(Context context, String string2) {
        super(context, string2, null, 20);
        this.mContext = context;
    }

    private void createBookmarksTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating bookmarks table");
        String string2 = null;
        if (Build.VERSION.SDK_INT >= 8) {
            string2 = ", FOREIGN KEY (parent) REFERENCES bookmarks(_id)";
        }
        sQLiteDatabase.execSQL("CREATE TABLE bookmarks(_id INTEGER PRIMARY KEY AUTOINCREMENT,title TEXT,url TEXT,type INTEGER NOT NULL DEFAULT 1,parent INTEGER,position INTEGER NOT NULL,keyword TEXT,description TEXT,tags TEXT,created INTEGER,modified INTEGER,guid TEXT NOT NULL,deleted INTEGER NOT NULL DEFAULT 0" + (string2 != null ? string2 : "") + ");");
        sQLiteDatabase.execSQL("CREATE INDEX bookmarks_url_index ON bookmarks(url)");
        sQLiteDatabase.execSQL("CREATE INDEX bookmarks_type_deleted_index ON bookmarks(type, deleted)");
        sQLiteDatabase.execSQL("CREATE UNIQUE INDEX bookmarks_guid_index ON bookmarks(guid)");
        sQLiteDatabase.execSQL("CREATE INDEX bookmarks_modified_index ON bookmarks(modified)");
    }

    private void createBookmarksTableOn13(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating bookmarks table");
        String string2 = null;
        if (Build.VERSION.SDK_INT >= 8) {
            string2 = ", FOREIGN KEY (parent) REFERENCES bookmarks(_id)";
        }
        sQLiteDatabase.execSQL("CREATE TABLE bookmarks(_id INTEGER PRIMARY KEY AUTOINCREMENT,title TEXT,url TEXT,type INTEGER NOT NULL DEFAULT 1,parent INTEGER,position INTEGER NOT NULL,keyword TEXT,description TEXT,tags TEXT,favicon_id INTEGER,created INTEGER,modified INTEGER,guid TEXT NOT NULL,deleted INTEGER NOT NULL DEFAULT 0" + (string2 != null ? string2 : "") + ");");
        sQLiteDatabase.execSQL("CREATE INDEX bookmarks_url_index ON bookmarks(url)");
        sQLiteDatabase.execSQL("CREATE INDEX bookmarks_type_deleted_index ON bookmarks(type, deleted)");
        sQLiteDatabase.execSQL("CREATE UNIQUE INDEX bookmarks_guid_index ON bookmarks(guid)");
        sQLiteDatabase.execSQL("CREATE INDEX bookmarks_modified_index ON bookmarks(modified)");
    }

    private void createHistoryTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating history table");
        sQLiteDatabase.execSQL("CREATE TABLE history(_id INTEGER PRIMARY KEY AUTOINCREMENT,title TEXT,url TEXT NOT NULL,visits INTEGER NOT NULL DEFAULT 0,date INTEGER,created INTEGER,modified INTEGER,guid TEXT NOT NULL,deleted INTEGER NOT NULL DEFAULT 0);");
        sQLiteDatabase.execSQL("CREATE INDEX history_url_index ON history(url)");
        sQLiteDatabase.execSQL("CREATE UNIQUE INDEX history_guid_index ON history(guid)");
        sQLiteDatabase.execSQL("CREATE INDEX history_modified_index ON history(modified)");
        sQLiteDatabase.execSQL("CREATE INDEX history_visited_index ON history(date)");
    }

    private void createHistoryTableOn13(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating history table");
        sQLiteDatabase.execSQL("CREATE TABLE history(_id INTEGER PRIMARY KEY AUTOINCREMENT,title TEXT,url TEXT NOT NULL,visits INTEGER NOT NULL DEFAULT 0,favicon_id INTEGER,date INTEGER,created INTEGER,modified INTEGER,guid TEXT NOT NULL,deleted INTEGER NOT NULL DEFAULT 0);");
        sQLiteDatabase.execSQL("CREATE INDEX history_url_index ON history(url)");
        sQLiteDatabase.execSQL("CREATE UNIQUE INDEX history_guid_index ON history(guid)");
        sQLiteDatabase.execSQL("CREATE INDEX history_modified_index ON history(modified)");
        sQLiteDatabase.execSQL("CREATE INDEX history_visited_index ON history(date)");
    }

    private void createImagesTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating images table");
        sQLiteDatabase.execSQL("CREATE TABLE images (_id INTEGER PRIMARY KEY AUTOINCREMENT,url_key TEXT UNIQUE NOT NULL,favicon BLOB,favicon_url TEXT,thumbnail BLOB,created INTEGER,modified INTEGER,guid TEXT NOT NULL,deleted INTEGER NOT NULL DEFAULT 0);");
        sQLiteDatabase.execSQL("CREATE INDEX images_url_index ON images(url_key)");
        sQLiteDatabase.execSQL("CREATE UNIQUE INDEX images_guid_index ON images(guid)");
        sQLiteDatabase.execSQL("CREATE INDEX images_modified_index ON images(modified)");
    }

    private void createFaviconsTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating favicons table");
        sQLiteDatabase.execSQL("CREATE TABLE favicons (_id INTEGER PRIMARY KEY AUTOINCREMENT,url TEXT UNIQUE,data BLOB,created INTEGER,modified INTEGER);");
        sQLiteDatabase.execSQL("CREATE INDEX favicons_url_index ON favicons(url)");
        sQLiteDatabase.execSQL("CREATE INDEX favicons_modified_index ON favicons(modified)");
    }

    private void createThumbnailsTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating thumbnails table");
        sQLiteDatabase.execSQL("CREATE TABLE thumbnails (_id INTEGER PRIMARY KEY AUTOINCREMENT,url TEXT UNIQUE,data BLOB);");
        sQLiteDatabase.execSQL("CREATE INDEX thumbnails_url_index ON thumbnails(url)");
    }

    private void createBookmarksWithImagesView(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating bookmarks_with_images view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS bookmarks_with_images AS SELECT " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "*") + ", " + "favicon" + ", " + "thumbnail" + " FROM " + "bookmarks LEFT OUTER JOIN images ON bookmarks.url = images.url_key");
    }

    private void createBookmarksWithFaviconsView(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating bookmarks_with_favicons view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS bookmarks_with_favicons AS SELECT " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "*") + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_FAVICONS, "data") + " AS " + "favicon" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_FAVICONS, "url") + " AS " + "favicon_url" + " FROM " + TABLE_BOOKMARKS_JOIN_FAVICONS);
    }

    private void createHistoryWithImagesView(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating history_with_images view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS history_with_images AS SELECT " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "*") + ", " + "favicon" + ", " + "thumbnail" + " FROM " + "history LEFT OUTER JOIN images ON bookmarks.url = images.url_key");
    }

    private void createHistoryWithFaviconsView(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating history_with_favicons view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS history_with_favicons AS SELECT " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "*") + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_FAVICONS, "data") + " AS " + "favicon" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_FAVICONS, "url") + " AS " + "favicon_url" + " FROM " + TABLE_HISTORY_JOIN_FAVICONS);
    }

    private void createCombinedWithImagesView(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating combined_with_images view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined_with_images AS SELECT bookmark_id, history_id, 0 AS _id, url, title, visits, date, " + BrowserDatabaseHelper.qualifyColumn("images", "favicon") + " AS " + "favicon" + ", " + BrowserDatabaseHelper.qualifyColumn("images", "thumbnail") + " AS " + "thumbnail" + " FROM (" + " SELECT " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " AS " + "url" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "title") + " AS " + "title" + ", " + "-1 AS " + "history_id" + ", " + "-1 AS " + "visits" + ", " + "-1 AS " + "date" + " FROM " + TABLE_BOOKMARKS + " WHERE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + " AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " = 0 AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " NOT IN (SELECT " + "url" + " FROM " + TABLE_HISTORY + ")" + " UNION ALL" + " SELECT " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " AS " + "url" + ", " + "COALESCE(" + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "title") + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "title") + ")" + " AS " + "title" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "_id") + " AS " + "history_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "visits") + " AS " + "visits" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "date") + " AS " + "date" + " FROM " + TABLE_HISTORY + " LEFT OUTER JOIN " + TABLE_BOOKMARKS + " ON " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " = " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " WHERE " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " IS NOT NULL AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "deleted") + " = 0 AND (" + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " IS NULL OR " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + ")" + ") LEFT OUTER JOIN " + "images" + " ON " + "url" + " = " + BrowserDatabaseHelper.qualifyColumn("images", "url_key"));
    }

    private void createCombinedWithImagesViewOn9(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating combined_with_images view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined_with_images AS SELECT bookmark_id, history_id, 0 AS _id, url, title, visits, display, date, " + BrowserDatabaseHelper.qualifyColumn("images", "favicon") + " AS " + "favicon" + ", " + BrowserDatabaseHelper.qualifyColumn("images", "thumbnail") + " AS " + "thumbnail" + " FROM (" + " SELECT " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " AS " + "url" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "title") + " AS " + "title" + ", " + "CASE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END AS " + "display" + ", " + "-1 AS " + "history_id" + ", " + "-1 AS " + "visits" + ", " + "-1 AS " + "date" + " FROM " + TABLE_BOOKMARKS + " WHERE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + " AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " = 0 AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " NOT IN (SELECT " + "url" + " FROM " + TABLE_HISTORY + ")" + " UNION ALL" + " SELECT " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " AS " + "url" + ", " + "COALESCE(" + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "title") + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "title") + ")" + " AS " + "title" + ", " + "CASE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END AS " + "display" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "_id") + " AS " + "history_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "visits") + " AS " + "visits" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "date") + " AS " + "date" + " FROM " + TABLE_HISTORY + " LEFT OUTER JOIN " + TABLE_BOOKMARKS + " ON " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " = " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " WHERE " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " IS NOT NULL AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "deleted") + " = 0 AND (" + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " IS NULL OR " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + ")" + ") LEFT OUTER JOIN " + "images" + " ON " + "url" + " = " + BrowserDatabaseHelper.qualifyColumn("images", "url_key"));
    }

    private void createCombinedWithImagesViewOn10(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating combined_with_images view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined_with_images AS SELECT bookmark_id, history_id, 0 AS _id, url, title, visits, display, date, " + BrowserDatabaseHelper.qualifyColumn("images", "favicon") + " AS " + "favicon" + ", " + BrowserDatabaseHelper.qualifyColumn("images", "thumbnail") + " AS " + "thumbnail" + " FROM (" + " SELECT " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " AS " + "url" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "title") + " AS " + "title" + ", " + "CASE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END AS " + "display" + ", " + "-1 AS " + "history_id" + ", " + "-1 AS " + "visits" + ", " + "-1 AS " + "date" + " FROM " + TABLE_BOOKMARKS + " WHERE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + " AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " = 0 AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " NOT IN (SELECT " + "url" + " FROM " + TABLE_HISTORY + ")" + " UNION ALL" + " SELECT " + "CASE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "_id") + " ELSE NULL END AS " + "bookmark_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " AS " + "url" + ", " + "COALESCE(" + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "title") + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "title") + ")" + " AS " + "title" + ", " + "CASE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END AS " + "display" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "_id") + " AS " + "history_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "visits") + " AS " + "visits" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "date") + " AS " + "date" + " FROM " + TABLE_HISTORY + " LEFT OUTER JOIN " + TABLE_BOOKMARKS + " ON " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " = " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " WHERE " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " IS NOT NULL AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "deleted") + " = 0 AND (" + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " IS NULL OR " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + ")" + ") LEFT OUTER JOIN " + "images" + " ON " + "url" + " = " + BrowserDatabaseHelper.qualifyColumn("images", "url_key"));
    }

    private void createCombinedWithImagesViewOn11(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating combined_with_images view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined_with_images AS SELECT bookmark_id, history_id, 0 AS _id, url, title, visits, display, date, " + BrowserDatabaseHelper.qualifyColumn("images", "favicon") + " AS " + "favicon" + ", " + BrowserDatabaseHelper.qualifyColumn("images", "thumbnail") + " AS " + "thumbnail" + " FROM (" + " SELECT " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " AS " + "url" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "title") + " AS " + "title" + ", " + "CASE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END AS " + "display" + ", " + "-1 AS " + "history_id" + ", " + "-1 AS " + "visits" + ", " + "-1 AS " + "date" + " FROM " + TABLE_BOOKMARKS + " WHERE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + " AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " = 0 AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " NOT IN (SELECT " + "url" + " FROM " + TABLE_HISTORY + ")" + " UNION ALL" + " SELECT " + "CASE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "_id") + " ELSE NULL END AS " + "bookmark_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " AS " + "url" + ", " + "COALESCE(" + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "title") + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "title") + ")" + " AS " + "title" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "_id") + " AS " + "history_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "visits") + " AS " + "visits" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "date") + " AS " + "date" + " FROM " + TABLE_HISTORY + " LEFT OUTER JOIN " + TABLE_BOOKMARKS + " ON " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " = " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " WHERE " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " IS NOT NULL AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "deleted") + " = 0 AND (" + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " IS NULL OR " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + ") " + ") LEFT OUTER JOIN " + "images" + " ON " + "url" + " = " + BrowserDatabaseHelper.qualifyColumn("images", "url_key"));
    }

    private void createCombinedViewOn12(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating combined view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined AS SELECT bookmark_id, history_id, 0 AS _id, url, title, visits, display, date FROM ( SELECT " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " AS " + "url" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "title") + " AS " + "title" + ", " + "CASE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END AS " + "display" + ", " + "-1 AS " + "history_id" + ", " + "-1 AS " + "visits" + ", " + "-1 AS " + "date" + " FROM " + TABLE_BOOKMARKS + " WHERE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + " AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " = 0 AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " NOT IN (SELECT " + "url" + " FROM " + TABLE_HISTORY + ")" + " UNION ALL" + " SELECT " + "CASE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "_id") + " ELSE NULL END AS " + "bookmark_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " AS " + "url" + ", " + "COALESCE(" + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "title") + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "title") + ")" + " AS " + "title" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "_id") + " AS " + "history_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "visits") + " AS " + "visits" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "date") + " AS " + "date" + " FROM " + TABLE_HISTORY + " LEFT OUTER JOIN " + TABLE_BOOKMARKS + " ON " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " = " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " WHERE " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " IS NOT NULL AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "deleted") + " = 0 AND (" + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " IS NULL OR " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + ") " + ")");
        BrowserDatabaseHelper.debug("Creating combined_with_images view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined_with_images AS SELECT *, " + BrowserDatabaseHelper.qualifyColumn("images", "favicon") + " AS " + "favicon" + ", " + BrowserDatabaseHelper.qualifyColumn("images", "thumbnail") + " AS " + "thumbnail" + " FROM " + VIEW_COMBINED + " LEFT OUTER JOIN " + "images" + " ON " + "url" + " = " + BrowserDatabaseHelper.qualifyColumn("images", "url_key"));
    }

    private void createCombinedViewOn13(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating combined view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined AS SELECT bookmark_id, history_id, 0 AS _id, url, title, visits, display, date, favicon_id FROM ( SELECT " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " AS " + "url" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "title") + " AS " + "title" + ", " + "CASE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END AS " + "display" + ", " + "-1 AS " + "history_id" + ", " + "-1 AS " + "visits" + ", " + "-1 AS " + "date" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "favicon_id") + " AS " + "favicon_id" + " FROM " + TABLE_BOOKMARKS + " WHERE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + " AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " = 0 AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " NOT IN (SELECT " + "url" + " FROM " + TABLE_HISTORY + ")" + " UNION ALL" + " SELECT " + "CASE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "_id") + " ELSE NULL END AS " + "bookmark_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " AS " + "url" + ", " + "COALESCE(" + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "title") + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "title") + ")" + " AS " + "title" + ", " + "CASE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN CASE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "parent") + " WHEN " + -2 + " THEN " + 1 + " ELSE " + 0 + " END ELSE " + 0 + " END AS " + "display" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "_id") + " AS " + "history_id" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "visits") + " AS " + "visits" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "date") + " AS " + "date" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "favicon_id") + " AS " + "favicon_id" + " FROM " + TABLE_HISTORY + " LEFT OUTER JOIN " + TABLE_BOOKMARKS + " ON " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " = " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " WHERE " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " IS NOT NULL AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "deleted") + " = 0 AND (" + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " IS NULL OR " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + ") " + ")");
        BrowserDatabaseHelper.debug("Creating combined_with_favicons view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined_with_favicons AS SELECT " + BrowserDatabaseHelper.qualifyColumn(VIEW_COMBINED, "*") + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_FAVICONS, "url") + " AS " + "favicon_url" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_FAVICONS, "data") + " AS " + "favicon" + " FROM " + VIEW_COMBINED + " LEFT OUTER JOIN " + TABLE_FAVICONS + " ON " + "favicon_id" + " = " + BrowserDatabaseHelper.qualifyColumn(TABLE_FAVICONS, "_id"));
    }

    private void createCombinedViewOn19(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined AS SELECT " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "_id") + " AS " + "bookmark_id" + "," + "-1 AS " + "history_id" + "," + "0 AS " + "_id" + "," + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " AS " + "url" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "title") + " AS " + "title" + ", " + "-1 AS " + "visits" + ", " + "-1 AS " + "date" + "," + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "favicon_id") + " AS " + "favicon_id" + " FROM " + TABLE_BOOKMARKS + " WHERE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + " AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "parent") + " <> " + -3 + " AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " = 0 AND " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " NOT IN (SELECT " + "url" + " FROM " + TABLE_HISTORY + ")" + " UNION ALL" + " SELECT " + "CASE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "deleted") + " WHEN 0 THEN " + "CASE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "parent") + " WHEN " + -3 + " THEN " + "NULL " + "ELSE " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "_id") + " END " + "ELSE " + "NULL " + "END AS " + "bookmark_id" + "," + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "_id") + " AS " + "history_id" + "," + "0 AS " + "_id" + "," + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " AS " + "url" + "," + "COALESCE(" + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "title") + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "title") + ") AS " + "title" + "," + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "visits") + " AS " + "visits" + "," + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "date") + " AS " + "date" + "," + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "favicon_id") + " AS " + "favicon_id" + " FROM " + TABLE_HISTORY + " LEFT OUTER JOIN " + TABLE_BOOKMARKS + " ON " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "url") + " = " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url") + " WHERE " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "deleted") + " = 0 AND " + "(" + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " IS NULL OR " + BrowserDatabaseHelper.qualifyColumn(TABLE_BOOKMARKS, "type") + " = " + 1 + ")");
        BrowserDatabaseHelper.debug("Creating combined_with_favicons view");
        sQLiteDatabase.execSQL("CREATE VIEW IF NOT EXISTS combined_with_favicons AS SELECT " + BrowserDatabaseHelper.qualifyColumn(VIEW_COMBINED, "*") + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_FAVICONS, "url") + " AS " + "favicon_url" + ", " + BrowserDatabaseHelper.qualifyColumn(TABLE_FAVICONS, "data") + " AS " + "favicon" + " FROM " + VIEW_COMBINED + " LEFT OUTER JOIN " + TABLE_FAVICONS + " ON " + "favicon_id" + " = " + BrowserDatabaseHelper.qualifyColumn(TABLE_FAVICONS, "_id"));
    }

    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating browser.db: " + sQLiteDatabase.getPath());
        this.createBookmarksTableOn13(sQLiteDatabase);
        this.createHistoryTableOn13(sQLiteDatabase);
        this.createFaviconsTable(sQLiteDatabase);
        this.createThumbnailsTable(sQLiteDatabase);
        this.createBookmarksWithFaviconsView(sQLiteDatabase);
        this.createHistoryWithFaviconsView(sQLiteDatabase);
        this.createCombinedViewOn19(sQLiteDatabase);
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "places", R.string.bookmarks_folder_places, 0);
        this.createOrUpdateAllSpecialFolders(sQLiteDatabase);
        this.createReadingListTable(sQLiteDatabase);
        this.createSearchHistoryTable(sQLiteDatabase);
    }

    private void createSearchHistoryTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating searchhistory table");
        sQLiteDatabase.execSQL("CREATE TABLE searchhistory(_id INTEGER PRIMARY KEY AUTOINCREMENT, query TEXT UNIQUE NOT NULL, date INTEGER, visits INTEGER ) ");
        sQLiteDatabase.execSQL("CREATE INDEX idx_search_history_last_visited ON searchhistory(date)");
    }

    private void createReadingListTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Creating reading_list table");
        sQLiteDatabase.execSQL("CREATE TABLE reading_list(_id INTEGER PRIMARY KEY AUTOINCREMENT, url TEXT NOT NULL, title TEXT, excerpt TEXT, read TINYINT DEFAULT 0, deleted TINYINT DEFAULT 0, guid TEXT UNIQUE NOT NULL, modified INTEGER NOT NULL, created INTEGER NOT NULL, length INTEGER DEFAULT 0 ); ");
        sQLiteDatabase.execSQL("CREATE INDEX reading_list_url ON reading_list(url)");
        sQLiteDatabase.execSQL("CREATE UNIQUE INDEX reading_list_guid ON reading_list(guid)");
    }

    private void createOrUpdateAllSpecialFolders(SQLiteDatabase sQLiteDatabase) {
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "mobile", R.string.bookmarks_folder_mobile, 0);
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "toolbar", R.string.bookmarks_folder_toolbar, 1);
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "menu", R.string.bookmarks_folder_menu, 2);
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "tags", R.string.bookmarks_folder_tags, 3);
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "unfiled", R.string.bookmarks_folder_unfiled, 4);
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "readinglist", R.string.bookmarks_folder_reading_list, 5);
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "pinned", R.string.bookmarks_folder_pinned, 6);
    }

    private void createOrUpdateSpecialFolder(SQLiteDatabase sQLiteDatabase, String string2, int n, int n2) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("guid", string2);
        contentValues.put("type", Integer.valueOf(0));
        contentValues.put("position", Integer.valueOf(n2));
        if (string2.equals("places")) {
            contentValues.put("_id", Integer.valueOf(0));
        } else if (string2.equals("readinglist")) {
            contentValues.put("_id", Integer.valueOf(-2));
        } else if (string2.equals("pinned")) {
            contentValues.put("_id", Integer.valueOf(-3));
        }
        contentValues.put("parent", Integer.valueOf(0));
        String string3 = this.mContext.getResources().getString(n);
        contentValues.put("title", string3);
        long l = System.currentTimeMillis();
        contentValues.put("created", Long.valueOf(l));
        contentValues.put("modified", Long.valueOf(l));
        int n3 = sQLiteDatabase.update(TABLE_BOOKMARKS, contentValues, "guid = ?", new String[]{string2});
        if (n3 == 0) {
            sQLiteDatabase.insert(TABLE_BOOKMARKS, "guid", contentValues);
            BrowserDatabaseHelper.debug("Inserted special folder: " + string2);
        } else {
            BrowserDatabaseHelper.debug("Updated special folder: " + string2);
        }
    }

    private boolean isSpecialFolder(ContentValues contentValues) {
        String string2 = contentValues.getAsString("guid");
        if (string2 == null) {
            return false;
        }
        return string2.equals("mobile") || string2.equals("menu") || string2.equals("toolbar") || string2.equals("unfiled") || string2.equals("tags");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateBookmarkFolder(SQLiteDatabase sQLiteDatabase, int n, BookmarkMigrator bookmarkMigrator) {
        boolean bl;
        Cursor cursor = null;
        BrowserDatabaseHelper.debug("Migrating bookmark folder with id = " + n);
        String string2 = "parent = " + n;
        String[] stringArray = null;
        boolean bl2 = bl = n == 0;
        if (bl) {
            string2 = "guid != ? AND (" + string2 + " OR " + "parent" + " = NULL)";
            stringArray = new String[]{"places"};
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<ContentValues> arrayList2 = new ArrayList<ContentValues>();
        try {
            cursor = sQLiteDatabase.query(TABLE_BOOKMARKS_TMP, null, string2, stringArray, null, null, null);
            while (cursor.moveToNext()) {
                ContentValues contentValues = new ContentValues();
                DatabaseUtils.cursorRowToContentValues((Cursor)cursor, (ContentValues)contentValues);
                boolean bl3 = this.isSpecialFolder(contentValues);
                if (contentValues.getAsLong("parent") == null && bl3) {
                    contentValues.put("parent", Integer.valueOf(0));
                }
                if (bl && !bl3) {
                    arrayList2.add(contentValues);
                    continue;
                }
                if (bookmarkMigrator != null) {
                    bookmarkMigrator.updateForNewTable(contentValues);
                }
                BrowserDatabaseHelper.debug("Migrating bookmark: " + contentValues.getAsString("title"));
                sQLiteDatabase.insert(TABLE_BOOKMARKS, "url", contentValues);
                Integer n2 = contentValues.getAsInteger("type");
                if (n2 == null || n2 != 0) continue;
                arrayList.add(contentValues.getAsInteger("_id"));
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        int n3 = arrayList2.size();
        if (n3 > 0) {
            Integer n4 = this.getMobileFolderId(sQLiteDatabase);
            if (n4 == null) {
                Log.e((String)LOGTAG, (String)"Error migrating invalid special folder entries: mobile folder id is null");
                return;
            }
            BrowserDatabaseHelper.debug("Found " + n3 + " invalid special folder entries");
            for (int i = 0; i < n3; ++i) {
                ContentValues contentValues = (ContentValues)arrayList2.get(i);
                contentValues.put("parent", n4);
                sQLiteDatabase.insert(TABLE_BOOKMARKS, "url", contentValues);
            }
        }
        int n5 = arrayList.size();
        for (int i = 0; i < n5; ++i) {
            int n6 = (Integer)arrayList.get(i);
            this.migrateBookmarkFolder(sQLiteDatabase, n6, bookmarkMigrator);
        }
    }

    private void migrateBookmarksTable(SQLiteDatabase sQLiteDatabase) {
        this.migrateBookmarksTable(sQLiteDatabase, null);
    }

    private void migrateBookmarksTable(SQLiteDatabase sQLiteDatabase, BookmarkMigrator bookmarkMigrator) {
        BrowserDatabaseHelper.debug("Renaming bookmarks table to bookmarks_tmp");
        sQLiteDatabase.execSQL("ALTER TABLE bookmarks RENAME TO bookmarks_tmp");
        BrowserDatabaseHelper.debug("Dropping views and indexes related to bookmarks");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS bookmarks_with_images");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS bookmarks_url_index");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS bookmarks_type_deleted_index");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS bookmarks_guid_index");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS bookmarks_modified_index");
        this.createBookmarksTable(sQLiteDatabase);
        this.createBookmarksWithImagesView(sQLiteDatabase);
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "places", R.string.bookmarks_folder_places, 0);
        this.migrateBookmarkFolder(sQLiteDatabase, 0, bookmarkMigrator);
        this.createOrUpdateAllSpecialFolders(sQLiteDatabase);
        BrowserDatabaseHelper.debug("Dropping bookmarks temporary table");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS bookmarks_tmp");
    }

    private void migrateHistoryTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Renaming history table to history_tmp");
        sQLiteDatabase.execSQL("ALTER TABLE history RENAME TO history_tmp");
        BrowserDatabaseHelper.debug("Dropping views and indexes related to history");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS history_with_images");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS history_url_index");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS history_guid_index");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS history_modified_index");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS history_visited_index");
        this.createHistoryTable(sQLiteDatabase);
        this.createHistoryWithImagesView(sQLiteDatabase);
        this.createCombinedWithImagesView(sQLiteDatabase);
        sQLiteDatabase.execSQL("INSERT INTO history SELECT * FROM history_tmp");
        BrowserDatabaseHelper.debug("Dropping history temporary table");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS history_tmp");
    }

    private void migrateImagesTable(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Renaming images table to images_tmp");
        sQLiteDatabase.execSQL("ALTER TABLE images RENAME TO images_tmp");
        BrowserDatabaseHelper.debug("Dropping views and indexes related to images");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS history_with_images");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS images_url_index");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS images_guid_index");
        sQLiteDatabase.execSQL("DROP INDEX IF EXISTS images_modified_index");
        this.createImagesTable(sQLiteDatabase);
        this.createHistoryWithImagesView(sQLiteDatabase);
        this.createCombinedWithImagesView(sQLiteDatabase);
        sQLiteDatabase.execSQL("INSERT INTO images SELECT * FROM images_tmp");
        BrowserDatabaseHelper.debug("Dropping images temporary table");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS images_tmp");
    }

    private void upgradeDatabaseFrom1to2(SQLiteDatabase sQLiteDatabase) {
        this.migrateBookmarksTable(sQLiteDatabase);
    }

    private void upgradeDatabaseFrom2to3(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Dropping view: bookmarks_with_images");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS bookmarks_with_images");
        this.createBookmarksWithImagesView(sQLiteDatabase);
        BrowserDatabaseHelper.debug("Dropping view: history_with_images");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS history_with_images");
        this.createHistoryWithImagesView(sQLiteDatabase);
    }

    private void upgradeDatabaseFrom3to4(SQLiteDatabase sQLiteDatabase) {
        this.migrateBookmarksTable(sQLiteDatabase, new BookmarkMigrator3to4());
    }

    private void upgradeDatabaseFrom4to5(SQLiteDatabase sQLiteDatabase) {
        this.createCombinedWithImagesView(sQLiteDatabase);
    }

    private void upgradeDatabaseFrom5to6(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Dropping view: combined_with_images");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
        this.createCombinedWithImagesView(sQLiteDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeDatabaseFrom6to7(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Removing history visits with NULL GUIDs");
        sQLiteDatabase.execSQL("DELETE FROM history WHERE guid IS NULL");
        BrowserDatabaseHelper.debug("Update images with NULL GUIDs");
        String[] stringArray = new String[]{"_id"};
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query("images", stringArray, "guid IS NULL", null, null, null, null, null);
            ContentValues contentValues = new ContentValues();
            if (cursor.moveToFirst()) {
                do {
                    contentValues.put("guid", Utils.generateGuid());
                    sQLiteDatabase.update("images", contentValues, "_id = ?", new String[]{cursor.getString(cursor.getColumnIndexOrThrow("_id"))});
                } while (cursor.moveToNext());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        this.migrateBookmarksTable(sQLiteDatabase);
        this.migrateHistoryTable(sQLiteDatabase);
        this.migrateImagesTable(sQLiteDatabase);
    }

    private void upgradeDatabaseFrom7to8(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Combining history entries with the same URL");
        sQLiteDatabase.execSQL("CREATE TEMP TABLE duped_urls AS SELECT url, SUM(visits) AS total, MAX(modified) AS latest, MAX(_id) AS winner FROM history GROUP BY url HAVING count(url) > 1");
        sQLiteDatabase.execSQL("CREATE UNIQUE INDEX duped_urls_url_index ON duped_urls (url)");
        String string2 = " FROM duped_urls WHERE " + BrowserDatabaseHelper.qualifyColumn("duped_urls", "url") + " = " + BrowserDatabaseHelper.qualifyColumn(TABLE_HISTORY, "url");
        sQLiteDatabase.execSQL("UPDATE history SET visits = (SELECT total" + string2 + "), " + "modified" + " = (SELECT " + "latest" + string2 + "), " + "deleted" + " = " + "(" + "_id" + " <> (SELECT " + "winner" + string2 + "))" + " WHERE " + "url" + " IN (SELECT " + "url" + " FROM " + "duped_urls" + ")");
        sQLiteDatabase.execSQL("DROP TABLE duped_urls");
    }

    private void upgradeDatabaseFrom8to9(SQLiteDatabase sQLiteDatabase) {
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "readinglist", R.string.bookmarks_folder_reading_list, 5);
        BrowserDatabaseHelper.debug("Dropping view: combined_with_images");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
        this.createCombinedWithImagesViewOn9(sQLiteDatabase);
    }

    private void upgradeDatabaseFrom9to10(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Dropping view: combined_with_images");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
        this.createCombinedWithImagesViewOn10(sQLiteDatabase);
    }

    private void upgradeDatabaseFrom10to11(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Dropping view: combined_with_images");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
        sQLiteDatabase.execSQL("CREATE INDEX bookmarks_type_deleted_index ON bookmarks(type, deleted)");
        this.createCombinedWithImagesViewOn11(sQLiteDatabase);
    }

    private void upgradeDatabaseFrom11to12(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Dropping view: combined_with_images");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
        this.createCombinedViewOn12(sQLiteDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeDatabaseFrom12to13(SQLiteDatabase sQLiteDatabase) {
        String[] stringArray;
        String string2;
        SQLiteDatabase sQLiteDatabase2 = null;
        Cursor cursor = null;
        try {
            string2 = this.mContext.getDatabasePath("favicon_urls.db").getPath();
            sQLiteDatabase2 = SQLiteDatabase.openDatabase((String)string2, null, (int)1);
            stringArray = new String[]{"favicon_url", "page_url"};
            cursor = sQLiteDatabase2.query("favicon_urls", stringArray, null, null, null, null, null, null);
            int n = cursor.getColumnIndexOrThrow("favicon_url");
            int n2 = cursor.getColumnIndexOrThrow("page_url");
            while (cursor.moveToNext()) {
                ContentValues contentValues = new ContentValues(1);
                String string3 = cursor.getString(n);
                String string4 = cursor.getString(n2);
                contentValues.put("favicon_url", string3);
                sQLiteDatabase.update("images", contentValues, "url_key = ?", new String[]{string4});
            }
        }
        catch (SQLException sQLException) {
            Log.e((String)LOGTAG, (String)"Exception importing from favicon_urls.db", (Throwable)sQLException);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (sQLiteDatabase2 != null) {
                sQLiteDatabase2.close();
            }
        }
        this.createFaviconsTable(sQLiteDatabase);
        sQLiteDatabase.execSQL("ALTER TABLE history ADD COLUMN favicon_id INTEGER");
        sQLiteDatabase.execSQL("ALTER TABLE bookmarks ADD COLUMN favicon_id INTEGER");
        try {
            cursor = sQLiteDatabase.query("images", new String[]{"url_key", "favicon_url", "favicon", "modified", "created"}, "favicon IS NOT NULL", null, null, null, null);
            while (cursor.moveToNext()) {
                long l = -1L;
                int n = cursor.getColumnIndexOrThrow("favicon_url");
                string2 = null;
                if (!cursor.isNull(n)) {
                    string2 = cursor.getString(n);
                    stringArray = null;
                    try {
                        stringArray = sQLiteDatabase.query(TABLE_FAVICONS, new String[]{"_id"}, "url = ?", new String[]{string2}, null, null, null);
                        if (stringArray.moveToFirst()) {
                            l = stringArray.getLong(stringArray.getColumnIndexOrThrow("_id"));
                        }
                    }
                    finally {
                        if (stringArray != null) {
                            stringArray.close();
                        }
                    }
                }
                if (l == -1L) {
                    stringArray = new ContentValues(4);
                    stringArray.put("url", string2);
                    stringArray.put("data", cursor.getBlob(cursor.getColumnIndexOrThrow("favicon")));
                    stringArray.put("modified", Long.valueOf(cursor.getLong(cursor.getColumnIndexOrThrow("modified"))));
                    stringArray.put("created", Long.valueOf(cursor.getLong(cursor.getColumnIndexOrThrow("created"))));
                    l = sQLiteDatabase.insert(TABLE_FAVICONS, null, (ContentValues)stringArray);
                }
                stringArray = new ContentValues(1);
                stringArray.put("favicon_id", Long.valueOf(l));
                sQLiteDatabase.update(TABLE_HISTORY, (ContentValues)stringArray, "url = ?", new String[]{cursor.getString(cursor.getColumnIndexOrThrow("url_key"))});
                sQLiteDatabase.update(TABLE_BOOKMARKS, (ContentValues)stringArray, "url = ?", new String[]{cursor.getString(cursor.getColumnIndexOrThrow("url_key"))});
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        this.createThumbnailsTable(sQLiteDatabase);
        sQLiteDatabase.execSQL("INSERT INTO thumbnails (url, data) SELECT url_key, thumbnail FROM images WHERE thumbnail IS NOT NULL");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS bookmarks_with_images");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS history_with_images");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_images");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined");
        this.createBookmarksWithFaviconsView(sQLiteDatabase);
        this.createHistoryWithFaviconsView(sQLiteDatabase);
        this.createCombinedViewOn13(sQLiteDatabase);
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS images");
    }

    private void upgradeDatabaseFrom13to14(SQLiteDatabase sQLiteDatabase) {
        this.createOrUpdateSpecialFolder(sQLiteDatabase, "pinned", R.string.bookmarks_folder_pinned, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeDatabaseFrom14to15(SQLiteDatabase sQLiteDatabase) {
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query(TABLE_BOOKMARKS, new String[]{"_id", "url"}, "parent = ?", new String[]{Integer.toString(-3)}, null, null, null);
            while (cursor.moveToNext()) {
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                if (Uri.parse((String)string2).getScheme() != null) continue;
                ContentValues contentValues = new ContentValues(1);
                String string3 = Uri.fromParts((String)"user-entered", (String)string2, null).toString();
                contentValues.put("url", string3);
                sQLiteDatabase.update(TABLE_BOOKMARKS, contentValues, "_id = ?", new String[]{Integer.toString(cursor.getInt(cursor.getColumnIndexOrThrow("_id")))});
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    private void upgradeDatabaseFrom15to16(SQLiteDatabase sQLiteDatabase) {
        this.createV19CombinedView(sQLiteDatabase);
    }

    private void upgradeDatabaseFrom16to17(SQLiteDatabase sQLiteDatabase) {
        try {
            sQLiteDatabase.execSQL("DELETE FROM favicons WHERE length(data) = 0");
            sQLiteDatabase.execSQL("DELETE FROM thumbnails WHERE length(data) = 0");
        }
        catch (SQLException sQLException) {
            Log.e((String)LOGTAG, (String)"Error purging invalid favicons or thumbnails", (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeDatabaseFrom17to18(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Moving reading list items from 'bookmarks' table to 'reading_list' table");
        String[] stringArray = new String[]{String.valueOf(-2), "0"};
        String[] stringArray2 = new String[]{"_id", "guid", "url", "modified", "created", "title"};
        Cursor cursor = null;
        try {
            sQLiteDatabase.beginTransaction();
            this.createReadingListTable(sQLiteDatabase);
            cursor = sQLiteDatabase.query(TABLE_BOOKMARKS, stringArray2, "parent = ? AND deleted = ? ", stringArray, null, null, null);
            while (cursor.moveToNext()) {
                BrowserDatabaseHelper.debug(DatabaseUtils.dumpCurrentRowToString((Cursor)cursor));
                ContentValues contentValues = new ContentValues();
                DatabaseUtils.cursorStringToContentValues((Cursor)cursor, (String)"url", (ContentValues)contentValues, (String)"url");
                DatabaseUtils.cursorStringToContentValues((Cursor)cursor, (String)"guid", (ContentValues)contentValues, (String)"guid");
                DatabaseUtils.cursorStringToContentValues((Cursor)cursor, (String)"title", (ContentValues)contentValues, (String)"title");
                DatabaseUtils.cursorLongToContentValues((Cursor)cursor, (String)"created", (ContentValues)contentValues, (String)"created");
                DatabaseUtils.cursorLongToContentValues((Cursor)cursor, (String)"modified", (ContentValues)contentValues, (String)"modified");
                sQLiteDatabase.insertOrThrow(TABLE_READING_LIST, null, contentValues);
            }
            sQLiteDatabase.delete(TABLE_BOOKMARKS, "parent = ? ", new String[]{String.valueOf(-2)});
            sQLiteDatabase.delete(TABLE_BOOKMARKS, "_id = ? ", new String[]{String.valueOf(-2)});
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLException sQLException) {
            Log.e((String)LOGTAG, (String)"Error migrating reading list items", (Throwable)sQLException);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            sQLiteDatabase.endTransaction();
        }
    }

    private void upgradeDatabaseFrom18to19(SQLiteDatabase sQLiteDatabase) {
        this.createV19CombinedView(sQLiteDatabase);
        sQLiteDatabase.execSQL("DELETE FROM history WHERE url IS NULL");
        sQLiteDatabase.execSQL("UPDATE bookmarks SET type = 1 WHERE type IS NULL");
    }

    private void upgradeDatabaseFrom19to20(SQLiteDatabase sQLiteDatabase) {
        this.createSearchHistoryTable(sQLiteDatabase);
    }

    private void createV19CombinedView(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined");
        sQLiteDatabase.execSQL("DROP VIEW IF EXISTS combined_with_favicons");
        this.createCombinedViewOn19(sQLiteDatabase);
    }

    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        BrowserDatabaseHelper.debug("Upgrading browser.db: " + sQLiteDatabase.getPath() + " from " + n + " to " + n2);
        block21: for (int i = n + 1; i <= n2; ++i) {
            switch (i) {
                case 2: {
                    this.upgradeDatabaseFrom1to2(sQLiteDatabase);
                    continue block21;
                }
                case 3: {
                    this.upgradeDatabaseFrom2to3(sQLiteDatabase);
                    continue block21;
                }
                case 4: {
                    this.upgradeDatabaseFrom3to4(sQLiteDatabase);
                    continue block21;
                }
                case 5: {
                    this.upgradeDatabaseFrom4to5(sQLiteDatabase);
                    continue block21;
                }
                case 6: {
                    this.upgradeDatabaseFrom5to6(sQLiteDatabase);
                    continue block21;
                }
                case 7: {
                    this.upgradeDatabaseFrom6to7(sQLiteDatabase);
                    continue block21;
                }
                case 8: {
                    this.upgradeDatabaseFrom7to8(sQLiteDatabase);
                    continue block21;
                }
                case 9: {
                    this.upgradeDatabaseFrom8to9(sQLiteDatabase);
                    continue block21;
                }
                case 10: {
                    this.upgradeDatabaseFrom9to10(sQLiteDatabase);
                    continue block21;
                }
                case 11: {
                    this.upgradeDatabaseFrom10to11(sQLiteDatabase);
                    continue block21;
                }
                case 12: {
                    this.upgradeDatabaseFrom11to12(sQLiteDatabase);
                    continue block21;
                }
                case 13: {
                    this.upgradeDatabaseFrom12to13(sQLiteDatabase);
                    continue block21;
                }
                case 14: {
                    this.upgradeDatabaseFrom13to14(sQLiteDatabase);
                    continue block21;
                }
                case 15: {
                    this.upgradeDatabaseFrom14to15(sQLiteDatabase);
                    continue block21;
                }
                case 16: {
                    this.upgradeDatabaseFrom15to16(sQLiteDatabase);
                    continue block21;
                }
                case 17: {
                    this.upgradeDatabaseFrom16to17(sQLiteDatabase);
                    continue block21;
                }
                case 18: {
                    this.upgradeDatabaseFrom17to18(sQLiteDatabase);
                    continue block21;
                }
                case 19: {
                    this.upgradeDatabaseFrom18to19(sQLiteDatabase);
                    continue block21;
                }
                case 20: {
                    this.upgradeDatabaseFrom19to20(sQLiteDatabase);
                }
            }
        }
        if (n < 13 && n2 >= 13 && this.mContext.getDatabasePath("favicon_urls.db").exists() && !this.mContext.deleteDatabase("favicon_urls.db")) {
            throw new SQLException("Could not delete favicon_urls.db");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(SQLiteDatabase sQLiteDatabase) {
        BrowserDatabaseHelper.debug("Opening browser.db: " + sQLiteDatabase.getPath());
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.rawQuery("PRAGMA foreign_keys=ON", null);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        cursor = null;
        try {
            cursor = sQLiteDatabase.rawQuery("PRAGMA synchronous=NORMAL", null);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (Build.VERSION.SDK_INT >= 11) {
            if (Build.VERSION.SDK_INT < 16) {
                sQLiteDatabase.enableWriteAheadLogging();
                sQLiteDatabase.setLockingEnabled(false);
            }
        } else {
            cursor = null;
            try {
                cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=PERSIST", null);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    private static final String qualifyColumn(String string2, String string3) {
        return DBUtils.qualifyColumn(string2, string3);
    }

    protected static void trace(String string2) {
        if (logVerbose) {
            Log.v((String)LOGTAG, (String)string2);
        }
    }

    protected static void debug(String string2) {
        if (logDebug) {
            Log.d((String)LOGTAG, (String)string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getMobileFolderId(SQLiteDatabase sQLiteDatabase) {
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query(TABLE_BOOKMARKS, mobileIdColumns, "guid = ?", mobileIdSelectionArgs, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                Integer n = null;
                return n;
            }
            Integer n = cursor.getInt(cursor.getColumnIndex("_id"));
            return n;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    private class BookmarkMigrator3to4
    implements BookmarkMigrator {
        private BookmarkMigrator3to4() {
        }

        public void updateForNewTable(ContentValues contentValues) {
            Integer n = contentValues.getAsInteger("folder");
            if (n == null || n != 1) {
                contentValues.put("type", Integer.valueOf(1));
            } else {
                contentValues.put("type", Integer.valueOf(0));
            }
            contentValues.remove("folder");
        }
    }

    private static interface BookmarkMigrator {
        public void updateForNewTable(ContentValues var1);
    }
}

