/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentUris;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.text.TextUtils;
import org.mozilla.gecko.db.SharedBrowserDatabaseProvider;

public class SearchHistoryProvider
extends SharedBrowserDatabaseProvider {
    private static final String LOG_TAG = "GeckoSearchProvider";
    private static final boolean DEBUG_ENABLED = false;

    private String stripWhitespace(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        return string2.trim().replaceAll("\\s+", " ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri insertInTransaction(Uri uri, ContentValues contentValues) {
        String string2 = this.stripWhitespace(contentValues.getAsString("query"));
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        long l = -1L;
        try {
            contentValues.put("query", string2);
            contentValues.put("visits", Integer.valueOf(1));
            contentValues.put("date", Long.valueOf(System.currentTimeMillis()));
            l = sQLiteDatabase.insertOrThrow("searchhistory", null, contentValues);
            if (l > 0L) {
                return ContentUris.withAppendedId((Uri)uri, (long)l);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String string3 = "UPDATE searchhistory SET visits = visits + 1, date = " + System.currentTimeMillis() + " WHERE " + "query" + " = ?";
        Cursor cursor = sQLiteDatabase.rawQuery(string3, new String[]{string2});
        try {
            if (cursor.getCount() > 1) {
                Uri uri2 = null;
                return uri2;
            }
            if (cursor.moveToFirst()) {
                Uri uri3 = ContentUris.withAppendedId((Uri)uri, (long)cursor.getInt(cursor.getColumnIndex("_id")));
                return uri3;
            }
        }
        finally {
            cursor.close();
        }
        return null;
    }

    public int deleteInTransaction(Uri uri, String string2, String[] stringArray) {
        return this.getWritableDatabase(uri).delete("searchhistory", string2, stringArray);
    }

    public int updateInTransaction(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        throw new UnsupportedOperationException("This content provider does not support updating items");
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        String string4 = null;
        String string5 = null;
        return this.getReadableDatabase(uri).query("searchhistory", stringArray, string2, stringArray2, string4, string5, string3);
    }

    public String getType(Uri uri) {
        return "vnd.android.cursor.dir/searchhistory";
    }
}

