/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons;

import android.content.ContentResolver;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.http.AndroidHttpClient;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.favicons.decoders.FaviconDecoder;
import org.mozilla.gecko.favicons.decoders.LoadFaviconResult;
import org.mozilla.gecko.util.GeckoJarReader;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UiAsyncTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFaviconTask
extends UiAsyncTask<Void, Void, Bitmap> {
    private static final String LOGTAG = "LoadFaviconTask";
    private static final HashMap<String, LoadFaviconTask> loadsInFlight = new HashMap();
    public static final int FLAG_PERSIST = 1;
    public static final int FLAG_SCALE = 2;
    private static final int MAX_REDIRECTS_TO_FOLLOW = 5;
    private static final int DEFAULT_FAVICON_BUFFER_SIZE = 25000;
    private static AtomicInteger nextFaviconLoadId = new AtomicInteger(0);
    private int id = nextFaviconLoadId.incrementAndGet();
    private String pageUrl;
    private String faviconURL;
    private OnFaviconLoadedListener listener;
    private int flags;
    private final boolean onlyFromLocal;
    protected int targetWidth;
    private LinkedList<LoadFaviconTask> chainees;
    private boolean isChaining;
    static AndroidHttpClient httpClient = AndroidHttpClient.newInstance((String)GeckoAppShell.getGeckoInterface().getDefaultUAString());

    public LoadFaviconTask(Handler handler, String string2, String string3, int n, OnFaviconLoadedListener onFaviconLoadedListener) {
        this(handler, string2, string3, n, onFaviconLoadedListener, -1, false);
    }

    public LoadFaviconTask(Handler handler, String string2, String string3, int n, OnFaviconLoadedListener onFaviconLoadedListener, int n2, boolean bl) {
        super(handler);
        this.pageUrl = string2;
        this.faviconURL = string3;
        this.listener = onFaviconLoadedListener;
        this.flags = n;
        this.targetWidth = n2;
        this.onlyFromLocal = bl;
    }

    private LoadFaviconResult loadFaviconFromDb() {
        ContentResolver contentResolver = Favicons.context.getContentResolver();
        return BrowserDB.getFaviconForFaviconUrl(contentResolver, this.faviconURL);
    }

    private void saveFaviconToDb(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        if ((this.flags & 1) == 0) {
            return;
        }
        ContentResolver contentResolver = Favicons.context.getContentResolver();
        BrowserDB.updateFaviconForUrl(contentResolver, this.pageUrl, byArray, this.faviconURL);
    }

    private HttpResponse tryDownload(URI uRI) throws URISyntaxException, IOException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(uRI.toString());
        return this.tryDownloadRecurse(uRI, hashSet);
    }

    private HttpResponse tryDownloadRecurse(URI uRI, HashSet<String> hashSet) throws URISyntaxException, IOException {
        if (hashSet.size() == 5) {
            return null;
        }
        HttpGet httpGet = new HttpGet(uRI);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        if (httpResponse == null) {
            return null;
        }
        if (httpResponse.getStatusLine() != null) {
            int n = httpResponse.getStatusLine().getStatusCode();
            if (n >= 300 && n < 400) {
                Header header = httpResponse.getFirstHeader("Location");
                if (header == null) {
                    return null;
                }
                String string2 = header.getValue();
                if (string2 == null || string2.equals(uRI.toString())) {
                    return null;
                }
                if (hashSet.contains(string2)) {
                    return null;
                }
                hashSet.add(string2);
                return this.tryDownloadRecurse(new URI(string2), hashSet);
            }
            if (n >= 400) {
                return null;
            }
        }
        return httpResponse;
    }

    private static Bitmap fetchJARFavicon(String string2) {
        if (string2 == null) {
            return null;
        }
        if (string2.startsWith("jar:jar:")) {
            Log.d((String)LOGTAG, (String)"Fetching favicon from JAR.");
            try {
                return GeckoJarReader.getBitmap((Resources)Favicons.context.getResources(), (String)string2);
            }
            catch (Exception exception) {
                Log.w((String)LOGTAG, (String)"Error fetching favicon from JAR.", (Throwable)exception);
                return null;
            }
        }
        return null;
    }

    private LoadFaviconResult downloadFavicon(URI uRI) {
        if (uRI == null) {
            return null;
        }
        String string2 = uRI.getScheme();
        if (!"http".equals(string2) && !"https".equals(string2)) {
            return null;
        }
        LoadFaviconResult loadFaviconResult = null;
        try {
            loadFaviconResult = this.downloadAndDecodeImage(uRI);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error reading favicon", (Throwable)exception);
        }
        return loadFaviconResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadFaviconResult downloadAndDecodeImage(URI uRI) throws IOException, URISyntaxException {
        HttpResponse httpResponse = this.tryDownload(uRI);
        if (httpResponse == null) {
            return null;
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            return null;
        }
        long l = httpEntity.getContentLength();
        int n = l > 0L ? (int)l + 1 : 25000;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        InputStream inputStream = httpEntity.getContent();
        try {
            while (n3 != -1) {
                if ((n2 += (n3 = inputStream.read(byArray, n2, byArray.length - n2))) != byArray.length) continue;
                byte[] byArray2 = new byte[n *= 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
        }
        finally {
            inputStream.close();
        }
        return FaviconDecoder.decodeFavicon(byArray, 0, n2 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bitmap doInBackground(Void ... voidArray) {
        Object object;
        if (this.isCancelled()) {
            return null;
        }
        boolean bl = false;
        if (TextUtils.isEmpty((CharSequence)this.faviconURL)) {
            String string2 = Favicons.getFaviconURLForPageURLFromCache(this.pageUrl);
            if (string2 == null && (string2 = Favicons.getFaviconURLForPageURL(this.pageUrl)) != null) {
                Favicons.putFaviconURLForPageURLInCache(this.pageUrl, string2);
            }
            if (string2 != null) {
                this.faviconURL = string2;
            } else {
                this.faviconURL = Favicons.guessDefaultFaviconURL(this.pageUrl);
                if (TextUtils.isEmpty((CharSequence)this.faviconURL)) {
                    return null;
                }
                bl = true;
            }
        }
        if (Favicons.isFailedFavicon(this.faviconURL)) {
            return null;
        }
        if (this.isCancelled()) {
            return null;
        }
        Object object2 = loadsInFlight;
        synchronized (object2) {
            object = loadsInFlight.get(this.faviconURL);
            if (object != null && !object.isCancelled()) {
                object.chainTasks(this);
                this.isChaining = true;
                return null;
            }
            loadsInFlight.put(this.faviconURL, this);
        }
        if (this.isCancelled()) {
            return null;
        }
        object2 = this.loadFaviconFromDb();
        if (object2 != null) {
            return this.pushToCacheAndGetResult((LoadFaviconResult)object2);
        }
        if (this.onlyFromLocal || this.isCancelled()) {
            return null;
        }
        Bitmap bitmap = LoadFaviconTask.fetchJARFavicon(this.faviconURL);
        if (LoadFaviconTask.imageIsValid(bitmap)) {
            Favicons.putFaviconInMemCache(this.faviconURL, bitmap);
            return bitmap;
        }
        try {
            object2 = this.downloadFavicon(new URI(this.faviconURL));
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.e((String)LOGTAG, (String)"The provided favicon URL is not valid");
            return null;
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Couldn't download favicon.", (Throwable)exception);
        }
        if (object2 != null) {
            this.saveFaviconToDb(((LoadFaviconResult)object2).getBytesForDatabaseStorage());
            return this.pushToCacheAndGetResult((LoadFaviconResult)object2);
        }
        if (bl) {
            Favicons.putFaviconInFailedCache(this.faviconURL);
            return null;
        }
        if (this.isCancelled()) {
            return null;
        }
        object = Favicons.guessDefaultFaviconURL(this.pageUrl);
        if (object == null) {
            Favicons.putFaviconInFailedCache(this.faviconURL);
            return null;
        }
        bitmap = LoadFaviconTask.fetchJARFavicon((String)object);
        if (LoadFaviconTask.imageIsValid(bitmap)) {
            Favicons.putFaviconInMemCache(this.faviconURL, bitmap);
            return bitmap;
        }
        try {
            object2 = this.downloadFavicon(new URI((String)object));
        }
        catch (Exception exception) {
            return null;
        }
        if (object2 != null) {
            this.saveFaviconToDb(((LoadFaviconResult)object2).getBytesForDatabaseStorage());
            return this.pushToCacheAndGetResult((LoadFaviconResult)object2);
        }
        return null;
    }

    private Bitmap pushToCacheAndGetResult(LoadFaviconResult loadFaviconResult) {
        Favicons.putFaviconsInMemCache(this.faviconURL, loadFaviconResult.getBitmaps());
        Bitmap bitmap = Favicons.getSizedFaviconFromCache(this.faviconURL, this.targetWidth);
        return bitmap;
    }

    private static boolean imageIsValid(Bitmap bitmap) {
        return bitmap != null && bitmap.getWidth() > 0 && bitmap.getHeight() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPostExecute(Bitmap bitmap) {
        if (this.isChaining) {
            return;
        }
        this.processResult(bitmap);
        HashMap<String, LoadFaviconTask> hashMap = loadsInFlight;
        synchronized (hashMap) {
            loadsInFlight.remove(this.faviconURL);
        }
        if (this.chainees != null) {
            for (LoadFaviconTask loadFaviconTask : this.chainees) {
                loadFaviconTask.processResult(bitmap);
            }
        }
    }

    private void processResult(Bitmap bitmap) {
        Favicons.removeLoadTask(this.id);
        Bitmap bitmap2 = bitmap;
        if (this.targetWidth != -1 && bitmap != null && bitmap.getWidth() != this.targetWidth) {
            bitmap2 = Favicons.getSizedFaviconFromCache(this.faviconURL, this.targetWidth);
        }
        Favicons.dispatchResult(this.pageUrl, this.faviconURL, bitmap2, this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCancelled() {
        Favicons.removeLoadTask(this.id);
        HashMap<String, LoadFaviconTask> hashMap = loadsInFlight;
        synchronized (hashMap) {
            LoadFaviconTask loadFaviconTask = loadsInFlight.get(this.faviconURL);
            if (loadFaviconTask == this) {
                loadsInFlight.remove(this.faviconURL);
                return;
            }
            if (loadFaviconTask == null) {
                return;
            }
            if (loadFaviconTask.chainees != null) {
                loadFaviconTask.chainees.remove((Object)this);
            }
        }
    }

    private void chainTasks(LoadFaviconTask loadFaviconTask) {
        if (this.chainees == null) {
            this.chainees = new LinkedList();
        }
        this.chainees.add(loadFaviconTask);
    }

    int getId() {
        return this.id;
    }

    static void closeHTTPClient() {
        if (ThreadUtils.isOnBackgroundThread()) {
            if (httpClient != null) {
                httpClient.close();
            }
            return;
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                LoadFaviconTask.closeHTTPClient();
            }
        });
    }
}

