/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.PasswordStretcher;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractSetupActivity;
import org.mozilla.gecko.fxa.activities.FxAccountCreateAccountActivity;
import org.mozilla.gecko.fxa.tasks.FxAccountSignInTask;
import org.mozilla.gecko.sync.setup.activities.ActivityUtils;

public class FxAccountSignInActivity
extends FxAccountAbstractSetupActivity {
    protected static final String LOG_TAG = FxAccountSignInActivity.class.getSimpleName();
    private static final int CHILD_REQUEST_CODE = 3;

    public void onCreate(Bundle bundle) {
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_sign_in);
        this.emailEdit = (AutoCompleteTextView)this.ensureFindViewById(null, R.id.email, "email edit");
        this.passwordEdit = (EditText)this.ensureFindViewById(null, R.id.password, "password edit");
        this.showPasswordButton = (Button)this.ensureFindViewById(null, R.id.show_password, "show password button");
        this.remoteErrorTextView = (TextView)this.ensureFindViewById(null, R.id.remote_error, "remote error text view");
        this.button = (Button)this.ensureFindViewById(null, R.id.button, "sign in button");
        this.progressBar = (ProgressBar)this.ensureFindViewById(null, R.id.progress, "progress bar");
        this.minimumPasswordLength = 1;
        this.createSignInButton();
        this.addListeners();
        this.updateButtonState();
        this.createShowPasswordButton();
        this.linkifyPolicy();
        View view = this.ensureFindViewById(null, R.id.create_account_link, "create account instead link");
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Bundle bundle = FxAccountSignInActivity.this.makeExtrasBundle(null, null);
                FxAccountSignInActivity.this.startActivityInstead(FxAccountCreateAccountActivity.class, 3, bundle);
            }
        });
        this.updateFromIntentExtras();
        TextView textView = (TextView)this.findViewById(R.id.forgot_password_link);
        ActivityUtils.linkTextView(textView, R.string.fxaccount_sign_in_forgot_password, R.string.fxaccount_link_forgot_password);
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        Logger.debug(LOG_TAG, "onActivityResult: " + n);
        if (n != 3 || n2 != -1) {
            super.onActivityResult(n, n2, intent);
            return;
        }
        this.setResult(n2, intent);
        this.finish();
    }

    public void signIn(String string2, String string3) {
        String string4 = this.getAuthServerEndpoint();
        PasswordStretcher passwordStretcher = this.makePasswordStretcher(string3);
        FxAccountAbstractSetupActivity.AddAccountDelegate addAccountDelegate = new FxAccountAbstractSetupActivity.AddAccountDelegate(string2, passwordStretcher, string4){

            public void handleError(Exception exception) {
                FxAccountSignInActivity.this.showRemoteError(exception, R.string.fxaccount_sign_in_unknown_error);
            }

            public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
                FxAccountSignInActivity.this.showRemoteError(fxAccountClientRemoteException, R.string.fxaccount_sign_in_unknown_error);
            }
        };
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        FxAccountClient20 fxAccountClient20 = new FxAccountClient20(string4, executorService);
        try {
            this.hideRemoteError();
            new FxAccountSignInTask((Context)this, this, string2, passwordStretcher, fxAccountClient20, addAccountDelegate).execute(new Void[0]);
        }
        catch (Exception exception) {
            this.showRemoteError(exception, R.string.fxaccount_sign_in_unknown_error);
        }
    }

    protected void createSignInButton() {
        this.button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = FxAccountSignInActivity.this.emailEdit.getText().toString();
                String string3 = FxAccountSignInActivity.this.passwordEdit.getText().toString();
                FxAccountSignInActivity.this.signIn(string2, string3);
            }
        });
    }
}

