/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.Context;
import android.preference.Preference;
import android.util.AttributeSet;
import android.util.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.preferences.CustomListCategory;
import org.mozilla.gecko.preferences.CustomListPreference;
import org.mozilla.gecko.preferences.SearchEnginePreference;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class SearchPreferenceCategory
extends CustomListCategory
implements GeckoEventListener {
    public static final String LOGTAG = "SearchPrefCategory";

    public SearchPreferenceCategory(Context context) {
        super(context);
    }

    public SearchPreferenceCategory(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public SearchPreferenceCategory(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    protected void onAttachedToActivity() {
        super.onAttachedToActivity();
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "SearchEngines:Data");
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("SearchEngines:GetVisible", null));
    }

    protected void onPrepareForRemoval() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "SearchEngines:Data");
    }

    public void setDefault(CustomListPreference customListPreference) {
        super.setDefault(customListPreference);
        this.sendGeckoEngineEvent("SearchEngines:SetDefault", ((Object)customListPreference.getTitle()).toString());
    }

    public void uninstall(CustomListPreference customListPreference) {
        super.uninstall(customListPreference);
        this.sendGeckoEngineEvent("SearchEngines:Remove", ((Object)customListPreference.getTitle()).toString());
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        if (string2.equals("SearchEngines:Data")) {
            JSONArray jSONArray;
            try {
                jSONArray = jSONObject.getJSONArray("searchEngines");
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Unable to decode search engine data from Gecko.", (Throwable)jSONException);
                return;
            }
            this.removeAll();
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    String string3 = jSONObject2.getString("name");
                    final SearchEnginePreference searchEnginePreference = new SearchEnginePreference(this.getContext(), this);
                    searchEnginePreference.setSearchEngineFromJSON(jSONObject2);
                    searchEnginePreference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                        public boolean onPreferenceClick(Preference preference) {
                            SearchEnginePreference searchEnginePreference = (SearchEnginePreference)preference;
                            searchEnginePreference.showDialog();
                            return true;
                        }
                    });
                    this.addPreference(searchEnginePreference);
                    if (i != 0) continue;
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        public void run() {
                            searchEnginePreference.setIsDefault(true);
                        }
                    });
                    this.mDefaultReference = searchEnginePreference;
                    continue;
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOGTAG, (String)("JSONException parsing engine at index " + i), (Throwable)jSONException);
                }
            }
        }
    }

    private void sendGeckoEngineEvent(String string2, String string3) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("engine", (Object)string3);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"JSONException creating search engine configuration change message for Gecko.", (Throwable)jSONException);
            return;
        }
        GeckoAppShell.notifyGeckoOfEvent(GeckoEvent.createBroadcastEvent(string2, jSONObject.toString()));
    }
}

